<?php
// Arquivo: clientes/webhook_asaas.php
require_once '../conexao.php';

// Recebe o aviso do Asaas
$json = file_get_contents('php://input');
$evento = json_decode($json, true);

// Verifica se é um aviso de Pagamento Recebido
if (isset($evento['event']) && $evento['event'] == 'PAYMENT_RECEIVED') {
    
    $pagamento = $evento['payment'];
    
    // Agora o externalReference traz: USUARIO||DIAS_DO_PLANO (Ex: joaozinho||365)
    $referencia = $pagamento['externalReference']; 
    
    // Separa o texto em duas partes
    $partes = explode('||', $referencia);
    $usuario = trim($partes[0]);
    
    // Se não tiver os dias (fatura antiga), ele assume 30 por segurança
    $dias_plano = (isset($partes[1]) && is_numeric($partes[1])) ? (int)$partes[1] : 30;
    
    if (!empty($usuario)) {
        
        // Busca o usuário no banco para saber a data atual
        $stmtUser = $connUser->prepare("SELECT data_premio FROM usuario WHERE usuario = ?");
        $stmtUser->execute([$usuario]);
        $userDados = $stmtUser->fetch();

        if ($userDados) {
            // Calcula a nova data
            $venc_atual = is_numeric($userDados['data_premio']) ? $userDados['data_premio'] : strtotime($userDados['data_premio']);
            
            // Aqui ele soma os dias exatos que vieram do plano escolhido
            if ($venc_atual < time()) {
                $nova_data = strtotime("+$dias_plano days"); 
            } else {
                $nova_data = strtotime("+$dias_plano days", $venc_atual);
            }

            // ATUALIZA NO BANCO DE DADOS (Libera o cliente com a nova data)
            $sql = "UPDATE usuario SET data_premio = ?, bloqueado = 'nao' WHERE usuario = ?";
            $connUser->prepare($sql)->execute([$nova_data, $usuario]);
            
            // (Opcional) Salva no histórico de pagamentos se você tiver essa tabela
            try {
                $connUser->prepare("INSERT INTO pagamentos (id_pagamento_mp, usuario_id, status, valor, data_pagamento) VALUES (?, ?, 'aprovado', ?, NOW())")
                         ->execute([$pagamento['id'], $usuario, $pagamento['value']]);
            } catch (Exception $e) { /* Ignora erro se tabela não existir */ }
        }
    }
}

http_response_code(200); // Responde pro Asaas que entendeu
echo json_encode(["status" => "recebido"]);
?>
