<?php
session_start();
// Apenas Admin
if (!isset($_SESSION['logado']) || $_SESSION['nivel'] !== 'admin') { 
    header("Location: index.php"); exit; 
}

require_once 'conexao.php'; 

// --- 1. BUSCA O SERVIDOR ATIVO ---
$ip_csp = ''; $porta_csp = ''; $user_csp = ''; $pass_csp = '';

try {
    $srv = $connGeral->query("SELECT url, porta, usuario, senha FROM painel WHERE block != 'sim' ORDER BY id DESC LIMIT 1")->fetch(PDO::FETCH_ASSOC);
    if ($srv) {
        $ip_csp = $srv['url']; $porta_csp = $srv['porta']; $user_csp = $srv['usuario']; $pass_csp = $srv['senha'];
    } else {
        $conf = $connGeral->query("SELECT ip_servidor, senha_servidor FROM configuracao WHERE id=1")->fetch(PDO::FETCH_ASSOC);
        if ($conf) {
            $ip_csp = $conf['ip_servidor']; $pass_csp = $conf['senha_servidor']; $user_csp = 'admin'; $porta_csp = '8082'; 
        }
    }
} catch (Exception $e) { }

$online_users = [];
$erro = "";
$debug_log = [];
$xml_bruto = "";

// Função de leitura bruta
function fetch_csp_data($url, $user, $pass) {
    $options = [
        'http' => [
            'method' => "GET",
            'header' => "Authorization: Basic " . base64_encode("$user:$pass") . "\r\n" .
                        "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)\r\n" .
                        "Connection: close\r\n",
            'timeout' => 10,
            'ignore_errors' => true
        ]
    ];
    $context = stream_context_create($options);
    $data = @file_get_contents($url, false, $context);
    
    $code = 0;
    if (isset($http_response_header) && is_array($http_response_header)) {
        if (preg_match('/HTTP\/[\d\.]+ (\d+)/', $http_response_header[0], $matches)) {
            $code = $matches[1];
        }
    }
    return ['code' => $code, 'data' => $data];
}

if (!empty($ip_csp)) {
    
    $comandos = ["proxy-status", "sessions", "status", "users"];
    $xml_escolhido = "";

    foreach ($comandos as $cmd) {
        $url = "http://$ip_csp:$porta_csp/xmlHandler?command=$cmd";
        $res = fetch_csp_data($url, $user_csp, $pass_csp);
        
        $dados = (string)$res['data'];
        $tamanho = strlen($dados);
        $debug_log[] = "Testou comando '$cmd': HTTP {$res['code']} | Leu $tamanho bytes";

        // O PULO DO GATO: Descompacta GZIP na marra se a CSP enviou compactado
        if ($tamanho > 10 && bin2hex(substr($dados, 0, 2)) === '1f8b') {
            $dados_descompactados = @gzdecode($dados);
            if ($dados_descompactados !== false) {
                $dados = $dados_descompactados;
                $debug_log[] = "-> Arquivo binário GZIP detectado. Descompactado com sucesso!";
            } else {
                $debug_log[] = "-> Falha ao tentar descompactar o GZIP.";
            }
        }

        // Se após extrair tem mais de 50 letras e uma tag válida, usamos esse!
        if ($res['code'] == 200 && strlen($dados) > 50 && stripos($dados, '<') !== false) {
            $xml_escolhido = $dados;
            $xml_bruto = $dados;
            $debug_log[] = "-> SUCESSO! Dados lidos corretamente.";
            break;
        }
    }

    if (!empty($xml_escolhido)) {
        
        // Limpa possíveis lixos fora do XML
        $inicio = strpos($xml_escolhido, '<');
        if ($inicio !== false) {
            $xml_escolhido = substr($xml_escolhido, $inicio);
        }
        
        libxml_use_internal_errors(true);
        $xml = @simplexml_load_string($xml_escolhido);
        
        if ($xml) {
            // Scanner Dinâmico
            $sessoes = $xml->xpath('//session');
            if (empty($sessoes)) { $sessoes = $xml->xpath('//user'); }
            if (empty($sessoes)) { $sessoes = $xml->xpath('//client'); }

            if (!empty($sessoes)) {
                foreach ($sessoes as $s) {
                    $raw_user  = (string)($s->name ?? $s->user ?? $s->account ?? '');
                    $raw_ip    = (string)($s->ip ?? $s->{'client-ip'} ?? $s->clientip ?? '');
                    $raw_time  = (string)($s->connected ?? $s->time ?? $s->duration ?? $s->uptime ?? '---');
                    $raw_canal = (string)($s->service ?? $s->channel ?? $s->profile ?? '---');

                    // Só exibe quem for cliente válido
                    if (filter_var($raw_ip, FILTER_VALIDATE_IP) && $raw_user !== '*' && !empty($raw_user)) {
                        
                        $nome_real = $raw_user;
                        try {
                            $stmt = $connUser->prepare("SELECT nome FROM usuario WHERE usuario = ?");
                            $stmt->execute([$raw_user]);
                            $n = $stmt->fetchColumn();
                            if ($n) $nome_real = "$n";
                        } catch(Exception $e){}

                        $online_users[] = [
                            'login' => $raw_user,
                            'nome'  => $nome_real,
                            'ip'    => $raw_ip,
                            'canal' => $raw_canal,
                            'tempo' => $raw_time
                        ];
                    }
                }
            } else {
                $erro = "XML decodificado, mas sem sessões ativas.";
            }
        } else {
            $erros_xml = libxml_get_errors();
            $msg_err = isset($erros_xml[0]) ? $erros_xml[0]->message : 'Sintaxe inválida';
            $erro = "Falha ao ler o formato XML puro. Erro: $msg_err";
        }
    } else {
        $erro = "Os dados recebidos continuam corrompidos ou em branco.";
    }

} else {
    $erro = "Servidor não configurado.";
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Online CSP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background: #151521; color: #fff; font-family: 'Segoe UI', sans-serif; }
        .sidebar { width: 260px; height: 100vh; position: fixed; background: #1e1e2d; padding: 20px; border-right: 1px solid #333; z-index: 1050; }
        .main-content { margin-left: 260px; padding: 30px; }
        .card-custom { background: #1e1e2d; border: 1px solid rgba(255,255,255,0.05); border-radius: 12px; }
        .table-dark { --bs-table-bg: #1e1e2d; }
        .dot-online { width: 10px; height: 10px; background: #28c76f; border-radius: 50%; display: inline-block; box-shadow: 0 0 5px #28c76f; margin-right: 8px; }
        @media (max-width: 992px) { .sidebar{display:none;} .main-content{margin-left:0;} }
    </style>
</head>
<body>

<nav class="sidebar">
    <h4 class="mb-4 fw-bold text-white"><i class="fas fa-tv text-primary"></i> Painel</h4>
    <div class="nav flex-column gap-2">
        <a href="index.php" class="btn btn-dark text-start border-0 py-2"><i class="fas fa-home me-2"></i> Dashboard</a>
        <a href="clientes_online_csp.php" class="btn btn-primary text-start border-0 py-2"><i class="fas fa-wifi me-2"></i> Online CSP</a>
    </div>
</nav>

<main class="main-content">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold">Monitor Online (Unzip Automático)</h3>
        <button onclick="location.reload()" class="btn btn-sm btn-outline-light"><i class="fas fa-sync-alt"></i> Atualizar</button>
    </div>

    <?php if($erro): ?>
        <div class="alert alert-danger">
            <strong>Aviso:</strong> <?= $erro ?><br>
            <hr class="border-danger my-2">
            <small><b>Log de Conexão:</b><br><?= implode("<br>", $debug_log) ?></small>
        </div>
    <?php endif; ?>

    <div class="card card-custom p-4">
        <h5 class="text-success mb-3">
            <i class="fas fa-users"></i> Conectados Agora: <?= count($online_users) ?> 
        </h5>
        
        <div class="table-responsive">
            <table class="table table-dark table-hover align-middle mb-0">
                <thead>
                    <tr class="text-secondary text-uppercase small">
                        <th>Cliente</th>
                        <th>Login</th>
                        <th>IP</th>
                        <th>Canal Assistido</th>
                        <th class="text-end">Tempo</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($online_users)): ?>
                        <tr>
                            <td colspan="5" class="text-center py-4 text-muted">
                                Nenhum cliente conectado no momento.<br>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach($online_users as $u): ?>
                        <tr>
                            <td><div class="d-flex align-items-center"><span class="dot-online"></span> <?= htmlspecialchars($u['nome']) ?></div></td>
                            <td class="text-info fw-bold"><?= htmlspecialchars($u['login']) ?></td>
                            <td class="font-monospace text-white-50"><?= htmlspecialchars($u['ip']) ?></td>
                            <td class="text-warning small"><?= htmlspecialchars($u['canal']) ?></td>
                            <td class="text-end text-success small"><?= htmlspecialchars($u['tempo']) ?></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <?php if(!empty($xml_bruto) && count($online_users) == 0): ?>
            <div class="mt-4 p-3 bg-dark rounded border border-secondary text-white-50" style="font-size:12px;">
                <p class="mb-1 text-warning"><i class="fas fa-terminal"></i> Debug: Arquivo extraído com sucesso! Veja o conteúdo que o servidor enviou:</p>
                <textarea class="form-control bg-dark text-muted border-0" rows="12" readonly><?= htmlspecialchars($xml_bruto, ENT_SUBSTITUTE, 'UTF-8') ?></textarea>
            </div>
        <?php endif; ?>
    </div>
</main>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
