<?php
// Configuração de Fuso Horário (Importante para logs e vencimentos)
date_default_timezone_set('America/Sao_Paulo');

$host = 'localhost'; // Geralmente é localhost mesmo em hospedagem

// ---------------------------------------------------------
// 1. BANCO DE DADOS: GERAL (Configurações, Perfis, SMTP)
// ---------------------------------------------------------
$db_geral_nome = 'geral';
$db_geral_user = 'admin';
$db_geral_pass = '102030#';

// ---------------------------------------------------------
// 2. BANCO DE DADOS: ACESSOS (Logs, Status, Permissões)
// ---------------------------------------------------------
$db_acessos_nome = 'acessos';
$db_acessos_user = 'admin';
$db_acessos_pass = '102030#';

// ---------------------------------------------------------
// 3. BANCO DE DADOS: USER (Clientes, Revendas, Testes)
// ---------------------------------------------------------
$db_user_nome = 'user';
$db_user_user = 'admin';
$db_user_pass = '102030#';


/**
 * Função genérica para conectar ao banco via PDO
 */
function conectarBanco($host, $db_nome, $db_user, $db_pass) {
    try {
        // DSN define o driver, host, nome do banco e charset
        $dsn = "mysql:host=$host;dbname=$db_nome;charset=utf8mb4";
        
        $opcoes = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, // Mostra erros de SQL
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC, // Traz dados como array associativo
            PDO::ATTR_EMULATE_PREPARES => false, // Segurança contra SQL Injection
        ];

        return new PDO($dsn, $db_user, $db_pass, $opcoes);

    } catch (PDOException $e) {
        // Mostra erro caso a conexão falhe
        die("<div style='color:white;background:red;padding:10px;text-align:center'>Erro ao conectar no banco <b>$db_nome</b>: " . $e->getMessage() . "</div>");
    }
}

// ---------------------------------------------------------
// CRIAÇÃO DAS CONEXÕES GLOBAIS
// ---------------------------------------------------------

try {
    // Variável $connGeral -> Use para tabelas: perfil, email_adicionar, email_modelo, mascaraurl
    $connGeral = conectarBanco($host, $db_geral_nome, $db_geral_user, $db_geral_pass);

    // Variável $connAcessos -> Use para tabelas: opcoes (permissões), status, logs
    $connAcessos = conectarBanco($host, $db_acessos_nome, $db_acessos_user, $db_acessos_pass);

    // Variável $connUser -> Use para tabelas: usuario, rev, teste, rev_perfil
    $connUser = conectarBanco($host, $db_user_nome, $db_user_user, $db_user_pass);

} catch (Exception $e) {
    die("Erro Crítico de Sistema: " . $e->getMessage());
}
?>
