<?php
session_start();
// Verifica se está logado
if (!isset($_SESSION['logado'])) { header("Location: login.php"); exit; }
require_once 'conexao.php';

$msg = "";
$msg_tipo = "";
$usuario_logado = $_SESSION['usuario'];

// --- PROCESSAR O SALVAMENTO ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // 1. Verifica se o usuário já tem configuração salva
        $check = $connUser->prepare("SELECT id FROM configuracoes_pagamento WHERE usuario_painel = :user");
        $check->execute([':user' => $usuario_logado]);
        $existe = $check->rowCount() > 0;

        // 2. Prepara os dados limpos
        $dados = [
            ':user'    => $usuario_logado,
            ':banco'   => trim($_POST['banco']),
            ':titular' => trim($_POST['titular']),
            ':agencia' => trim($_POST['agencia']),
            ':conta'   => trim($_POST['conta']),
            ':pix'     => trim($_POST['pix'])
        ];

        // 3. Executa INSERT ou UPDATE separado (Isso corrige o erro HY093)
        if ($existe) {
            $sql = "UPDATE configuracoes_pagamento 
                    SET banco = :banco, titular = :titular, agencia = :agencia, conta = :conta, pix = :pix 
                    WHERE usuario_painel = :user";
        } else {
            $sql = "INSERT INTO configuracoes_pagamento (usuario_painel, banco, titular, agencia, conta, pix) 
                    VALUES (:user, :banco, :titular, :agencia, :conta, :pix)";
        }

        $stmt = $connUser->prepare($sql);
        
        if ($stmt->execute($dados)) {
            $msg = "Dados salvos com sucesso!";
            $msg_tipo = "success";
        } else {
            $msg = "Erro ao gravar no banco.";
            $msg_tipo = "danger";
        }

    } catch (PDOException $e) {
        $msg = "Erro técnico: " . $e->getMessage();
        $msg_tipo = "danger";
    }
}

// --- BUSCAR DADOS PARA EXIBIR ---
// Busca novamente para mostrar o formulário preenchido
$stmt = $connUser->prepare("SELECT * FROM configuracoes_pagamento WHERE usuario_painel = ?");
$stmt->execute([$usuario_logado]);
$config = $stmt->fetch(PDO::FETCH_ASSOC);

// Se não tiver dados, inicia array vazio para não dar erro no HTML
if (!$config) $config = [];
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurações | Painel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --bg-body: #151521; --bg-card: #1e1e2d; --primary: #7367f0; }
        body { background: var(--bg-body); color: #fff; font-family: 'Segoe UI', sans-serif; }
        
        .sidebar { width: 260px; height: 100vh; position: fixed; background: #1e1e2d; padding: 20px; border-right: 1px solid #333; transition: 0.3s; z-index: 1000; }
        .main-content { margin-left: 260px; padding: 30px; transition: 0.3s; }

        /* Estilo dos Labels (Nomes dos campos) */
        .form-label { 
            color: #ffffff !important; 
            font-weight: 600; 
            margin-top: 10px;
            font-size: 1rem;
        }

        .card-custom { background: var(--bg-card); border: 1px solid rgba(255,255,255,0.1); border-radius: 12px; padding: 25px; }
        .form-control { background: #2b2b40 !important; border: 1px solid #444 !important; color: #fff !important; height: 45px; }
        
        /* Botão Salvar */
        .btn-salvar { background-color: var(--primary); border: none; padding: 12px; font-weight: bold; width: 100%; margin-top: 20px; }
        .btn-salvar:hover { background-color: #5e50ee; }

        @media (max-width: 768px) {
            .sidebar { transform: translateX(-100%); }
            .sidebar.show { transform: translateX(0); }
            .main-content { margin-left: 0; padding: 15px; }
            .mobile-toggle { display: block !important; }
        }
        .mobile-toggle { display: none; font-size: 1.5rem; color: #fff; background: none; border: none; margin-bottom: 20px; }
        .nav-link { color: #a6a6b7; text-decoration: none; display: flex; align-items: center; gap: 10px; padding: 10px; border-radius: 8px; }
        .nav-link.active { background: var(--primary); color: #fff; }
    </style>
</head>
<body>

<nav class="sidebar" id="sidebar">
    <h4 class="mb-4 fw-bold text-white"><i class="fas fa-tv text-primary"></i> Painel v3.0</h4>
    <div class="nav flex-column gap-2">
        <a href="index.php" class="nav-link text-white"><i class="fas fa-home"></i> Dashboard</a>
        <a href="clientes.php" class="nav-link text-white"><i class="fas fa-users"></i> Clientes</a>
        <a href="testes.php" class="nav-link text-white"><i class="fas fa-stopwatch"></i> Testes</a>
        <a href="configuracoes.php" class="nav-link active text-white"><i class="fas fa-cog"></i> Configurações</a>
        <a href="sair.php" class="nav-link text-danger mt-4"><i class="fas fa-sign-out-alt"></i> Sair</a>
    </div>
</nav>

<main class="main-content">
    <button class="mobile-toggle" onclick="document.getElementById('sidebar').classList.toggle('show')"><i class="fas fa-bars"></i></button>

    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card card-custom">
                <h4 class="text-primary mb-2">Meus Dados de Recebimento</h4>
                <p class="text-muted small mb-4">Esses dados aparecerão nas mensagens de cobrança.</p>
                
                <?php if($msg): ?>
                    <div class="alert alert-<?= $msg_tipo ?> alert-dismissible fade show" role="alert">
                        <?= $msg ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label">Seu Banco</label>
                        <input type="text" name="banco" class="form-control" value="<?= htmlspecialchars($config['banco'] ?? '') ?>" placeholder="Ex: NuBank">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Titular da Conta</label>
                        <input type="text" name="titular" class="form-control" value="<?= htmlspecialchars($config['titular'] ?? '') ?>" placeholder="Seu nome">
                    </div>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label">Agência</label>
                            <input type="text" name="agencia" class="form-control" value="<?= htmlspecialchars($config['agencia'] ?? '') ?>">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label">Conta</label>
                            <input type="text" name="conta" class="form-control" value="<?= htmlspecialchars($config['conta'] ?? '') ?>">
                        </div>
                    </div>
                    <div class="mb-4">
                        <label class="form-label">Chave PIX</label>
                        <input type="text" name="pix" class="form-control" value="<?= htmlspecialchars($config['pix'] ?? '') ?>" placeholder="CPF, E-mail ou Celular">
                    </div>
                    
                    <button type="submit" class="btn btn-primary btn-salvar">
                        <i class="fas fa-save me-2"></i> Salvar Meus Dados
                    </button>
                </form>
            </div>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
