<?php
// ARQUIVO: consertar_pagamento.php
require_once 'conexao.php';
@set_time_limit(0);

echo "<h1>💰 REPARO DO MÓDULO DE PAGAMENTO</h1>";
echo "<p>Corrigindo o erro 'Unknown column usuario_painel'...</p><hr>";

try {
    // 1. GARANTE QUE A TABELA EXISTE
    $sql_create = "CREATE TABLE IF NOT EXISTS configuracoes_pagamento (
        id INT AUTO_INCREMENT PRIMARY KEY,
        access_token VARCHAR(255),
        public_key VARCHAR(255),
        client_id VARCHAR(255),
        client_secret VARCHAR(255),
        valor_padrao DECIMAL(10,2) DEFAULT 30.00,
        tipo VARCHAR(50) DEFAULT 'mercadopago'
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    $connUser->exec($sql_create);

    // 2. ADICIONA A COLUNA QUE O ERRO PEDE: 'usuario_painel'
    try {
        $connUser->exec("ALTER TABLE configuracoes_pagamento ADD COLUMN usuario_painel VARCHAR(100) DEFAULT NULL");
        echo "<div style='color:green'>✔ Coluna <b>usuario_painel</b> criada com sucesso.</div>";
    } catch (Exception $e) {
        // Ignora se já existe
        echo "<div style='color:blue'>Info: Coluna usuario_painel já existia ou erro menor.</div>";
    }

    // 3. ADICIONA OUTRAS COLUNAS IMPORTANTES (Para garantir que não dê erro depois)
    $colunas_extras = [
        "pix_chave VARCHAR(255) DEFAULT NULL", // Para pix manual
        "pix_tipo VARCHAR(50) DEFAULT NULL",   // CPF, CNPJ, Email...
        "ativo INT(1) DEFAULT 1"               // Para ligar/desligar
    ];

    foreach ($colunas_extras as $col) {
        try {
            $connUser->exec("ALTER TABLE configuracoes_pagamento ADD COLUMN $col");
        } catch (Exception $e) {}
    }

    // 4. PREENCHE DADOS VAZIOS
    // Se você estiver logado, ele tenta usar seu login. Se não, usa 'admin'.
    session_start();
    $dono_atual = isset($_SESSION['usuario']) ? $_SESSION['usuario'] : 'admin';

    // Se a tabela estiver vazia, cria um registro padrão
    $check = $connUser->query("SELECT count(*) FROM configuracoes_pagamento")->fetchColumn();
    if ($check == 0) {
        $stmt = $connUser->prepare("INSERT INTO configuracoes_pagamento (usuario_painel, valor_padrao, tipo) VALUES (?, 30.00, 'mercadopago')");
        $stmt->execute([$dono_atual]);
        echo "<div style='color:green'>✔ Registro padrão de pagamento criado para <b>$dono_atual</b>.</div>";
    } else {
        // Se já existe mas o usuario_painel está vazio, preenche
        $stmt = $connUser->prepare("UPDATE configuracoes_pagamento SET usuario_painel = ? WHERE usuario_painel IS NULL OR usuario_painel = ''");
        $stmt->execute([$dono_atual]);
        echo "<div style='color:green'>✔ Registros existentes vinculados ao usuário <b>$dono_atual</b>.</div>";
    }

    echo "<hr><h1 style='color:green'>PRONTO!</h1>";
    echo "<p>A coluna que faltava foi criada. O erro deve sumir.</p>";
    echo "<a href='configuracoes.php' style='background:#7367f0; color:white; padding:10px 20px; text-decoration:none; border-radius:5px;'>Voltar para Configurações</a>";

} catch (Exception $e) {
    echo "<h2 style='color:red'>Erro Fatal: " . $e->getMessage() . "</h2>";
    echo "<p>Verifique se o arquivo conexao.php está correto.</p>";
}
?>
