<?php
require_once 'conexao.php';
@set_time_limit(0);

echo "<body style='background:#151521; color:#fff; font-family:sans-serif; padding:20px;'>";
echo "<h2>🔄 Sincronizando Dados Existentes...</h2><hr>";

try {
    // 1. CORRIGIR DATAS (De 'vencimento' ou 'expire_date' para 'data_premio')
    // Tentamos identificar qual coluna sua tem a data real e passamos para a oficial do painel
    $colunas_data = ['vencimento', 'expire_date', 'exp_date', 'validade'];
    
    foreach ($colunas_data as $col) {
        // Tenta converter se for número Unix (ex: 1742000000)
        $sql1 = "UPDATE usuario SET data_premio = FROM_UNIXTIME(`$col`, '%Y-%m-%d') 
                 WHERE `$col` > 1000000 AND (`$col` NOT LIKE '%/%') 
                 AND (data_premio IS NULL OR data_premio < '2020-01-01')";
        $connUser->exec($sql1);

        // Tenta converter se for texto BR (ex: 15/03/2026)
        $sql2 = "UPDATE usuario SET data_premio = STR_TO_DATE(`$col`, '%d/%m/%Y') 
                 WHERE `$col` LIKE '%/%/%' 
                 AND (data_premio IS NULL OR data_premio < '2020-01-01')";
        $connUser->exec($sql2);
    }
    echo "<div style='color:#28c76f'>✔ Datas de vencimento sincronizadas.</div>";

    // 2. VINCULAR PERFIS (Se a coluna 'perfil' tem texto, mas o 'id_perfil' está 0)
    // Isso faz com que os perfis voltem a aparecer na lista
    $connUser->exec("UPDATE usuario SET id_perfil = 1 WHERE (id_perfil IS NULL OR id_perfil = 0)");
    echo "<div style='color:#28c76f'>✔ Vinculação de perfis ativada.</div>";

    // 3. CORRIGIR PROPRIEDADE (Dono e Limite)
    // Garante que os clientes apareçam para o administrador 'admin'
    $connUser->exec("UPDATE usuario SET dono = 'admin' WHERE dono IS NULL OR dono = ''");
    $connUser->exec("UPDATE usuario SET limite = 1 WHERE limite IS NULL OR limite = 0");
    echo "<div style='color:#28c76f'>✔ Permissões de administrador corrigidas.</div>";

    // 4. LIMPEZA DE SEGURANÇA (Evita o erro de 1969 para quem sobrou)
    $connUser->exec("UPDATE usuario SET data_premio = DATE_ADD(CURDATE(), INTERVAL 30 DAY) 
                     WHERE data_premio < '2020-01-01' OR data_premio IS NULL");
    echo "<div style='color:#28c76f'>✔ Limpeza de datas inválidas concluída.</div>";

    echo "<hr><h1 style='color:#28c76f'>✅ TUDO OK!</h1>";
    echo "<p>As informações que já estavam no banco foram organizadas para o novo padrão.</p>";
    echo "<a href='clientes.php' style='background:#7367f0; color:#fff; padding:10px 20px; text-decoration:none; border-radius:5px;'>Ver Clientes</a>";

} catch (Exception $e) {
    echo "<div style='color:#ea5455'>❌ Erro: " . $e->getMessage() . "</div>";
}
?>
