<?php
// ARQUIVO: corrigir_datas.php
require_once 'conexao.php';

// Aumenta o tempo para rodar em muitos clientes
set_time_limit(0);

echo "<h2>🛠️ Corretor de Datas (1969 -> Data Real)</h2>";
echo "<p>Analisando banco de dados...</p><hr>";

try {
    // Busca todos os usuários
    $sql = "SELECT id, usuario, data_premio FROM usuario";
    $stmt = $connUser->query($sql);
    $usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $contagem_arrumados = 0;
    $contagem_erros = 0;

    foreach ($usuarios as $u) {
        $id = $u['id'];
        $user = $u['usuario'];
        $data_original = $u['data_premio'];
        $nova_data = '';

        // CASO 1: A data é um NÚMERO GRANDE (Timestamp) ex: 1745689000
        // Essa é a causa mais provável do erro 1969
        if (is_numeric($data_original) && $data_original > 100000000) {
            $nova_data = date('Y-m-d', $data_original);
            echo "Usuario: <b>$user</b> | Era Timestamp ($data_original) -> Virou: <b style='color:green'>$nova_data</b><br>";
        }
        
        // CASO 2: A data está vazia ou zerada (0)
        elseif (empty($data_original) || $data_original == '0') {
            // Se estiver vazio, não temos como adivinhar, vamos avisar
            echo "Usuario: <b>$user</b> | <span style='color:red'>Data vazia. Defina manualmente no painel.</span><br>";
            continue;
        }

        // CASO 3: Data já está correta (Y-m-d)
        elseif (strpos($data_original, '-') !== false && strlen($data_original) == 10) {
            // Já está certo (ex: 2026-02-14), ignora
            continue;
        }

        // SE ENCONTROU UMA NOVA DATA PARA ATUALIZAR
        if (!empty($nova_data)) {
            $upd = $connUser->prepare("UPDATE usuario SET data_premio = ? WHERE id = ?");
            $upd->execute([$nova_data, $id]);
            $contagem_arrumados++;
        }
    }

    echo "<hr><h3>Resultado:</h3>";
    echo "<p><b>$contagem_arrumados</b> clientes corrigidos com sucesso.</p>";
    
    if ($contagem_arrumados == 0) {
        echo "<div style='background: #fff3cd; padding: 10px; border: 1px solid #ffeeba;'>";
        echo "<b>⚠️ Nenhuma data foi corrigida?</b><br>";
        echo "Isso pode significar que o nome da coluna no banco antigo era diferente.<br>";
        echo "Verifique no <b>phpMyAdmin</b> na tabela <b>usuario</b> se a coluna <b>data_premio</b> tem números dentro ou se está vazia (NULL).";
        echo "</div>";
    } else {
        echo "<p><a href='clientes.php'>Voltar para Clientes</a></p>";
    }

} catch (Exception $e) {
    echo "Erro: " . $e->getMessage();
}
?>
