<?php
// Este arquivo deve ser chamado pelo CRON JOB (cPanel)
// Exemplo: /usr/local/bin/php /home/seu_usuario/public_html/painelcs/cron_backup.php

require_once 'conexao.php';
require_once 'funcao_backup.php';

// 1. Verifica se a automação está ativa
$config = $connGeral->query("SELECT * FROM backup_automatizado WHERE id=1")->fetch(PDO::FETCH_ASSOC);

if (!$config || $config['status'] !== 'ativo') {
    die("Backup automatico desativado.");
}

// 2. Verifica se está na hora de rodar
$hora_agendada = $config['horario']; // Ex: 03:00
$hora_agora = date('H:i');

// Verifica se já existe backup HOJE com o tipo 'Automatico'
$ja_fez_hoje = $connGeral->query("SELECT id FROM arquivo_backup WHERE tipo='Automatico' AND DATE(data) = CURDATE()")->fetch();

if (!$ja_fez_hoje && $hora_agora >= $hora_agendada) {
    // Executa o backup
    if (gerarBackupCompleto('Automatico')) {
        echo "Backup Automatico realizado com sucesso em " . date('d/m/Y H:i:s');
    } else {
        echo "Erro ao gerar backup automatico.";
    }
} else {
    echo "Ainda nao eh hora ou ja foi feito hoje.";
}
?>
