<?php
// Evita acesso direto
if (basename($_SERVER['PHP_SELF']) == basename(__FILE__)) { exit; }

// Aumenta tempo e memória para aguentar hospedagem lenta
@ini_set('memory_limit', '1024M');
@set_time_limit(0);
@ignore_user_abort(true);

function gerarBackupCompleto($tipo = 'Manual') {
    global $connGeral; 

    // --- 1. CONFIGURAÇÃO DOS BANCOS (Edite conforme sua hospedagem) ---
    $db_host = 'localhost';

    // Se estiver na VPS, a senha geralmente é a mesma.
    // Se estiver na Hospedagem, confirme se o usuário tem acesso aos 3 bancos.
    $config_bancos = [
        [
            'id'   => 'USER',
            'nome' => 'geanrober_painel_user',
            'user' => 'geanrober_painel_user',
            'pass' => 'Jean#909110'
        ],
        [
            'id'   => 'GERAL',
            'nome' => 'geanrober_painel_geral',
            'user' => 'geanrober_painel_geral',
            'pass' => 'Jean#909110'
        ],
        [
            'id'   => 'ACESSOS',
            'nome' => 'geanrober_painel_acessos',
            'user' => 'geanrober_painel_acessos',
            'pass' => 'Jean#909110'
        ]
    ];

    // Verifica se a função exec está liberada (VPS) ou bloqueada (Hospedagem)
    $modo_vps = function_exists('exec') && !in_array('exec', array_map('trim', explode(',', ini_get('disable_functions'))));

    // Prepara pasta
    $pasta_backups = __DIR__ . "/backups/";
    if (!is_dir($pasta_backups)) { mkdir($pasta_backups, 0755, true); }

    $sucesso_algum = false; 

    // --- LOOP: GERA UM ARQUIVO PARA CADA BANCO ---
    foreach ($config_bancos as $info_db) {
        
        $dbname = $info_db['nome'];
        $dbuser = $info_db['user'];
        $dbpass = $info_db['pass'];
        $tag    = $info_db['id'];
        
        $data_hora      = date('d-m-Y_H-i-s');
        $nome_sql_temp  = $pasta_backups . strtolower($tag) . ".sql";
        $nome_zip_final = "Backup_" . ucfirst(strtolower($tag)) . "_{$data_hora}.zip";
        $caminho_zip    = $pasta_backups . $nome_zip_final;

        $sql_gerado = false;

        // --- TENTATIVA 1: MODO VPS (RÁPIDO) ---
        if ($modo_vps) {
            $cmd = "mysqldump --no-tablespaces --single-transaction -h'$db_host' -u'$dbuser' -p'$dbpass' '$dbname' > '$nome_sql_temp' 2>&1";
            exec($cmd, $output, $return_var);
            
            if ($return_var === 0 && file_exists($nome_sql_temp) && filesize($nome_sql_temp) > 0) {
                $sql_gerado = true;
            }
        }

        // --- TENTATIVA 2: MODO HOSPEDAGEM (PHP PURO) ---
        // Se não for VPS ou se o comando falhou, usa o método PHP
        if (!$sql_gerado) {
            $sql_gerado = exportarSqlPhp($db_host, $dbuser, $dbpass, $dbname, $nome_sql_temp);
        }

        // --- CRIAÇÃO DO ZIP E REGISTRO ---
        if ($sql_gerado && file_exists($nome_sql_temp)) {
            $zip = new ZipArchive();
            if ($zip->open($caminho_zip, ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
                $zip->addFile($nome_sql_temp, strtolower($tag) . ".sql");
                $zip->close();
                @unlink($nome_sql_temp); // Limpa SQL

                // Salva no Banco de Dados do Painel
                registrarBackupNoBanco($tipo, $tag, $nome_zip_final, $caminho_zip, $config_bancos);
                $sucesso_algum = true;
            }
        }
    }

    return $sucesso_algum;
}

// --- FUNÇÃO AUXILIAR: MODO HOSPEDAGEM (PHP PURO) ---
function exportarSqlPhp($host, $user, $pass, $name, $arquivo_saida) {
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$name;charset=utf8mb4", $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    } catch (Exception $e) { return false; }

    $f = fopen($arquivo_saida, 'w+');
    if (!$f) return false;

    fwrite($f, "-- BACKUP PHP: $name \n\n");
    
    $tabelas = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    foreach ($tabelas as $tab) {
        // Estrutura
        $create = $pdo->query("SHOW CREATE TABLE `$tab`")->fetch(PDO::FETCH_NUM);
        fwrite($f, "DROP TABLE IF EXISTS `$tab`;\n");
        fwrite($f, $create[1] . ";\n\n");

        // Dados
        $rows = $pdo->query("SELECT * FROM `$tab`");
        while ($row = $rows->fetch(PDO::FETCH_ASSOC)) {
            $vals = [];
            foreach ($row as $val) {
                $vals[] = is_null($val) ? "NULL" : "'" . addslashes($val) . "'";
            }
            fwrite($f, "INSERT INTO `$tab` VALUES(" . implode(",", $vals) . ");\n");
        }
        fwrite($f, "\n");
    }
    fclose($f);
    return true;
}

// --- FUNÇÃO AUXILIAR: REGISTRAR NO BANCO ---
function registrarBackupNoBanco($tipo, $tag, $nome_arquivo, $caminho_completo, $configs) {
    global $connGeral;
    
    // Se conexão global caiu, reconecta usando o banco GERAL da config
    if (!isset($connGeral)) {
        try {
            $connGeral = new PDO("mysql:host=localhost;dbname={$configs[1]['nome']}", $configs[1]['user'], $configs[1]['pass']);
        } catch (Exception $e) { return; }
    }

    $tamanho = filesize($caminho_completo);
    $tamanho_fmt = ($tamanho > 1048576) ? round($tamanho/1048576, 2)." MB" : round($tamanho/1024, 2)." KB";
    $tipo_desc = $tipo . ' (' . ucfirst(strtolower($tag)) . ')';

    try {
        $stmt = $connGeral->prepare("INSERT INTO arquivo_backup (tipo, local, data, size) VALUES (?, ?, NOW(), ?)");
        $stmt->execute([$tipo_desc, $nome_arquivo, $tamanho_fmt]);
    } catch (Exception $e) { }
}
?>
