<?php
// Evita acesso direto
if (basename($_SERVER['PHP_SELF']) == basename(__FILE__)) { exit; }

// Configurações de tempo e memória
@ini_set('memory_limit', '512M');
@set_time_limit(0); 
@ignore_user_abort(true);

function gerarBackupCompleto($tipo = 'Manual') {
    global $connGeral; 
    
    // Configuração dos 3 Bancos
    $db_host = 'localhost';
    
    $config_bancos = [
        [
            'id' => 'USER', // Identificador visual
            'nome' => 'geanrober_painel_user',
            'user' => 'geanrober_painel_user',
            'pass' => 'Jean#909110'
        ],
        [
            'id' => 'GERAL',
            'nome' => 'geanrober_painel_geral',
            'user' => 'geanrober_painel_geral',
            'pass' => 'Jean#909110'
        ],
        [
            'id' => 'ACESSOS',
            'nome' => 'geanrober_painel_acessos',
            'user' => 'geanrober_painel_acessos',
            'pass' => 'Jean#909110'
        ]
    ];

    $pasta_backups = __DIR__ . "/backups/";
    if (!is_dir($pasta_backups)) { mkdir($pasta_backups, 0755, true); }

    $sucesso_total = true;

    // --- LOOP: GERA UM ARQUIVO PARA CADA BANCO ---
    foreach ($config_bancos as $info_db) {
        
        $dbname = $info_db['nome'];
        $tag    = $info_db['id'];
        
        // Nomes de arquivo exclusivos para este banco
        $data_hora = date('Y-m-d_H-i-s');
        $nome_sql_temp = $pasta_backups . "temp_{$tag}.sql";
        $nome_zip_final = "backup_{$tag}_{$data_hora}.zip";
        $caminho_zip = $pasta_backups . $nome_zip_final;

        // 1. GERA O SQL (STREAMING)
        $handle = fopen($nome_sql_temp, 'w+');
        if (!$handle) { $sucesso_total = false; continue; }

        fwrite($handle, "-- BACKUP INDIVIDUAL: $tag ($dbname)\n");
        fwrite($handle, "-- DATA: " . date('d/m/Y H:i:s') . "\n\n");

        try {
            $connAtual = new PDO("mysql:host=$db_host;dbname=$dbname;charset=utf8mb4", $info_db['user'], $info_db['pass']);
            $connAtual->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            fclose($handle);
            $sucesso_total = false;
            continue;
        }

        $tabelas = $connAtual->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);

        foreach ($tabelas as $tabela) {
            $create = $connAtual->query("SHOW CREATE TABLE `$tabela`")->fetch(PDO::FETCH_NUM);
            fwrite($handle, "DROP TABLE IF EXISTS `$tabela`;\n");
            fwrite($handle, $create[1] . ";\n\n");

            // Paginação 1000 linhas
            $total = $connAtual->query("SELECT COUNT(*) FROM `$tabela`")->fetchColumn();
            $lote = 1000; $offset = 0;
            while ($offset < $total) {
                $stmt = $connAtual->query("SELECT * FROM `$tabela` LIMIT $lote OFFSET $offset");
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    $vals = [];
                    foreach ($row as $val) {
                        if (is_null($val)) $vals[] = "NULL";
                        else {
                            $val = addslashes($val);
                            $val = str_replace(["\n", "\r"], ["\\n", "\\r"], $val);
                            $vals[] = "'$val'";
                        }
                    }
                    fwrite($handle, "INSERT INTO `$tabela` VALUES(" . implode(",", $vals) . ");\n");
                }
                $offset += $lote;
                $stmt = null;
                if ($offset % 5000 == 0) gc_collect_cycles();
            }
            fwrite($handle, "\n");
        }
        fclose($handle);
        $connAtual = null;

        // 2. CRIA O ZIP DESTE BANCO
        $zip = new ZipArchive();
        if ($zip->open($caminho_zip, ZipArchive::CREATE) === TRUE) {
            // O nome dentro do zip será simples: user.sql, geral.sql, etc.
            $zip->addFile($nome_sql_temp, strtolower($tag) . ".sql");
            $zip->close();
            @unlink($nome_sql_temp); // Apaga o SQL temp

            // 3. SALVA NO BANCO GERAL (UMA LINHA PARA CADA ARQUIVO)
            try { $connGeral->query("SELECT 1"); } catch (Exception $e) { require 'conexao.php'; }
            
            $tamanho = filesize($caminho_zip);
            $tamanho_fmt = ($tamanho > 1048576) ? round($tamanho/1048576, 2)." MB" : round($tamanho/1024, 2)." KB";

            // CORREÇÃO: Removido 'link_externo' para evitar o erro de coluna inexistente
            $stmt = $connGeral->prepare("INSERT INTO arquivo_backup (tipo, local, data, size) VALUES (?, ?, NOW(), ?)");
            $stmt->execute([$tipo, $nome_zip_final, $tamanho_fmt]);

        } else {
            $sucesso_total = false;
        }
    }

    return $sucesso_total;
}