<?php
@session_start();
$revendedor_logado = $_SESSION['login'] ?? $_SESSION['usuario'] ?? $_SESSION['user'] ?? 'admin';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Gerador de Robô</title>
    <style>
        /* Fundo escuro cobrindo a página inteira */
        html, body {
            background-color: #151822; /* Azul super escuro */
            margin: 0;
            padding: 0;
            min-height: 100vh; /* Altura máxima da tela */
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            display: flex;
            justify-content: center;
            align-items: flex-start;
        }

        * { box-sizing: border-box; }
        
        /* Estilo do Cartão no Computador */
        .meu-card-dark {
            background: #202433; 
            border-radius: 12px;
            padding: 30px;
            color: #e0e6ed;
            width: 100%;
            max-width: 500px;
            margin: 40px 20px; /* Espaço em volta no PC */
            border: 1px solid #2d3345;
            box-shadow: 0 10px 25px rgba(0,0,0,0.3);
        }
        
        .meu-card-dark h3 { text-align: center; margin-top: 0; color: #ffffff; font-size: 1.4rem; }
        .meu-card-dark p { text-align: center; color: #a0a6b5; font-size: 0.95rem; margin-bottom: 25px; line-height: 1.4; }
        
        .meu-card-dark label { font-weight: bold; margin-bottom: 8px; display: block; color: #cbd5e1; font-size: 0.95rem; }
        .meu-card-dark input[type="text"] {
            width: 100%;
            padding: 14px;
            border-radius: 6px;
            border: 1px solid #3b4256;
            background-color: #151822;
            color: #ffffff;
            font-size: 1rem;
            margin-bottom: 12px;
            -webkit-appearance: none;
        }
        .meu-card-dark input[type="text"]:focus {
            border-color: #0d6efd;
            outline: 0;
        }
        
        .meu-card-dark input[readonly]#revendedor {
            background-color: #1a1d29;
            color: #64748b;
        }
        
        .meu-card-dark .aviso {
            background-color: #2d3345;
            padding: 12px;
            border-radius: 6px;
            font-size: 0.85rem;
            color: #cbd5e1;
            margin-bottom: 20px;
            border-left: 4px solid #0d6efd;
            line-height: 1.4;
        }

        .btn-salvar {
            background: #10b981;
            color: white;
            border: none;
            padding: 14px 20px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 1.05rem;
            font-weight: bold;
            transition: 0.2s;
            width: 100%;
            margin-bottom: 30px;
            -webkit-tap-highlight-color: transparent;
        }
        .btn-salvar:hover { background: #059669; }

        .meu-card-dark .linha-link {
            display: flex;
            gap: 10px;
            width: 100%;
            margin-top: 10px;
        }
        .meu-card-dark .linha-link input {
            flex: 1;
            margin-bottom: 0;
            background-color: #151822;
            color: #0ea5e9;
            font-family: monospace;
            font-size: 0.9rem;
        }
        .meu-card-dark .btn-copiar {
            background: #0d6efd;
            color: white;
            border: none;
            padding: 0 20px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 1.05rem;
            font-weight: bold;
            transition: 0.2s;
            white-space: nowrap;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .meu-card-dark .btn-copiar:hover { background: #0b5ed7; }
        .meu-card-dark .btn-copiar.copiado { background: #10b981; }

        /* ========================================= */
        /* MÁGICA: TELA CHEIA ESCURA NO CELULAR      */
        /* ========================================= */
        @media (max-width: 480px) {
            html, body { 
                background-color: #202433; /* Fundo do corpo igual ao cartão */
            }
            .meu-card-dark { 
                margin: 0; 
                border-radius: 0; 
                border: none; 
                box-shadow: none; 
                padding: 25px 20px; 
                min-height: 100vh; /* Ocupa do topo até o fim da tela */
            }
            .meu-card-dark .linha-link { flex-direction: column; }
            .meu-card-dark .btn-copiar { padding: 14px; width: 100%; margin-top: 8px; }
            .meu-card-dark input[type="text"] { font-size: 16px; } 
        }
    </style>
</head>
<body>

<div class="meu-card-dark">
    <h3>🤖 Robô WhatsAuto</h3>
    <p>Gere o seu link exclusivo para automatizar a entrega de testes CS.</p>

    <label>1. Seu Usuário (Automático):</label>
    <input type="text" id="revendedor" value="<?= htmlspecialchars($revendedor_logado) ?>" readonly>

    <label>2. Sua Palavra-chave:</label>
    <div class="aviso">ℹ️ A palavra que o cliente deve digitar. (Ex: <b>teste cs</b>)</div>
    <input type="text" id="palavra" placeholder="Digite a palavra chave aqui...">

    <button type="button" class="btn-salvar" id="btn_salvar" onclick="salvarPalavra()">💾 Salvar e Gerar Link</button>

    <label>🔗 Seu Link Exclusivo (Copie e cole no app):</label>
    <div class="linha-link">
        <input type="text" id="link_gerado" readonly placeholder="Clique em Salvar para gerar...">
        <button type="button" class="btn-copiar" id="btn_copiar" onclick="copiarLink()">Copiar</button>
    </div>
</div>

<script>
    window.onload = function() {
        let rev = document.getElementById('revendedor').value.trim();
        let palavraSalva = localStorage.getItem('palavra_robo_' + rev);
        if (palavraSalva) {
            document.getElementById('palavra').value = palavraSalva;
            gerarLink();
        }
    };

    function salvarPalavra() {
        let rev = document.getElementById('revendedor').value.trim();
        let palavra = document.getElementById('palavra').value.trim().toLowerCase();
        if(!palavra) { alert("Por favor, digite uma palavra-chave primeiro!"); return; }
        localStorage.setItem('palavra_robo_' + rev, palavra);
        gerarLink();
        var btnSalvar = document.getElementById("btn_salvar");
        btnSalvar.innerHTML = "✅ Salvo com Sucesso!";
        btnSalvar.style.background = "#059669";
        setTimeout(function() {
            btnSalvar.innerHTML = "💾 Salvar e Gerar Link";
            btnSalvar.style.background = "#10b981";
        }, 2500);
    }

    function gerarLink() {
        const base_url = window.location.origin + window.location.pathname.replace(/[^/]*$/, '') + 'webhook_cs.php';
        let rev = document.getElementById('revendedor').value.trim();
        let palavra = document.getElementById('palavra').value.trim().toLowerCase();
        if(!palavra) { palavra = 'teste cs'; }
        const linkFinal = base_url + '?rev=' + encodeURIComponent(rev) + '&palavra=' + encodeURIComponent(palavra);
        document.getElementById('link_gerado').value = linkFinal;
    }

    function copiarLink() {
        var copyText = document.getElementById("link_gerado");
        if(!copyText.value) { alert("Clique em 'Salvar e Gerar Link' antes de copiar!"); return; }
        var btn = document.getElementById("btn_copiar");
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        try {
            document.execCommand("copy");
            var textoOriginal = btn.innerHTML;
            btn.innerHTML = "✓ Copiado!";
            btn.classList.add("copiado");
            setTimeout(function() { btn.innerHTML = textoOriginal; btn.classList.remove("copiado"); }, 2000);
        } catch (err) { alert("Erro ao copiar link."); }
    }
</script>
</body>
</html>
