<?php
session_start();
// Apenas Admin Logado
if (!isset($_SESSION['logado']) || $_SESSION['nivel'] !== 'admin') { 
    header("Location: index.php"); exit; 
}
require_once 'conexao.php'; // Traz $connUser e $connGeral

$msg = ""; 
$msg_tipo = "";

// --- 1. BUSCA CONFIGURAÇÕES DO SITE (NOME E COR) ---
$nomePainel = "IPTV PANEL"; 
$corPrimaria = "#7367f0"; 
try {
    $conf = $connGeral->query("SELECT NomePainel, TemaPainel FROM site_config LIMIT 1")->fetch(PDO::FETCH_ASSOC);
    if ($conf) {
        if (!empty($conf['NomePainel'])) $nomePainel = $conf['NomePainel'];
        if (!empty($conf['TemaPainel'])) $corPrimaria = $conf['TemaPainel'];
    }
} catch (Exception $e) { }

// --- 2. PROCESSAMENTO (POST) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $acao = $_POST['acao'];
        $id_adm = $_POST['id_adm'] ?? 0;

        if ($acao === 'criar') {
            $user = trim($_POST['usuario']);
            $check = $connUser->prepare("SELECT id FROM admin WHERE usuario = ?");
            $check->execute([$user]);
            if ($check->rowCount() > 0) {
                $msg = "Este usuário já existe!"; $msg_tipo = "warning";
            } else {
                $sql = "INSERT INTO admin (CadUser, nome, sobrenome, usuario, senha, email, celular, data_cadastro, bloqueado, inativo) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), 'nao', 'nao')";
                $connUser->prepare($sql)->execute([$_SESSION['usuario'], $_POST['nome'], $_POST['sobrenome'], $user, $_POST['senha'], $_POST['email'], $_POST['celular']]);
                $msg = "Administrador cadastrado!"; $msg_tipo = "success";
            }
        }

        if ($acao === 'editar') {
            $sql = "UPDATE admin SET nome=?, sobrenome=?, usuario=?, senha=?, email=?, celular=? WHERE id=?";
            $connUser->prepare($sql)->execute([$_POST['nome'], $_POST['sobrenome'], $_POST['usuario'], $_POST['senha'], $_POST['email'], $_POST['celular'], $id_adm]);
            $msg = "Dados atualizados!"; $msg_tipo = "primary";
        }

        if ($acao === 'bloquear') {
            $status_atual = $_POST['status_atual'];
            $novo_status = ($status_atual == 'sim') ? 'nao' : 'sim';
            $connUser->prepare("UPDATE admin SET bloqueado = ? WHERE id = ?")->execute([$novo_status, $id_adm]);
            $msg = ($novo_status == 'sim') ? "Usuário Bloqueado!" : "Usuário Desbloqueado!";
            $msg_tipo = "info";
        }

        if ($acao === 'excluir') {
            if ($_SESSION['usuario'] == $_POST['usuario_alvo']) {
                $msg = "Você não pode excluir a si mesmo!"; $msg_tipo = "warning";
            } else {
                $connUser->prepare("DELETE FROM admin WHERE id = ?")->execute([$id_adm]);
                $msg = "Administrador removido!"; $msg_tipo = "danger";
            }
        }
    } catch (Exception $e) { $msg = "Erro: " . $e->getMessage(); $msg_tipo = "danger"; }
}

// --- 3. LISTAGEM ---
$admins = $connUser->query("SELECT * FROM admin ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestão de Admins | <?= htmlspecialchars($nomePainel) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { 
            --primary: <?= $corPrimaria ?>; 
            --bg-body: #151521; 
            --bg-card: #1e1e2d; 
        }
        body { background: var(--bg-body); color: #fff; font-family: 'Segoe UI', sans-serif; overflow-x: hidden; }
        .sidebar { width: 260px; height: 100vh; position: fixed; background: var(--bg-card); padding: 20px; border-right: 1px solid #333; transition: 0.3s; z-index: 1050; overflow-y: auto; }
        .main-content { margin-left: 260px; padding: 30px; transition: 0.3s; }
        .nav-link { color: #a6a6b7; padding: 10px 12px; border-radius: 8px; margin-bottom: 2px; display: flex; align-items: center; gap: 10px; transition: 0.2s; text-decoration: none; font-size: 0.9rem; }
        .nav-link:hover, .nav-link.active { background: var(--primary); color: #fff; }
        .nav-group-title { font-size: 0.75rem; text-transform: uppercase; color: #5e5873; font-weight: 700; margin: 20px 0 10px 12px; }
        .card-custom { background: var(--bg-card); border: 1px solid rgba(255,255,255,0.05); border-radius: 12px; }
        .form-control { background: #2b2b40 !important; border: 1px solid #444 !important; color: #fff !important; }
        .avatar-circle { width: 40px; height: 40px; background: var(--primary); color: #fff; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: bold; }
        @media (max-width: 992px) { .sidebar { transform: translateX(-100%); } .sidebar.show { transform: translateX(0); } .main-content { margin-left: 0; padding: 15px; } .mobile-toggle { display: block !important; } }
        .mobile-toggle { display: none; background: none; border: none; color: #fff; font-size: 1.5rem; margin-bottom: 20px; }
        .overlay { display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 1040; }
        .overlay.show { display: block; }
    </style>
</head>
<body>

<div class="overlay" id="overlay" onclick="toggleMenu()"></div>

<nav class="sidebar" id="sidebar">
    <h4 class="mb-4 fw-bold text-white text-center"><i class="fas fa-tv text-primary"></i> <?= htmlspecialchars($nomePainel) ?></h4>
    <div class="nav flex-column">
        <a href="index.php" class="nav-link"><i class="fas fa-home"></i> Dashboard</a>
        
        <div class="nav-group-title">Administração</div>
        <a href="gerenciar_perfis.php" class="nav-link"><i class="fas fa-layer-group"></i> Gerenciar Perfis</a>
        <a href="gerenciar_dns.php" class="nav-link"><i class="fas fa-network-wired"></i> Servidores DNS</a>
        <a href="gerenciar_admins.php" class="nav-link active"><i class="fas fa-user-shield"></i> Gestão de Admins</a>
        <a href="gerenciar_email.php" class="nav-link"><i class="fas fa-envelope"></i> Config. E-mail</a>
        <a href="personalizar_painel.php" class="nav-link"><i class="fas fa-paint-brush"></i> Personalizar</a>
        <a href="gerenciar_backups.php" class="nav-link"><i class="fas fa-database"></i> Backups</a>
        <a href="config_geral.php" class="nav-link"><i class="fas fa-cogs"></i> Config. Geral</a>

        <div class="nav-group-title">Operacional</div>
        <a href="revendedores.php" class="nav-link"><i class="fas fa-store"></i> Revendedores</a>
        <a href="clientes.php" class="nav-link"><i class="fas fa-users"></i> Clientes</a>
        <a href="testes.php" class="nav-link"><i class="fas fa-stopwatch"></i> Testes</a>
        <a href="status_online.php" class="nav-link"><i class="fas fa-wifi"></i> Monitor Online</a>
        
        <hr class="border-secondary mt-4"><a href="sair.php" class="nav-link text-danger"><i class="fas fa-sign-out-alt"></i> Sair</a>
    </div>
</nav>

<main class="main-content">
    <button class="mobile-toggle" onclick="toggleMenu()"><i class="fas fa-bars"></i></button>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold">Equipe Administrativa</h3>
        <button class="btn btn-primary fw-bold" data-bs-toggle="modal" data-bs-target="#modalCriar"><i class="fas fa-plus me-2"></i> Novo Admin</button>
    </div>

    <?php if($msg): ?><div class="alert alert-<?= $msg_tipo ?> alert-dismissible fade show"><?= $msg ?><button class="btn-close" data-bs-dismiss="alert"></button></div><?php endif; ?>

    <div class="card card-custom">
        <div class="table-responsive">
            <table class="table table-dark table-hover mb-0 align-middle">
                <thead>
                    <tr class="text-white-50">
                        <th class="ps-4">Nome</th>
                        <th>Usuário / Senha</th>
                        <th>Contato</th>
                        <th>Status</th>
                        <th class="text-end pe-4">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($admins as $a): 
                        $iniciais = strtoupper(substr($a['nome'], 0, 1) . substr($a['sobrenome']??'', 0, 1));
                        $is_blocked = ($a['bloqueado'] == 'sim');
                    ?>
                    <tr>
                        <td class="ps-4">
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle me-3"><?= $iniciais ?></div>
                                <div><div class="fw-bold text-white"><?= htmlspecialchars($a['nome']) ?> <?= htmlspecialchars($a['sobrenome']??'') ?></div><div class="small text-muted">ID: <?= $a['id'] ?></div></div>
                            </div>
                        </td>
                        <td><div class="text-white"><?= htmlspecialchars($a['usuario']) ?></div><div class="text-white-50 small"><?= htmlspecialchars($a['senha']) ?></div></td>
                        <td><div class="small"><i class="fas fa-envelope me-2 text-secondary"></i><?= htmlspecialchars($a['email']) ?></div><div class="small"><i class="fas fa-phone me-2 text-secondary"></i><?= htmlspecialchars($a['celular']) ?></div></td>
                        <td><?= $is_blocked ? '<span class="badge bg-danger">Bloqueado</span>' : '<span class="badge bg-success">Ativo</span>' ?></td>
                        <td class="text-end pe-4">
                            <form method="POST" class="d-inline">
                                <input type="hidden" name="acao" value="bloquear"><input type="hidden" name="id_adm" value="<?= $a['id'] ?>"><input type="hidden" name="status_atual" value="<?= $a['bloqueado'] ?>">
                                <button class="btn btn-sm btn-outline-light rounded-circle me-1" title="<?= $is_blocked?'Desbloquear':'Bloquear' ?>"><i class="fas <?= $is_blocked?'fa-lock':'fa-lock-open' ?>"></i></button>
                            </form>
                            <button class="btn btn-sm btn-info rounded-circle me-1" onclick='abrirEditar(<?= json_encode($a) ?>)'><i class="fas fa-pen text-white"></i></button>
                            <form method="POST" class="d-inline">
                                <input type="hidden" name="acao" value="excluir"><input type="hidden" name="id_adm" value="<?= $a['id'] ?>"><input type="hidden" name="usuario_alvo" value="<?= $a['usuario'] ?>">
                                <button class="btn btn-sm btn-danger rounded-circle" onclick="return confirm('Excluir este administrador?')"><i class="fas fa-trash"></i></button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<div class="modal fade" id="modalCriar" tabindex="-1"><div class="modal-dialog modal-dialog-centered"><div class="modal-content bg-dark border-secondary"><div class="modal-header border-secondary"><h5 class="modal-title text-white">Novo Administrador</h5><button class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div><form method="POST"><input type="hidden" name="acao" value="criar"><div class="modal-body p-4"><div class="row g-3"><div class="col-6"><label class="form-label text-white-50">Nome</label><input type="text" name="nome" class="form-control" required></div><div class="col-6"><label class="form-label text-white-50">Sobrenome</label><input type="text" name="sobrenome" class="form-control"></div><div class="col-6"><label class="form-label text-white-50">Usuário</label><input type="text" name="usuario" class="form-control" required></div><div class="col-6"><label class="form-label text-white-50">Senha</label><input type="text" name="senha" class="form-control" required></div><div class="col-12"><label class="form-label text-white-50">E-mail</label><input type="email" name="email" class="form-control"></div><div class="col-12"><label class="form-label text-white-50">Celular</label><input type="text" name="celular" class="form-control"></div></div></div><div class="modal-footer border-secondary"><button type="submit" class="btn btn-primary fw-bold w-100">Cadastrar</button></div></form></div></div></div>

<div class="modal fade" id="modalEditar" tabindex="-1"><div class="modal-dialog modal-dialog-centered"><div class="modal-content bg-dark border-secondary"><div class="modal-header border-secondary"><h5 class="modal-title text-white">Editar Administrador</h5><button class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div><form method="POST"><input type="hidden" name="acao" value="editar"><input type="hidden" name="id_adm" id="edit_id"><div class="modal-body p-4"><div class="row g-3"><div class="col-6"><label class="form-label text-white-50">Nome</label><input type="text" name="nome" id="edit_nome" class="form-control" required></div><div class="col-6"><label class="form-label text-white-50">Sobrenome</label><input type="text" name="sobrenome" id="edit_sobrenome" class="form-control"></div><div class="col-6"><label class="form-label text-white-50">Usuário</label><input type="text" name="usuario" id="edit_user" class="form-control" required></div><div class="col-6"><label class="form-label text-white-50">Senha</label><input type="text" name="senha" id="edit_pass" class="form-control" required></div><div class="col-12"><label class="form-label text-white-50">E-mail</label><input type="email" name="email" id="edit_email" class="form-control"></div><div class="col-12"><label class="form-label text-white-50">Celular</label><input type="text" name="celular" id="edit_cel" class="form-control"></div></div></div><div class="modal-footer border-secondary"><button type="submit" class="btn btn-primary fw-bold w-100">Salvar Alterações</button></div></form></div></div></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function toggleMenu() { document.getElementById('sidebar').classList.toggle('show'); document.getElementById('overlay').classList.toggle('show'); }
    function abrirEditar(a) { document.getElementById('edit_id').value = a.id; document.getElementById('edit_nome').value = a.nome; document.getElementById('edit_sobrenome').value = a.sobrenome; document.getElementById('edit_user').value = a.usuario; document.getElementById('edit_pass').value = a.senha; document.getElementById('edit_email').value = a.email; document.getElementById('edit_cel').value = a.celular; new bootstrap.Modal(document.getElementById('modalEditar')).show(); }
</script>
</body>
</html>
