<?php
session_start();
if (!isset($_SESSION['logado']) || $_SESSION['nivel'] !== 'admin') { 
    header("Location: index.php"); 
    exit; 
}
require_once 'conexao.php';

$msg = "";
$msg_tipo = "";

// --- PROCESSAMENTO ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $acao = $_POST['acao'];
        $id   = $_POST['id'] ?? 0;
        $nome = $_POST['nome'] ?? '';
        $perfil = $_POST['perfil'] ?? 0;
        $url    = $_POST['url'] ?? '';
        $porta  = $_POST['porta'] ?? '';
        $user   = $_SESSION['usuario'];

        if ($acao === 'criar') {
            $sql = "INSERT INTO mascaraurl (CadUser, perfil, nome, url, porta, bloqueado) VALUES (?, ?, ?, ?, ?, 'nao')";
            $connGeral->prepare($sql)->execute([$user, $perfil, $nome, $url, $porta]);
            $msg = "Máscara <b>$nome</b> criada!"; $msg_tipo = "success";
        }
        if ($acao === 'editar') {
            $sql = "UPDATE mascaraurl SET perfil=?, nome=?, url=?, porta=? WHERE id=?";
            $connGeral->prepare($sql)->execute([$perfil, $nome, $url, $porta, $id]);
            $msg = "Atualizado!"; $msg_tipo = "primary";
        }
        if ($acao === 'toggle_block') {
            $curr = $connGeral->query("SELECT bloqueado FROM mascaraurl WHERE id=$id")->fetchColumn();
            $novo = ($curr == 'sim') ? 'nao' : 'sim';
            $connGeral->prepare("UPDATE mascaraurl SET bloqueado=? WHERE id=?")->execute([$novo, $id]);
            $msg = "Status alterado!"; $msg_tipo = "warning";
        }
        if ($acao === 'excluir') {
            $connGeral->prepare("DELETE FROM mascaraurl WHERE id=?")->execute([$id]);
            $msg = "Removido!"; $msg_tipo = "danger";
        }
    } catch (PDOException $e) { $msg = "Erro: " . $e->getMessage(); $msg_tipo = "danger"; }
}

// --- BUSCAS ---
$sql_lista = "SELECT m.*, p.nome as nome_perfil 
              FROM mascaraurl m 
              LEFT JOIN perfil p ON m.perfil = p.id 
              ORDER BY m.id DESC";
$mascaras = $connGeral->query($sql_lista)->fetchAll(PDO::FETCH_ASSOC);

$perfis = $connGeral->query("SELECT id, nome FROM perfil WHERE bloqueado='nao'")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Máscaras | Painel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --bg-body: #151521; --bg-card: #1e1e2d; --primary: #7367f0; }
        body { background: var(--bg-body); color: #fff; font-family: 'Segoe UI', sans-serif; }
        .sidebar { width: 260px; height: 100vh; position: fixed; background: #1e1e2d; padding: 20px; border-right: 1px solid #333; z-index: 1000; transition: 0.3s; }
        .main-content { margin-left: 260px; padding: 30px; transition: 0.3s; }
        .form-label { color: #ffffff !important; font-weight: 700; display: block; }
        .card-custom { background: var(--bg-card); border: 1px solid rgba(255,255,255,0.05); border-radius: 12px; }
        .form-control, .form-select { background: #2b2b40 !important; border: 1px solid #444 !important; color: #fff !important; }
        
        /* CORREÇÃO DA TABELA ESCURA */
        .table-dark { background-color: var(--bg-card) !important; color: #fff !important; }
        .table-dark th, .table-dark td { border-color: #333 !important; vertical-align: middle; }
        .table-dark tbody tr:hover { background-color: rgba(255,255,255,0.05); }

        @media (max-width: 768px) { .sidebar { transform: translateX(-100%); } .sidebar.show { transform: translateX(0); } .main-content { margin-left: 0; padding: 15px; } .mobile-toggle { display: block !important; } }
        .mobile-toggle { display: none; font-size: 1.5rem; color: #fff; background: none; border: none; margin-bottom: 20px; }
        .overlay { display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 999; } .overlay.show { display: block; }
        .nav-link { color: #a6a6b7; text-decoration: none; display: flex; align-items: center; gap: 10px; padding: 10px; border-radius: 8px; } .nav-link.active { background: var(--primary); color: #fff; }
    </style>
</head>
<body>
<div class="overlay" id="overlay" onclick="toggleMenu()"></div>

<nav class="sidebar" id="sidebar">
    <h4 class="mb-4 fw-bold text-white"><i class="fas fa-tv text-primary"></i> Painel v3.0</h4>
    <div class="nav flex-column gap-2">
        <a href="index.php" class="nav-link text-white"><i class="fas fa-home"></i> Dashboard</a>
        <?php if ($_SESSION['nivel'] === 'admin'): ?>
            <div class="mt-2 mb-1 px-3 text-uppercase fw-bold text-light" style="font-size: 0.75rem; opacity: 0.7;">Administração</div>
            <a href="config_geral.php" class="nav-link text-white"><i class="fas fa-cogs text-info"></i> Config. Servidor</a>
            <a href="gerenciar_dns.php" class="nav-link text-white"><i class="fas fa-network-wired text-success"></i> Servidores DNS</a>
            <a href="gerenciar_perfis.php" class="nav-link text-white"><i class="fas fa-layer-group text-primary"></i> Perfis de Conexão</a>
            <a href="gerenciar_mascara.php" class="nav-link active text-white"><i class="fas fa-mask text-warning"></i> Máscaras URL</a>
            <a href="permissoes_server.php" class="nav-link text-white"><i class="fas fa-server text-white"></i> Permissões CSP</a>
            <a href="revendedores.php" class="nav-link text-white"><i class="fas fa-store"></i> Revendedores</a>
            <a href="configuracoes.php" class="nav-link text-white"><i class="fas fa-wallet"></i> Pagamentos (Global)</a>
            <div class="mb-2 border-bottom border-secondary opacity-50"></div>
        <?php else: ?>
            <a href="configuracoes.php" class="nav-link text-white"><i class="fas fa-wallet"></i> Meus Pagamentos</a>
        <?php endif; ?>
        <a href="clientes.php" class="nav-link text-white"><i class="fas fa-users"></i> Clientes</a>
        <a href="sair.php" class="nav-link text-danger mt-4"><i class="fas fa-sign-out-alt"></i> Sair</a>
    </div>
</nav>

<main class="main-content">
    <button class="mobile-toggle" onclick="toggleMenu()"><i class="fas fa-bars"></i></button>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold text-white">Gerenciar Máscaras URL</h3>
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalCriar"><i class="fas fa-plus me-2"></i> Nova Máscara</button>
    </div>
    <?php if($msg): ?><div class="alert alert-<?= $msg_tipo ?> alert-dismissible fade show"><?= $msg ?><button class="btn-close" data-bs-dismiss="alert"></button></div><?php endif; ?>

    <div class="card card-custom">
        <div class="table-responsive">
            <table class="table table-dark table-hover mb-0 align-middle">
                <thead>
                    <tr class="text-white small text-uppercase">
                        <th class="ps-4">Nome da Máscara</th>
                        <th>Perfil Vinculado</th>
                        <th>URL Mascarada</th>
                        <th>Porta</th>
                        <th>Status</th>
                        <th class="text-end pe-4">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($mascaras as $m): $is_block = ($m['bloqueado'] == 'sim'); ?>
                    <tr>
                        <td class="ps-4 fw-bold text-white"><?= $m['nome'] ?></td>
                        <td><span class="badge bg-info text-dark"><?= $m['nome_perfil'] ?? 'Sem Perfil' ?></span></td>
                        <td class="text-white fw-bold"><?= $m['url'] ?></td>
                        <td class="text-warning fw-bold"><?= $m['porta'] ?></td>
                        <td><?= $is_block ? '<span class="badge bg-danger">Bloqueado</span>' : '<span class="badge bg-success">Ativo</span>' ?></td>
                        <td class="text-end pe-4">
                            <form method="POST" class="d-inline">
                                <input type="hidden" name="acao" value="toggle_block"><input type="hidden" name="id" value="<?= $m['id'] ?>">
                                <button class="btn btn-sm <?= $is_block ? 'btn-secondary' : 'btn-warning' ?> rounded-circle me-1"><i class="fas <?= $is_block ? 'fa-lock-open' : 'fa-lock' ?>"></i></button>
                            </form>
                            <button class="btn btn-sm btn-info rounded-circle me-1" onclick='abrirEditar(<?= json_encode($m) ?>)'><i class="fas fa-pen text-white"></i></button>
                            <form method="POST" class="d-inline">
                                <input type="hidden" name="acao" value="excluir"><input type="hidden" name="id" value="<?= $m['id'] ?>">
                                <button class="btn btn-sm btn-danger rounded-circle" onclick="return confirm('Excluir?')"><i class="fas fa-trash"></i></button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<div class="modal fade" id="modalCriar" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered"><div class="modal-content bg-dark border-secondary"><form method="POST" id="formMascara"><input type="hidden" name="acao" value="criar" id="inputAcao"><input type="hidden" name="id" id="inputId"><div class="modal-header border-secondary text-white"><h5 class="modal-title" id="modalTitulo">Nova Máscara</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div><div class="modal-body"><div class="mb-3"><label class="form-label">Nome da Máscara</label><input type="text" name="nome" id="nome" class="form-control" required></div><div class="mb-3"><label class="form-label">Vincular ao Perfil</label><select name="perfil" id="perfil" class="form-select" required><option value="">Selecione...</option><?php foreach($perfis as $p): ?><option value="<?= $p['id'] ?>"><?= $p['nome'] ?></option><?php endforeach; ?></select></div><div class="row"><div class="col-8 mb-3"><label class="form-label">URL (DNS Mascarado)</label><input type="text" name="url" id="url" class="form-control" required></div><div class="col-4 mb-3"><label class="form-label">Porta</label><input type="number" name="porta" id="porta" class="form-control" required></div></div></div><div class="modal-footer border-secondary"><button type="submit" class="btn btn-primary w-100 fw-bold">Salvar</button></div></form></div></div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function toggleMenu() { document.getElementById('sidebar').classList.toggle('show'); document.getElementById('overlay').classList.toggle('show'); }
    function abrirEditar(m) {
        document.getElementById('inputAcao').value = 'editar'; document.getElementById('inputId').value = m.id; document.getElementById('modalTitulo').innerText = 'Editar Máscara';
        document.getElementById('nome').value = m.nome; document.getElementById('perfil').value = m.perfil; document.getElementById('url').value = m.url; document.getElementById('porta').value = m.porta;
        new bootstrap.Modal(document.getElementById('modalCriar')).show();
    }
    document.getElementById('modalCriar').addEventListener('hidden.bs.modal', function () { document.getElementById('formMascara').reset(); document.getElementById('inputAcao').value = 'criar'; document.getElementById('modalTitulo').innerText = 'Nova Máscara'; });
</script>
</body>
</html>
