<?php
// ARQUIVO: instalador_completo.php
// FUNÇÃO: Repara todo o banco de dados, adicionando colunas e tabelas que faltam após importar backup antigo.

require_once 'conexao.php';
@set_time_limit(0);

// --- FUNÇÕES DE AJUDA ---
function checkCol($conn, $tab, $col, $def) {
    try {
        // Tenta selecionar a coluna. Se falhar, ela não existe.
        $conn->query("SELECT $col FROM $tab LIMIT 1");
    } catch (Exception $e) {
        try {
            $conn->exec("ALTER TABLE $tab ADD COLUMN $col $def");
            echo "<div class='ok'>+ Coluna <b>$col</b> criada na tabela <b>$tab</b>.</div>";
        } catch (Exception $e2) { echo "<div class='erro'>Erro ao criar coluna $col: ".$e2->getMessage()."</div>"; }
    }
}

function checkTable($conn, $nome, $sql) {
    try {
        $conn->exec($sql);
        echo "<div class='ok'>✔ Tabela <b>$nome</b> verificada.</div>";
    } catch (Exception $e) {
        echo "<div class='erro'>Erro na tabela $nome: " . $e->getMessage() . "</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Reparador Geral V3.0</title>
    <style>
        body { background: #151521; color: #fff; font-family: monospace; padding: 20px; }
        .box { background: #1e1e2d; padding: 20px; border-radius: 10px; border: 1px solid #333; margin-bottom: 20px; }
        h2 { border-bottom: 1px solid #444; padding-bottom: 10px; color: #7367f0; }
        .ok { color: #28c76f; margin: 5px 0; border-left: 3px solid #28c76f; padding-left: 10px; }
        .erro { color: #ea5455; margin: 5px 0; border-left: 3px solid #ea5455; padding-left: 10px; }
    </style>
</head>
<body>

<div class="box">
    <h2>1. BANCO DE DADOS USER (Clientes e Revendas)</h2>
    <p>Corrigindo erros de "Column not found" e tabelas de pagamento...</p>
    <?php
    // --- 1.1 CORREÇÃO DA TABELA USUARIO (Onde deu erro no seu print) ---
    // Colunas vitais para o painel V3
    checkCol($connUser, 'usuario', 'id_perfil', "INT(11) DEFAULT 1"); // Erro do print 1000699289
    checkCol($connUser, 'usuario', 'dono', "VARCHAR(100) DEFAULT NULL"); // Erro do print 1000699290
    checkCol($connUser, 'usuario', 'limite', "INT(11) DEFAULT 0"); // Erro do print 1000699291
    checkCol($connUser, 'usuario', 'mac', "VARCHAR(100) DEFAULT NULL");
    checkCol($connUser, 'usuario', 'bloqueado', "VARCHAR(10) DEFAULT 'nao'");
    checkCol($connUser, 'usuario', 'ValorCobrado', "VARCHAR(50) DEFAULT NULL");
    checkCol($connUser, 'usuario', 'vencimento_email_enviado', "INT(1) DEFAULT 0");
    checkCol($connUser, 'usuario', 'notas', "TEXT DEFAULT NULL");
    checkCol($connUser, 'usuario', 'email', "VARCHAR(255) DEFAULT NULL");
    
    // --- 1.2 TABELA DE PAGAMENTOS (Erro do print 1000699292) ---
    $sql_pag = "CREATE TABLE IF NOT EXISTS configuracoes_pagamento (
        id INT AUTO_INCREMENT PRIMARY KEY,
        access_token VARCHAR(255),
        public_key VARCHAR(255),
        client_id VARCHAR(255),
        client_secret VARCHAR(255),
        valor_padrao DECIMAL(10,2) DEFAULT 30.00,
        tipo VARCHAR(50) DEFAULT 'mercadopago'
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    checkTable($connUser, 'configuracoes_pagamento', $sql_pag);

    // --- 1.3 TABELA REV_PERFIL (Custo) ---
    $sql_rev = "CREATE TABLE IF NOT EXISTS rev_perfil (
        id INT AUTO_INCREMENT PRIMARY KEY,
        id_rev INT,
        id_perfil INT,
        valor_custo DECIMAL(10,2) DEFAULT 0.00
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    checkTable($connUser, 'rev_perfil', $sql_rev);
    
    // --- 1.4 TABELA TESTE ---
    checkCol($connUser, 'teste', 'email', "VARCHAR(255) DEFAULT NULL");
    checkCol($connUser, 'teste', 'celular', "VARCHAR(50) DEFAULT NULL");
    ?>
</div>

<div class="box">
    <h2>2. BANCO DE DADOS GERAL (Configurações)</h2>
    <p>Garantindo tabelas de Servidor, DNS e Backup...</p>
    <?php
    // --- 2.1 TABELA SERVIDOR (Erro de conexão recusada) ---
    // Se essa tabela sumiu, o painel tenta conectar em localhost e falha
    $sql_serv = "CREATE TABLE IF NOT EXISTS servidor (
        id INT AUTO_INCREMENT PRIMARY KEY,
        nome VARCHAR(100),
        url VARCHAR(255),
        porta VARCHAR(10),
        usuario VARCHAR(100),
        senha VARCHAR(100),
        tipo VARCHAR(50) DEFAULT 'csp',
        ip VARCHAR(50)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    checkTable($connGeral, 'servidor', $sql_serv);
    checkCol($connGeral, 'servidor', 'tipo', "VARCHAR(50) DEFAULT 'csp'");

    // --- 2.2 TABELA PERFIL ---
    $sql_perf = "CREATE TABLE IF NOT EXISTS perfil (
        id INT AUTO_INCREMENT PRIMARY KEY,
        nome VARCHAR(100),
        url VARCHAR(255),
        porta VARCHAR(10),
        tipo VARCHAR(50)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    checkTable($connGeral, 'perfil', $sql_perf);

    // --- 2.3 TABELA BACKUPS ---
    $sql_bkp = "CREATE TABLE IF NOT EXISTS arquivo_backup (
        id INT AUTO_INCREMENT PRIMARY KEY,
        tipo VARCHAR(50) DEFAULT 'Manual',
        local VARCHAR(255) NOT NULL,
        data DATETIME DEFAULT CURRENT_TIMESTAMP,
        size VARCHAR(50) DEFAULT '0 KB',
        link_externo VARCHAR(255) DEFAULT NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    checkTable($connGeral, 'arquivo_backup', $sql_bkp);
    checkCol($connGeral, 'arquivo_backup', 'link_externo', "VARCHAR(255) DEFAULT NULL"); // Garante Pixeldrain

    // --- 2.4 TABELA AUTOMACAO BACKUP ---
    $sql_auto = "CREATE TABLE IF NOT EXISTS backup_automatizado (
        id INT NOT NULL PRIMARY KEY,
        status VARCHAR(20) DEFAULT 'inativo',
        tempo VARCHAR(20) DEFAULT 'diario',
        horario VARCHAR(10) DEFAULT '03:00'
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    checkTable($connGeral, 'backup_automatizado', $sql_auto);
    $connGeral->exec("INSERT IGNORE INTO backup_automatizado (id) VALUES (1)");

    // --- 2.5 TABELA SMTP e DNS ---
    $sql_smtp = "CREATE TABLE IF NOT EXISTS smtp_config (id INT AUTO_INCREMENT PRIMARY KEY, host VARCHAR(255), email VARCHAR(255), senha VARCHAR(255), porta VARCHAR(10), seguranca VARCHAR(20)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    checkTable($connGeral, 'smtp_config', $sql_smtp);
    
    $sql_dns = "CREATE TABLE IF NOT EXISTS mascaraurl (id INT AUTO_INCREMENT PRIMARY KEY, nome VARCHAR(100), url VARCHAR(255), porta VARCHAR(10)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    checkTable($connGeral, 'mascaraurl', $sql_dns);
    ?>
</div>

<div class="box">
    <h2>3. BANCO DE DADOS ACESSOS (Logs)</h2>
    <?php
    $sql_logs = "CREATE TABLE IF NOT EXISTS logs (id INT AUTO_INCREMENT PRIMARY KEY, mensagem TEXT, data DATETIME DEFAULT CURRENT_TIMESTAMP, ip VARCHAR(50), usuario VARCHAR(100)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    checkTable($connAcessos, 'logs', $sql_logs);
    
    $sql_acesso = "CREATE TABLE IF NOT EXISTS acessos (id INT AUTO_INCREMENT PRIMARY KEY, usuario VARCHAR(100), ip VARCHAR(50), data DATETIME DEFAULT CURRENT_TIMESTAMP, status VARCHAR(50)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    checkTable($connAcessos, 'acessos', $sql_acesso);
    ?>
</div>

<div class="box">
    <h2>4. CORREÇÃO DE DATAS (1969)</h2>
    <p>Tentando corrigir datas zeradas vindas do backup...</p>
    <?php
    // Script rápido para tirar do 1969 e colocar para HOJE (para você editar depois)
    $stmt = $connUser->query("SELECT id, data_premio FROM usuario");
    $count = 0;
    while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $d = $row['data_premio'];
        // Se for vazio, zero ou timestamp inválido
        if(empty($d) || $d == '0' || $d == '0000-00-00' || (is_numeric($d) && $d < 0)) {
            $hoje = date('Y-m-d');
            $connUser->query("UPDATE usuario SET data_premio = '$hoje' WHERE id = {$row['id']}");
            $count++;
        }
        // Se for timestamp numérico válido
        elseif(is_numeric($d) && $d > 100000) {
            $nova = date('Y-m-d', $d);
            $connUser->query("UPDATE usuario SET data_premio = '$nova' WHERE id = {$row['id']}");
            $count++;
        }
    }
    echo "<div class='ok'><b>$count</b> datas corrigidas para o formato atual.</div>";
    ?>
</div>

<div style="text-align:center; margin-top:30px;">
    <h1 style="color:#28c76f">✅ CONCLUÍDO!</h1>
    <p>Todas as tabelas e colunas necessárias para o painel V3 estão instaladas.</p>
    <a href="index.php" style="background:#7367f0; color:white; padding:15px 30px; text-decoration:none; border-radius:8px; font-weight:bold;">VOLTAR AO PAINEL</a>
</div>

</body>
</html>
