<?php
// ============================================================
// SCRIPT DE MIGRAÇÃO UNIVERSAL - DATAS E ESTRUTURA
// ============================================================
require_once 'conexao.php';
@set_time_limit(0);

echo "<body style='background:#151521; color:#fff; font-family:sans-serif; padding:20px;'>";
echo "<h2>🚀 Sincronização Final de Backup</h2><hr>";

// 1. CORREÇÃO DE ESTRUTURA (TABELA POR TABELA PARA EVITAR ERROS)
echo "<h3>📦 Corrigindo Estrutura...</h3>";
$tabelas = ['usuario', 'rev', 'teste'];

foreach ($tabelas as $tab) {
    try {
        // Tenta adicionar id_perfil se não existir
        $connUser->exec("ALTER TABLE `$tab` ADD COLUMN IF NOT EXISTS id_perfil INT(11) DEFAULT 1");
        $connUser->exec("ALTER TABLE `$tab` ADD COLUMN IF NOT EXISTS dono VARCHAR(100) DEFAULT 'admin'");
        $connUser->exec("ALTER TABLE `$tab` ADD COLUMN IF NOT EXISTS limite INT(11) DEFAULT 100");
        echo "✔ Estrutura da tabela <b>$tab</b> verificada.<br>";
    } catch (Exception $e) {
        echo "ℹ Tabela $tab ignorada ou já corrigida.<br>";
    }
}

// 2. CONVERSÃO INTELIGENTE DE DATAS
echo "<h3>📅 Resgatando Datas Reais...</h3>";
try {
    // Buscamos todos os usuários para analisar o formato da data_premio
    $stmt = $connUser->query("SELECT id, data_premio, vencimento, expire_date, exp_date FROM usuario");
    $convertidos = 0;

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $data_original = null;
        
        // Testa qual coluna tem a informação real (data_premio, vencimento, etc)
        $candidatos = [$row['data_premio'], $row['vencimento'], $row['expire_date'], $row['exp_date']];
        
        foreach ($candidatos as $valor) {
            if (empty($valor) || $valor == '0' || $valor == 'S') continue;

            // CASO A: Já é data YYYY-MM-DD (Apenas validamos)
            if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $valor)) {
                $data_original = $valor;
                break;
            }
            // CASO B: É número Unix (Ex: 1742000000)
            if (is_numeric($valor) && $valor > 100000000) {
                $data_original = date('Y-m-d', $valor);
                break;
            }
            // CASO C: É data brasileira (Ex: 30/09/2023)
            if (strpos($valor, '/') !== false) {
                $p = explode('/', $valor);
                if(count($p) == 3) {
                    $data_original = $p[2] . '-' . $p[1] . '-' . $p[0];
                    break;
                }
            }
        }

        if ($data_original) {
            $upd = $connUser->prepare("UPDATE usuario SET data_premio = ?, id_perfil = 1, dono = 'admin' WHERE id = ?");
            $upd->execute([$data_original, $row['id']]);
            $convertidos++;
        }
    }
    echo "<div style='color:#28c76f'>✔ $convertidos usuários sincronizados com datas reais!</div>";
} catch (Exception $e) {
    echo "Erro na conversão: " . $e->getMessage();
}

// 3. LIMPEZA DE SEGURANÇA (ADMINS E REVENDEDORES)
$connUser->exec("UPDATE rev SET dono = 'admin', id_perfil = 1 WHERE dono IS NULL OR dono = ''");

echo "<hr><h2 style='color:#28c76f'>✅ PROCESSO CONCLUÍDO!</h2>";
echo "<p>As datas reais foram preservadas e os perfis vinculados.</p>";
echo "<a href='clientes.php' style='background:#7367f0; color:#fff; padding:12px 20px; text-decoration:none; border-radius:5px;'>IR PARA O PAINEL</a>";
?>
