<?php
session_start();
require_once 'conexao.php'; // Traz $connUser e $connGeral

// --- 1. BUSCA CONFIGURAÇÕES DO SITE (NOME E COR) ---
$nomePainel = "IPTV PANEL"; 
$corPrimaria = "#7367f0"; 
try {
    $conf = $connGeral->query("SELECT NomePainel, TemaPainel FROM site_config WHERE id=1 LIMIT 1")->fetch(PDO::FETCH_ASSOC);
    if ($conf) {
        if (!empty($conf['NomePainel'])) $nomePainel = $conf['NomePainel'];
        if (!empty($conf['TemaPainel'])) $corPrimaria = $conf['TemaPainel'];
    }
} catch (Exception $e) { }

$erro = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = trim($_POST['usuario']);
    $senha = trim($_POST['senha']);

    try {
        // TENTA ADMIN
        $stmt = $connUser->prepare("SELECT id, usuario, senha FROM admin WHERE usuario = ? LIMIT 1");
        $stmt->execute([$usuario]);
        $user = $stmt->fetch();

        if ($user && $senha === $user['senha']) {
            $_SESSION['logado'] = true;
            $_SESSION['usuario'] = $user['usuario'];
            $_SESSION['nivel'] = 'admin';
            header("Location: index.php"); exit;
        }

        // TENTA REVENDA
        $stmt = $connUser->prepare("SELECT id, usuario, senha FROM rev WHERE usuario = ? LIMIT 1");
        $stmt->execute([$usuario]);
        $rev = $stmt->fetch();

        if ($rev && $senha === $rev['senha']) {
            $_SESSION['logado'] = true;
            $_SESSION['usuario'] = $rev['usuario'];
            $_SESSION['nivel'] = 'revenda';
            header("Location: index.php"); exit;
        }
        $erro = "Usuário ou senha inválidos!";
    } catch (PDOException $e) { $erro = "Erro no sistema."; }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | <?= htmlspecialchars($nomePainel) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { 
            --primary: <?= $corPrimaria ?>; 
            --bg-body: #151521; 
            --bg-card: #1e1e2d; 
        }
        body { background-color: var(--bg-body); color: #fff; height: 100vh; display: flex; align-items: center; justify-content: center; font-family: 'Segoe UI', sans-serif; overflow: hidden; }
        
        .login-card { background: var(--bg-card); border: 1px solid rgba(255,255,255,0.1); border-radius: 15px; width: 100%; max-width: 400px; padding: 40px; box-shadow: 0 10px 30px rgba(0,0,0,0.5); }
        
        /* ALTA VISIBILIDADE DAS ETIQUETAS E TEXTOS INTERNOS */
        .form-label { color: #ffffff !important; font-weight: 700; text-transform: uppercase; font-size: 0.85rem; letter-spacing: 1px; margin-bottom: 8px; }
        
        /* CONFIGURAÇÃO DO CAMPO DE TEXTO PARA MÁXIMA NITIDEZ */
        .form-control { 
            background: #2b2b40 !important; 
            border: 1px solid #444 !important; 
            color: #ffffff !important; /* Cor do texto que você digita */
            height: 55px; 
            font-size: 1rem;
            font-weight: 500;
        }

        /* COR DO TEXTO DE EXEMPLO (PLACEHOLDER) */
        .form-control::placeholder {
            color: rgba(255, 255, 255, 0.5) !important; /* Branco suave para ser bem visível */
            font-weight: 400;
        }

        .input-group-text { background: #2b2b40 !important; border: 1px solid #444 !important; color: var(--primary) !important; cursor: pointer; padding: 0 15px; }
        
        .btn-login { background: var(--primary); border: none; height: 55px; font-weight: bold; font-size: 1.1rem; transition: 0.3s; color: #fff; text-transform: uppercase; }
        .btn-login:hover { filter: brightness(1.2); transform: translateY(-2px); color: #fff; }
        
        .logo-icon { font-size: 3.5rem; color: var(--primary); margin-bottom: 15px; text-shadow: 0 0 15px var(--primary); }
    </style>
</head>
<body>

<div class="login-card text-center">
    <i class="fas fa-tv logo-icon"></i>
    <h3 class="fw-bold mb-1 text-white"><?= htmlspecialchars($nomePainel) ?></h3>
    <p class="text-white-50 mb-4 small">Acesse seu painel de controle</p>

    <?php if($erro): ?><div class="alert alert-danger border-0 small p-2 mb-3 fw-bold"><?= $erro ?></div><?php endif; ?>

    <form method="POST">
        <div class="mb-3 text-start">
            <label class="form-label">Usuário</label>
            <div class="input-group">
                <span class="input-group-text"><i class="fas fa-user"></i></span>
                <input type="text" name="usuario" class="form-control" required placeholder="Seu login aqui">
            </div>
        </div>

        <div class="mb-4 text-start">
            <label class="form-label">Senha</label>
            <div class="input-group">
                <span class="input-group-text"><i class="fas fa-lock"></i></span>
                <input type="password" name="senha" id="inputSenha" class="form-control" required placeholder="Sua senha aqui">
                <span class="input-group-text" onclick="togglePassword()">
                    <i class="fas fa-eye" id="iconEye"></i>
                </span>
            </div>
        </div>

        <button type="submit" class="btn btn-primary w-100 btn-login">ENTRAR NO PAINEL</button>
    </form>
</div>

<script>
    function togglePassword() {
        const input = document.getElementById('inputSenha');
        const icon = document.getElementById('iconEye');
        if (input.type === "password") {
            input.type = "text";
            icon.classList.replace('fa-eye', 'fa-eye-slash');
        } else {
            input.type = "password";
            icon.classList.replace('fa-eye-slash', 'fa-eye');
        }
    }
</script>

</body>
</html>
