<?php
require_once 'conexao.php';
echo "<h2>🛠️ Convertendo Datas Importadas</h2>";

try {
    // 1. Pega os usuários para analisar o que tem dentro da coluna
    $usuarios = $connUser->query("SELECT id, usuario, data_premio FROM usuario")->fetchAll(PDO::FETCH_ASSOC);
    $convertidos = 0;

    foreach ($usuarios as $u) {
        $id = $u['id'];
        $valor = trim($u['data_premio']);
        $nova_data = null;

        // Se for um número grande (Ex: 1742000000)
        if (is_numeric($valor) && $valor > 100000000) {
            $nova_data = date('Y-m-d', $valor);
        } 
        // Se for data no formato brasileiro (Ex: 15/03/2026)
        elseif (preg_match('/^\d{2}\/\d{2}\/\d{4}$/', $valor)) {
            $partes = explode('/', $valor);
            $nova_data = $partes[2] . '-' . $partes[1] . '-' . $partes[0];
        }

        if ($nova_data) {
            $stmt = $connUser->prepare("UPDATE usuario SET data_premio = ? WHERE id = ?");
            $stmt->execute([$nova_data, $id]);
            $convertidos++;
        }
    }

    echo "<h3 style='color:green'>Sucesso! $convertidos datas foram convertidas corretamente.</h3>";
    echo "<p>Verifique agora a sua lista de clientes.</p>";

} catch (Exception $e) { echo "Erro: " . $e->getMessage(); }
?>
