<?php
session_start();
// Verifica se está logado e se é ADMIN
if (!isset($_SESSION['logado']) || $_SESSION['nivel'] !== 'admin') { 
    header("Location: login.php"); 
    exit; 
}

// --- INTEGRAÇÃO COM O ARQUIVO CENTRAL ---
require_once 'conexao.php';

// Agora usamos a variável $connAcessos que vem do conexao.php

$msg = "";
$msg_tipo = "";
$usuario_logado = $_SESSION['usuario'];

// --- SALVAR DADOS ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Verifica se existe registro usando a conexão de ACESSOS
        $check = $connAcessos->prepare("SELECT id FROM servidorcsp WHERE CadUser = :user");
        $check->execute([':user' => $usuario_logado]);
        $existe = $check->rowCount() > 0;

        $campos = [
            ':user' => $usuario_logado,
            ':visualizar' => $_POST['visualizar'],
            ':adicionar'  => $_POST['adicionar'],
            ':config'     => $_POST['config'],
            ':info'       => $_POST['info'],
            ':bloquear'   => $_POST['bloquear'],
            ':editar'     => $_POST['editar'],
            ':excluir'    => $_POST['excluir']
        ];

        if ($existe) {
            $sql = "UPDATE servidorcsp SET 
                    ServidorcspVisualizar = :visualizar, ServidorcspAdicionar = :adicionar,
                    ServidorcspConfig = :config, ServidorcspInfo = :info,
                    ServidorcspBloquear = :bloquear, ServidorcspEditar = :editar,
                    ServidorcspExcluir = :excluir
                    WHERE CadUser = :user";
        } else {
            // Insere novo registro
            $sql = "INSERT INTO servidorcsp (CadUser, grupo, id_grupo, ServidorcspVisualizar, ServidorcspAdicionar, ServidorcspConfig, ServidorcspInfo, ServidorcspBloquear, ServidorcspEditar, ServidorcspExcluir)
                    VALUES (:user, 'padrao', 1, :visualizar, :adicionar, :config, :info, :bloquear, :editar, :excluir)";
        }

        $stmt = $connAcessos->prepare($sql);
        $stmt->execute($campos);
        $msg = "Permissões salvas com sucesso!";
        $msg_tipo = "success";

    } catch (PDOException $e) {
        $msg = "Erro ao salvar no banco de acessos: " . $e->getMessage();
        $msg_tipo = "danger";
    }
}

// --- BUSCAR DADOS ---
try {
    $stmt = $connAcessos->prepare("SELECT * FROM servidorcsp WHERE CadUser = ?");
    $stmt->execute([$usuario_logado]);
    $dados = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Erro ao ler dados: " . $e->getMessage());
}

// Função para marcar o select
function check($valor_banco, $valor_opcao) {
    return ($valor_banco == $valor_opcao) ? 'selected' : '';
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Permissões CSP | Painel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --bg-body: #151521; --bg-card: #1e1e2d; --primary: #7367f0; }
        body { background: var(--bg-body); color: #fff; font-family: 'Segoe UI', sans-serif; }
        
        .sidebar { width: 260px; height: 100vh; position: fixed; background: #1e1e2d; padding: 20px; border-right: 1px solid #333; transition: 0.3s; z-index: 1000; }
        .main-content { margin-left: 260px; padding: 30px; transition: 0.3s; }

        /* AJUSTE DE VISIBILIDADE */
        .form-label { color: #ffffff !important; font-weight: 700; font-size: 0.95rem; margin-bottom: 5px; display: block; }
        .text-descricao { color: #cccccc !important; font-size: 0.9rem; margin-bottom: 20px; } /* Nova classe para o texto */

        .card-custom { background: var(--bg-card); border: 1px solid rgba(255,255,255,0.1); border-radius: 12px; padding: 25px; }
        .form-select { background: #2b2b40 !important; border: 1px solid #444 !important; color: #fff !important; height: 45px; }
        
        /* Cores dos options */
        option[value="sim"] { background-color: #198754; color: white; }
        option[value="nao"] { background-color: #dc3545; color: white; }

        @media (max-width: 768px) {
            .sidebar { transform: translateX(-100%); } .sidebar.show { transform: translateX(0); }
            .main-content { margin-left: 0; padding: 15px; } .mobile-toggle { display: block !important; }
        }
        .mobile-toggle { display: none; font-size: 1.5rem; color: #fff; background: none; border: none; margin-bottom: 20px; }
        .nav-link { color: #a6a6b7; text-decoration: none; display: flex; align-items: center; gap: 10px; padding: 10px; border-radius: 8px; }
        .nav-link.active { background: var(--primary); color: #fff; }
    </style>
</head>
<body>

<nav class="sidebar" id="sidebar">
    <h4 class="mb-4 fw-bold text-white"><i class="fas fa-tv text-primary"></i> Painel v3.0</h4>
    <div class="nav flex-column gap-2">
        <a href="index.php" class="nav-link text-white"><i class="fas fa-home"></i> Dashboard</a>
        <a href="permissoes_server.php" class="nav-link active text-white"><i class="fas fa-server"></i> Permissões CSP</a>
        <a href="revendedores.php" class="nav-link text-white"><i class="fas fa-store"></i> Revendedores</a>
        <a href="configuracoes.php" class="nav-link text-white"><i class="fas fa-cog"></i> Configurações</a>
        <a href="sair.php" class="nav-link text-danger mt-4"><i class="fas fa-sign-out-alt"></i> Sair</a>
    </div>
</nav>

<main class="main-content">
    <button class="mobile-toggle" onclick="document.getElementById('sidebar').classList.toggle('show')"><i class="fas fa-bars"></i></button>

    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card card-custom">
                <h4 class="text-primary mb-2">Gerenciar Permissões CSP</h4>
                
                <p class="text-descricao">Defina o que pode ser feito no servidor (Banco: ACESSOS).</p>
                
                <?php if($msg): ?>
                    <div class="alert alert-<?= $msg_tipo ?> alert-dismissible fade show">
                        <?= $msg ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <form method="POST">
                    <div class="row g-3">
                        <?php 
                        $opcoes = [
                            'Visualizar' => 'ServidorcspVisualizar',
                            'Adicionar' => 'ServidorcspAdicionar',
                            'Configurar' => 'ServidorcspConfig',
                            'Informações' => 'ServidorcspInfo',
                            'Bloquear' => 'ServidorcspBloquear',
                            'Editar' => 'ServidorcspEditar',
                            'Excluir' => 'ServidorcspExcluir'
                        ];
                        
                        foreach($opcoes as $label => $coluna): 
                            $name = strtolower(str_replace('Servidorcsp', '', $coluna));
                            if($name == 'config') $name = 'config'; 
                            if($name == 'informações') $name = 'info';
                        ?>
                        <div class="col-6 col-md-4">
                            <label class="form-label"><?= $label ?></label>
                            <select name="<?= $name ?>" class="form-select <?= ($label == 'Excluir') ? 'border-danger' : '' ?>">
                                <option value="sim" <?= check($dados[$coluna] ?? '', 'sim') ?>>Sim</option>
                                <option value="nao" <?= check($dados[$coluna] ?? '', 'nao') ?>>Não</option>
                            </select>
                        </div>
                        <?php endforeach; ?>
                    </div>

                    <div class="mt-4 border-top border-secondary pt-3">
                        <button type="submit" class="btn btn-primary w-100 p-3 fw-bold">
                            <i class="fas fa-save me-2"></i> Salvar Permissões
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
