<?php
// ARQUIVO: restaurar_modelos_email.php
require_once 'conexao.php';
@set_time_limit(0);

echo "<h1>📩 RESTAURAÇÃO DE MODELOS DE EMAIL</h1>";
echo "<p>Criando modelos padrão (Teste, Vencimento, Novo Cliente)...</p><hr>";

try {
    // 1. LIMPA A TABELA PARA EVITAR DUPLICIDADE (Opcional, mas recomendado se estiver bugado)
    $connGeral->exec("DELETE FROM email_modelo");
    echo "<div style='color:orange'>🗑️ Tabela limpa para receber novos dados.</div>";

    // 2. DEFINE OS MODELOS PADRÃO
    // Aqui usamos {nome}, {login}, {senha} que o painel substitui automaticamente
    $modelos = [
        [
            'tipo' => 'teste',
            'assunto' => 'Seu Teste Solicitado - TVSBR',
            'mensagem' => "Olá, aqui está o seu teste solicitado!\n\n📺 *Dados de Acesso:*\n👤 Usuário: {login}\n🔑 Senha: {senha}\n📅 Vencimento: {vencimento}\n\n🔗 *Aplicativo:* {app_url}\n\nCaso precise de ajuda, entre em contato!"
        ],
        [
            'tipo' => 'novo_usuario',
            'assunto' => 'Bem-vindo! Dados de Acesso',
            'mensagem' => "Seja bem-vindo!\n\nSeguem seus dados de acesso:\n👤 Usuário: {login}\n🔑 Senha: {senha}\n📅 Validade: {vencimento}\n\nObrigado pela preferência!"
        ],
        [
            'tipo' => 'vencimento',
            'assunto' => 'Aviso: Sua assinatura vai vencer',
            'mensagem' => "Olá {nome},\n\nSua assinatura vence no dia {vencimento}.\nPara evitar o corte do sinal, entre em contato para renovar.\n\nAtenciosamente,\nEquipe TVSBR"
        ],
        [
            'tipo' => 'renovacao',
            'assunto' => 'Renovação Concluída com Sucesso',
            'mensagem' => "Pagamento confirmado!\n\nSua assinatura foi renovada até o dia {vencimento}.\n\nObrigado por continuar conosco!"
        ],
        [
            'tipo' => 'cobranca',
            'assunto' => 'Lembrete de Pagamento',
            'mensagem' => "Olá,\n\nEste é um lembrete amigável sobre sua fatura pendente.\nValor: R$ {valor}\nVencimento: {vencimento}\n\nLink Pix: {pix_copia_cola}"
        ]
    ];

    // 3. INSERE NO BANCO
    $sql = "INSERT INTO email_modelo (tipo, assunto, mensagem, dono) VALUES (:tipo, :assunto, :mensagem, 'admin')";
    $stmt = $connGeral->prepare($sql);

    foreach ($modelos as $modelo) {
        $stmt->execute([
            ':tipo' => $modelo['tipo'],
            ':assunto' => $modelo['assunto'],
            ':mensagem' => $modelo['mensagem']
        ]);
        echo "<div style='color:green'>✔ Modelo <b>" . strtoupper($modelo['tipo']) . "</b> criado com sucesso.</div>";
    }

    echo "<hr><h1 style='color:green'>TUDO PRONTO!</h1>";
    echo "<p>Agora os modelos existem. Volte lá e os botões aparecerão.</p>";
    echo "<a href='gerenciar_email.php' style='background:#7367f0; color:white; padding:10px 20px; text-decoration:none; border-radius:5px;'>Voltar para Emails</a>";

} catch (Exception $e) {
    echo "<h2 style='color:red'>Erro: " . $e->getMessage() . "</h2>";
}
?>
