<?php
// ARQUIVO: reparar_revendedores.php
require_once 'conexao.php';
@set_time_limit(0);

echo "<h1>👔 REPARO DE REVENDEDORES E EMAILS</h1>";
echo "<p>O diagnóstico mostrou que 'usuario' está ok. Agora vamos consertar a tabela 'rev' e 'teste'.</p><hr>";

// ==========================================================
// 1. CONSERTAR TABELA 'REV' (Revendedores)
// ==========================================================
echo "<h3>1. Verificando Tabela de Revendedores (rev)</h3>";

$colunas_rev = [
    "limite INT(11) DEFAULT 100",
    "dono VARCHAR(100) DEFAULT 'admin'",
    "email VARCHAR(255) DEFAULT NULL",
    "celular VARCHAR(50) DEFAULT NULL",
    "saldo DECIMAL(10,2) DEFAULT 0.00"
];

try {
    // Adiciona colunas que faltam na tabela REV
    foreach ($colunas_rev as $col) {
        $nome = explode(' ', $col)[0];
        try {
            $connUser->exec("ALTER TABLE rev ADD COLUMN $col");
            echo "<div style='color:green'>✔ Coluna <b>$nome</b> criada na tabela 'rev'.</div>";
        } catch (Exception $e) {
            // echo "<div style='color:gray'>...Coluna $nome já existe em 'rev'.</div>";
        }
    }

    // Preenche limites vazios em REV
    $connUser->query("UPDATE rev SET limite = 100 WHERE limite IS NULL OR limite = 0");
    $connUser->query("UPDATE rev SET dono = 'admin' WHERE dono IS NULL OR dono = ''");
    echo "<div style='color:blue'>✔ Dados vazios de revendedores preenchidos (Limites e Donos).</div>";

} catch (Exception $e) {
    echo "<div style='color:red'>Erro na tabela REV: " . $e->getMessage() . "</div>";
}

// ==========================================================
// 2. CONSERTAR TABELA 'TESTE' (Pode afetar Emails)
// ==========================================================
echo "<hr><h3>2. Verificando Tabela de Testes (teste)</h3>";

$colunas_teste = [
    "dono VARCHAR(100) DEFAULT 'admin'",
    "email VARCHAR(255) DEFAULT NULL",
    "celular VARCHAR(50) DEFAULT NULL"
];

try {
    foreach ($colunas_teste as $col) {
        $nome = explode(' ', $col)[0];
        try {
            $connUser->exec("ALTER TABLE teste ADD COLUMN $col");
            echo "<div style='color:green'>✔ Coluna <b>$nome</b> criada na tabela 'teste'.</div>";
        } catch (Exception $e) { }
    }
    // Cura dados vazios
    $connUser->query("UPDATE teste SET dono = 'admin' WHERE dono IS NULL OR dono = ''");
    echo "<div style='color:blue'>✔ Dados vazios de testes corrigidos.</div>";

} catch (Exception $e) {
    echo "<div style='color:red'>Erro na tabela TESTE: " . $e->getMessage() . "</div>";
}

// ==========================================================
// 3. CONSERTAR TABELA 'EMAIL_ADICIONAR' (No Banco Geral)
// ==========================================================
echo "<hr><h3>3. Verificando Tabela de Disparo de Emails</h3>";
// As vezes o erro de 'dono' vem daqui se o painel salva histórico de envio

try {
    // Verifica se a tabela existe antes de mexer
    $check = $connGeral->query("SHOW TABLES LIKE 'email_adicionar'");
    if ($check->rowCount() > 0) {
        try {
            $connGeral->exec("ALTER TABLE email_adicionar ADD COLUMN dono VARCHAR(100) DEFAULT 'admin'");
            echo "<div style='color:green'>✔ Coluna <b>dono</b> criada na tabela 'email_adicionar'.</div>";
            $connGeral->query("UPDATE email_adicionar SET dono = 'admin' WHERE dono IS NULL");
        } catch (Exception $e) {}
    } else {
        echo "Tabela email_adicionar não encontrada (normal em alguns painéis).";
    }
} catch (Exception $e) {
    echo "Erro: " . $e->getMessage();
}

echo "<hr><h1 style='color:green'>AGORA VAI!</h1>";
echo "<p>Volte ao painel e tente acessar 'Revendedores' e 'Gerenciar Email'.</p>";
echo "<a href='index.php' style='background:#7367f0; color:white; padding:10px 20px; text-decoration:none; border-radius:5px;'>Voltar ao Painel</a>";
?>
