<?php
// ============================================================
// SCRIPT MESTRE DE REPARO E CONFIGURAÇÃO TOTAL
// ============================================================
require_once 'conexao.php';
@set_time_limit(0);

echo "<body style='background:#151521; color:#fff; font-family:sans-serif; padding:20px;'>";
echo "<h2>🛡️ Sistema Mestre de Reparo e Migração</h2><hr>";

// --- FUNÇÃO PARA EXECUTAR SQL EM BLOCO ---
function executarBloco($db, $sqls, $titulo) {
    echo "<h3>📦 $titulo</h3>";
    foreach ($sqls as $sql) {
        try {
            $db->exec($sql);
            echo "<div style='color:#28c76f; font-size:12px;'>✔ Sucesso: ".substr($sql, 0, 50)."...</div>";
        } catch (Exception $e) {
            // Ignora erros de colunas ou tabelas que já existem
        }
    }
}

// ============================================================
// 1. BANCO DE USUÁRIOS (_user) - Clientes, Revendas e Pagamento
// ============================================================
$sql_user = [
    // Estrutura de Usuários e Revendas
    "ALTER TABLE usuario ADD COLUMN IF NOT EXISTS id_perfil INT(11) DEFAULT 1",
    "ALTER TABLE usuario ADD COLUMN IF NOT EXISTS dono VARCHAR(100) DEFAULT 'admin'",
    "ALTER TABLE usuario ADD COLUMN IF NOT EXISTS limite INT(11) DEFAULT 1",
    "ALTER TABLE usuario ADD COLUMN IF NOT EXISTS data_premio DATE NULL",
    "ALTER TABLE rev ADD COLUMN IF NOT EXISTS dono VARCHAR(100) DEFAULT 'admin'",
    "ALTER TABLE rev ADD COLUMN IF NOT EXISTS limite INT(11) DEFAULT 100",
    
    // Tabela de Pagamentos (Corrigindo erro de usuario_painel)
    "CREATE TABLE IF NOT EXISTS configuracoes_pagamento (
        id INT AUTO_INCREMENT PRIMARY KEY, 
        access_token VARCHAR(255), 
        public_key VARCHAR(255), 
        usuario_painel VARCHAR(100) DEFAULT 'admin', 
        valor_padrao DECIMAL(10,2) DEFAULT 30.00, 
        tipo VARCHAR(50) DEFAULT 'mercadopago',
        ativo INT(1) DEFAULT 1
    )",
    "ALTER TABLE configuracoes_pagamento ADD COLUMN IF NOT EXISTS usuario_painel VARCHAR(100) DEFAULT 'admin'",
    
    // Tabela de Custos por Perfil
    "CREATE TABLE IF NOT EXISTS rev_perfil (id INT AUTO_INCREMENT PRIMARY KEY, id_rev INT, id_perfil INT, valor_custo DECIMAL(10,2) DEFAULT 0.00)"
];
executarBloco($connUser, $sql_user, "Ajustando Banco de Usuários e Pagamentos");

// ============================================================
// 2. BANCO GERAL (_geral) - Emails, SMTP e Backups
// ============================================================
$sql_geral = [
    // Módulo de Email
    "CREATE TABLE IF NOT EXISTS email_modelo (id INT AUTO_INCREMENT PRIMARY KEY, tipo VARCHAR(50), assunto VARCHAR(255), mensagem TEXT, dono VARCHAR(100) DEFAULT 'admin', ativo INT(1) DEFAULT 1)",
    "ALTER TABLE email_modelo ADD COLUMN IF NOT EXISTS ativo INT(1) DEFAULT 1",
    "ALTER TABLE email_modelo ADD COLUMN IF NOT EXISTS dono VARCHAR(100) DEFAULT 'admin'",
    
    "CREATE TABLE IF NOT EXISTS smtp_config (id INT AUTO_INCREMENT PRIMARY KEY, host VARCHAR(255) DEFAULT 'smtp.gmail.com', email VARCHAR(255), senha VARCHAR(255), porta VARCHAR(10) DEFAULT '587', dono VARCHAR(100) DEFAULT 'admin')",
    
    // Módulo de Backup (PixelDrain)
    "CREATE TABLE IF NOT EXISTS arquivo_backup (id INT AUTO_INCREMENT PRIMARY KEY, tipo VARCHAR(50), local VARCHAR(255), data DATETIME DEFAULT CURRENT_TIMESTAMP, size VARCHAR(50), link_externo VARCHAR(255))",
    "ALTER TABLE arquivo_backup ADD COLUMN IF NOT EXISTS link_externo VARCHAR(255) DEFAULT NULL"
];
executarBloco($connGeral, $sql_geral, "Ajustando Banco Geral, Emails e Backups");

// ============================================================
// 3. BANCO DE ACESSOS (_acessos) - Logs
// ============================================================
$sql_acessos = [
    "CREATE TABLE IF NOT EXISTS logs (id INT AUTO_INCREMENT PRIMARY KEY, mensagem TEXT, data DATETIME DEFAULT CURRENT_TIMESTAMP, usuario VARCHAR(100))"
];
executarBloco($connAcessos, $sql_acessos, "Ajustando Banco de Logs");

// ============================================================
// 4. MÁGICA: SINCRONIZAÇÃO DE DATAS E PERFIS (Onde os dados já existem)
// ============================================================
echo "<h3>📅 Sincronizando Datas Reais do Backup...</h3>";
try {
    $stmt = $connUser->query("SELECT id, data_premio, vencimento, expire_date, exp_date, validade FROM usuario");
    $cont = 0;
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $nova_data = null;
        // Tenta achar a data em qualquer uma das colunas comuns de backup
        $candidatos = [$row['data_premio'], $row['vencimento'], $row['expire_date'], $row['exp_date'], $row['validade']];
        
        foreach ($candidatos as $v) {
            if (empty($v) || $v == '0' || $v == 'S') continue;
            if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $v)) { $nova_data = $v; break; } // Já YYYY-MM-DD
            if (is_numeric($v) && $v > 100000000) { $nova_data = date('Y-m-d', $v); break; } // Timestamp
            if (strpos($v, '/') !== false) { // DD/MM/YYYY
                $p = explode('/', $v);
                if(count($p)==3) { $nova_data = $p[2].'-'.$p[1].'-'.$p[0]; break; }
            }
        }

        if ($nova_data) {
            $upd = $connUser->prepare("UPDATE usuario SET data_premio = ?, id_perfil = 1, dono = 'admin' WHERE id = ?");
            $upd->execute([$nova_data, $row['id']]);
            $cont++;
        }
    }
    echo "<div style='color:#28c76f'>✔ $cont usuários sincronizados com datas reais e perfis!</div>";
} catch (Exception $e) { echo "Erro nas datas: ".$e->getMessage(); }

// ============================================================
// 5. FINALIZAÇÃO E LIMPEZA
// ============================================================
// Define 30 dias de bônus APENAS para quem ainda ficou sem data (evita 1969)
$connUser->exec("UPDATE usuario SET data_premio = DATE_ADD(CURDATE(), INTERVAL 30 DAY) WHERE data_premio < '2020-01-01' OR data_premio IS NULL");

echo "<hr><h2 style='color:#28c76f; text-align:center;'>✅ TUDO CONSERTADO!</h2>";
echo "<p style='text-align:center;'><a href='index.php' style='background:#7367f0; color:#fff; padding:15px 30px; text-decoration:none; border-radius:5px; font-weight:bold;'>VOLTAR AO PAINEL</a></p>";
?>
