<?php
// ARQUIVO: reparo_total_blindado.php
require_once 'conexao.php';
@set_time_limit(0);

echo "<h1>🛡️ REPARO TOTAL BLINDADO (Multi-Bancos)</h1>";
echo "<p>Vamos caçar a tabela 'usuario' em todos os bancos e corrigir tudo.</p><hr>";

// Define as colunas que TEM QUE EXISTIR em qualquer tabela de usuário
$colunas_obrigatorias = [
    "dono VARCHAR(100) DEFAULT 'admin'",
    "limite INT(11) DEFAULT 100",
    "id_perfil INT(11) DEFAULT 1",
    "mac VARCHAR(100) DEFAULT NULL",
    "bloqueado VARCHAR(10) DEFAULT 'nao'",
    "vencimento_email_enviado INT(1) DEFAULT 0",
    "email VARCHAR(255) DEFAULT NULL"
];

// Lista de conexões para verificar
$bancos = [
    'BANCO USER (Clientes)' => $connUser,
    'BANCO GERAL (Config)'  => $connGeral,
    'BANCO ACESSOS (Logs)'  => $connAcessos
];

foreach ($bancos as $nome_banco => $conn) {
    echo "<h3>🔎 Verificando: $nome_banco</h3>";
    
    try {
        // Verifica se existe tabela 'usuario' neste banco
        $stmt = $conn->query("SHOW TABLES LIKE 'usuario'");
        if ($stmt->rowCount() > 0) {
            echo "<div style='color:blue'>Encontrei tabela <b>usuario</b> aqui! Iniciando reparo...</div>";
            
            // 1. CRIA COLUNAS QUE FALTAM
            foreach ($colunas_obrigatorias as $col_sql) {
                $nome_col = explode(' ', $col_sql)[0];
                try {
                    $conn->exec("ALTER TABLE usuario ADD COLUMN $col_sql");
                    echo "<div style='color:green'>&nbsp;&nbsp;✔ Coluna <b>$nome_col</b> CRIADA com sucesso.</div>";
                } catch (Exception $e) {
                    // Ignora se já existe
                }
            }
            
            // 2. PREENCHE DADOS VAZIOS (CURA)
            $conn->query("UPDATE usuario SET limite = 100 WHERE limite IS NULL OR limite = 0");
            $conn->query("UPDATE usuario SET dono = 'admin' WHERE dono IS NULL OR dono = ''");
            $conn->query("UPDATE usuario SET id_perfil = 1 WHERE id_perfil IS NULL OR id_perfil = 0");
            
            echo "<div style='color:green'>&nbsp;&nbsp;✔ Dados vazios preenchidos (Limites, Donos, Perfis).</div>";
            
        } else {
            echo "<div style='color:gray'>Nenhuma tabela 'usuario' neste banco. Pulei.</div>";
        }

        // Verifica também a tabela 'revendedores' (alguns painéis separam)
        $stmt = $conn->query("SHOW TABLES LIKE 'revendedores'");
        if ($stmt->rowCount() > 0) {
            echo "<div style='color:blue; margin-top:10px'>Encontrei tabela <b>revendedores</b>! Verificando colunas...</div>";
             // Aplica correções na tabela revendedores se ela existir
             try { $conn->exec("ALTER TABLE revendedores ADD COLUMN limite INT(11) DEFAULT 100"); } catch(Exception $e){}
             $conn->query("UPDATE revendedores SET limite = 100 WHERE limite IS NULL OR limite = 0");
             echo "<div style='color:green'>&nbsp;&nbsp;✔ Tabela Revendedores corrigida.</div>";
        }

    } catch (Exception $e) {
        echo "<div style='color:red'>Erro ao acessar este banco: " . $e->getMessage() . "</div>";
    }
    echo "<hr>";
}

echo "<h2>✅ FIM DO PROCESSO</h2>";
echo "<p>Todos os lugares possíveis foram verificados. Teste o painel agora.</p>";
echo "<a href='index.php' style='background:#7367f0; color:white; padding:10px 20px; text-decoration:none; border-radius:5px;'>Voltar ao Painel</a>";
?>
