<?php
// ARQUIVO: reparo_urgente.php
require_once 'conexao.php';
@set_time_limit(0);

echo "<h2>🚑 REPARO URGENTE DA TABELA USUÁRIOS</h2>";
echo "<p>Recriando colunas que sumiram...</p><hr>";

try {
    // 1. FORÇA A CRIAÇÃO DAS COLUNAS FALTANTES
    $colunas_para_criar = [
        "dono VARCHAR(100) DEFAULT 'admin'",
        "limite INT(11) DEFAULT 100",
        "id_perfil INT(11) DEFAULT 1",
        "mac VARCHAR(100) DEFAULT NULL",
        "bloqueado VARCHAR(10) DEFAULT 'nao'",
        "vencimento_email_enviado INT(1) DEFAULT 0"
    ];

    foreach ($colunas_para_criar as $col_sql) {
        $nome_col = explode(' ', $col_sql)[0];
        try {
            $connUser->exec("ALTER TABLE usuario ADD COLUMN $col_sql");
            echo "<div style='color:green'>✔ Coluna <b>$nome_col</b> recriada com sucesso.</div>";
        } catch (PDOException $e) {
            // Ignora erro se já existe, mas avisa
            if (strpos($e->getMessage(), "Duplicate column") === false) {
                echo "<div style='color:red'>Erro ao criar $nome_col: " . $e->getMessage() . "</div>";
            } else {
                echo "<div style='color:blue'>Info: Coluna <b>$nome_col</b> já existia.</div>";
            }
        }
    }

    echo "<hr><h3>Preenchendo dados vazios...</h3>";

    // 2. PREENCHE OS DADOS VAZIOS PARA NÃO DAR ERRO NO PAINEL
    // Arruma Limite Vazio
    $stmt = $connUser->query("UPDATE usuario SET limite = 100 WHERE limite IS NULL OR limite = 0");
    echo "<div>✔ Limites corrigidos: " . $stmt->rowCount() . " clientes.</div>";

    // Arruma Dono Vazio
    $stmt = $connUser->query("UPDATE usuario SET dono = 'admin' WHERE dono IS NULL OR dono = ''");
    echo "<div>✔ Donos definidos como 'admin': " . $stmt->rowCount() . " clientes.</div>";

    // Arruma Perfil Vazio
    $stmt = $connUser->query("UPDATE usuario SET id_perfil = 1 WHERE id_perfil IS NULL OR id_perfil = 0");
    echo "<div>✔ Perfis vinculados: " . $stmt->rowCount() . " clientes.</div>";
    
    // Arruma tabela rev_perfil (Custo por revenda)
    $sql_rev = "CREATE TABLE IF NOT EXISTS rev_perfil (
        id INT AUTO_INCREMENT PRIMARY KEY,
        id_rev INT,
        id_perfil INT,
        valor_custo DECIMAL(10,2) DEFAULT 0.00
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    $connUser->exec($sql_rev);
    echo "<div>✔ Tabela rev_perfil verificada.</div>";

    echo "<hr><h1 style='color:green'>CONCLUÍDO!</h1>";
    echo "<p>Tente acessar 'Gerenciar Email' e 'Revendedores' novamente.</p>";
    echo "<a href='index.php' style='background:#7367f0; color:white; padding:10px 20px; text-decoration:none; border-radius:5px;'>Voltar ao Painel</a>";

} catch (Exception $e) {
    echo "<h2 style='color:red'>Erro Fatal: " . $e->getMessage() . "</h2>";
}
?>
