<?php
require_once 'conexao.php';

echo "<h1>🕵️ DIAGNÓSTICO DE BANCO DE DADOS</h1>";

// Função para listar colunas
function listarColunas($conn, $nome_banco) {
    echo "<div style='background:#f0f0f0; padding:10px; border:1px solid #ccc; margin-bottom:10px;'>";
    echo "<h3>Banco Conectado: <span style='color:blue'>$nome_banco</span></h3>";
    
    try {
        // Pega o nome real do banco que está conectado
        $stmt = $conn->query("SELECT DATABASE()");
        $dbName = $stmt->fetchColumn();
        echo "<b>Nome Real do Banco no MySQL:</b> " . $dbName . "<br><br>";

        // Tenta listar tabelas
        echo "<b>Tabelas encontradas:</b><br>";
        $tabelas = $conn->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
        
        if (count($tabelas) == 0) {
            echo "<span style='color:red'>NENHUMA TABELA ENCONTRADA!</span>";
        } else {
            foreach ($tabelas as $tab) {
                echo "- $tab ";
                // Se for tabela de usuario, mostra as colunas
                if (strtolower($tab) == 'usuario' || strtolower($tab) == 'users' || strtolower($tab) == 'revendedores') {
                    echo " <b style='color:green'>(Analisando colunas...)</b><br>";
                    $cols = $conn->query("SHOW COLUMNS FROM $tab")->fetchAll(PDO::FETCH_ASSOC);
                    
                    $tem_dono = false;
                    $tem_limite = false;
                    
                    echo "<ul style='font-size:12px; color:#555;'>";
                    foreach($cols as $c) {
                        $nome = $c['Field'];
                        $tipo = $c['Type'];
                        // Destaca as colunas problemáticas
                        if($nome == 'dono') { echo "<li style='color:blue; font-weight:bold'>$nome ($tipo) - OK</li>"; $tem_dono = true; }
                        elseif($nome == 'limite') { echo "<li style='color:blue; font-weight:bold'>$nome ($tipo) - OK</li>"; $tem_limite = true; }
                        elseif($nome == 'id_perfil') { echo "<li style='color:blue; font-weight:bold'>$nome ($tipo) - OK</li>"; }
                        else { echo "<li>$nome</li>"; }
                    }
                    echo "</ul>";

                    if(!$tem_dono) echo "<div style='color:red; background:#ffcccc; padding:5px;'>❌ ERRO CRÍTICO: Coluna 'dono' NÃO EXISTE nesta tabela!</div>";
                    if(!$tem_limite) echo "<div style='color:red; background:#ffcccc; padding:5px;'>❌ ERRO CRÍTICO: Coluna 'limite' NÃO EXISTE nesta tabela!</div>";
                } else {
                    echo "<br>";
                }
            }
        }

    } catch (Exception $e) {
        echo "Erro de conexão: " . $e->getMessage();
    }
    echo "</div>";
}

listarColunas($connUser, "CONEXÃO USER (Clientes)");
listarColunas($connGeral, "CONEXÃO GERAL (Config)");

echo "<br><a href='index.php'>Voltar</a>";
?>
