<?php
// webhook_cs.php - Menu Interativo (Testes 48h - Coluna data_premio)
header('Content-Type: application/json');

require_once 'conexao.php';

$json = file_get_contents('php://input');
$dados = json_decode($json, true);
$mensagem_cliente = $dados['message'] ?? $_POST['message'] ?? '';
$mensagem_lower = strtolower(trim($mensagem_cliente));

// Truque para o botão de teste do próprio aplicativo WhatsAuto funcionar
if (strpos($mensagem_lower, 'mensagem de teste') !== false) {
    $mensagem_lower = 'teste cs'; 
}

// =========================================================================
// PASSO 1: MENU DE OPERADORAS
// =========================================================================
if ($mensagem_lower === 'teste cs') {
    try {
        $stmt = $connGeral->prepare("SELECT id, nome FROM perfil ORDER BY id ASC");
        $stmt->execute();
        $perfis = $stmt->fetchAll();

        if (count($perfis) === 0) {
            echo json_encode(["reply" => "❌ Nenhuma operadora disponível no momento."]);
            exit;
        }

        $texto = "📡 *Bem-vindo! Escolha sua operadora para o teste:*\n\n";
        $texto .= "Responda apenas com o número da opção:\n\n";
        
        foreach ($perfis as $perfil) {
            $texto .= "👉 Digite *#" . $perfil['id'] . "* para *" . $perfil['nome'] . "*\n";
        }

        echo json_encode(["reply" => $texto]);
        exit;

    } catch (Exception $e) {
        echo json_encode(["reply" => "❌ Erro ao buscar operadoras: " . $e->getMessage()]);
        exit;
    }
}

// =========================================================================
// PASSO 2: GERA O TESTE (48 HORAS EXATAS NA DATA PREMIO)
// =========================================================================
if (strpos($mensagem_lower, '#') !== false) {
    $id_perfil = (int) preg_replace('/[^0-9]/', '', $mensagem_lower);

    if ($id_perfil > 0) {
        try {
            $stmt = $connGeral->prepare("SELECT nome, url, porta FROM perfil WHERE id = ?");
            $stmt->execute([$id_perfil]);
            $perfil_escolhido = $stmt->fetch();

            if (!$perfil_escolhido) {
                echo json_encode(["reply" => "❌ Operadora não encontrada. Digite *teste cs* para ver as opções novamente."]);
                exit;
            }

            // Gera usuário e senha
            $numero_aleatorio = rand(1000, 9999);
            $usuario = "cs" . $numero_aleatorio;
            $senha = (string)rand(1000, 9999);
            
            // =========================================================
            // CALCULA AS DATAS CORRETAS
            // =========================================================
            $data_atual = date('Y-m-d H:i:s');
            // time() pega os segundos de agora. 48 * 3600 adiciona exatamente 48 horas em segundos!
            $data_premio = time() + (48 * 3600); 

            // A mágica: usamos a coluna "data_premio" que descobrimos na sua foto
            $stmtInsert = $connUser->prepare("INSERT INTO teste (usuario, senha, CadUser, perfil, data_cadastro, data_premio) VALUES (?, ?, 'admin', ?, ?, ?)");
            $stmtInsert->execute([$usuario, $senha, $id_perfil, $data_atual, $data_premio]);

            $url_servidor = $perfil_escolhido['url'];
            $porta = $perfil_escolhido['porta'];
            $nome_operadora = $perfil_escolhido['nome'];
            $deskey = "01 02 03 04 05 06 07 08 09 10 11 12 13 14"; 

            $texto_mensagem = "✅ *Teste {$nome_operadora} gerado com sucesso!*\n\n";
            $texto_mensagem .= "🔗 *URL / Server:* {$url_servidor}\n";
            $texto_mensagem .= "🚪 *Porta:* {$porta}\n";
            $texto_mensagem .= "👤 *User / Nome:* {$usuario}\n";
            $texto_mensagem .= "🔑 *Pass / Senha:* {$senha}\n";
            $texto_mensagem .= "🗝️ *DES Key:* {$deskey}\n\n";
            $texto_mensagem .= "⏳ *Validade:* 48 Horas\n\n";
            $texto_mensagem .= "Insira os dados acima no seu receptor e boas emissões!";

            echo json_encode(["reply" => $texto_mensagem]);
            exit;

        } catch (Exception $e) {
            echo json_encode(["reply" => "❌ Erro ao gerar teste: " . $e->getMessage()]);
            exit;
        }
    }
}

echo json_encode(["reply" => ""]);
exit;
?>
