<?php
// 1. CONEXÃO
require_once 'conexao.php';

// Define que o arquivo é um XML
header("Content-type: text/xml; charset=utf-8");

// 2. SEGURANÇA: VERIFICA A KEY
$key_recebida = isset($_GET['key']) ? $_GET['key'] : '';
$chave_valida = false;

try {
    // Busca a chave salva no banco de Configuração Geral
    $stmt = $connGeral->query("SELECT chave_xml FROM configuracao LIMIT 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($config && $config['chave_xml'] === $key_recebida) {
        $chave_valida = true;
    }
} catch (Exception $e) {
    // Se der erro no banco, não libera
    $chave_valida = false;
}

// Se a chave estiver errada, para tudo
if (!$chave_valida) {
    echo "<?xml version='1.0'?>\n";
    echo "<error>Acesso Negado: Chave Invalida</error>";
    exit;
}

// 3. INÍCIO DO XML
echo "<?xml version='1.0' encoding='UTF-8'?>\n";
echo "<users>\n";

// Pega a hora exata de agora para comparar
$tempo_atual = time();

// --- BUSCAR USUÁRIOS (CLIENTES PAGANTES) ---
try {
    // Busca todos que não estão bloqueados (a data vamos checar no PHP)
    $sql_users = "SELECT usuario, senha, data_premio FROM usuario WHERE (bloqueado != 'sim' OR bloqueado IS NULL)";
    $stmt_u = $connUser->query($sql_users);
    $usuarios = $stmt_u->fetchAll(PDO::FETCH_ASSOC);

    foreach ($usuarios as $u) {
        // Converte a data do banco para um formato comparável
        $venc = $u['data_premio'];
        $venc_timestamp = is_numeric($venc) ? (int)$venc : strtotime($venc);
        
        // Só exibe no XML (manda pro aparelho) se ainda estiver dentro do vencimento
        if ($venc_timestamp >= $tempo_atual) {
            echo "  <user>\n";
            echo "    <name>" . htmlspecialchars($u['usuario']) . "</name>\n";
            echo "    <password>" . htmlspecialchars($u['senha']) . "</password>\n";
            echo "    <type>client</type>\n";
            echo "  </user>\n";
        }
    }
} catch (Exception $e) { }

// --- BUSCAR TESTES (TEMPORÁRIOS) ---
try {
    // Busca todos os testes não bloqueados
    $sql_teste = "SELECT usuario, senha, data_premio FROM teste WHERE (bloqueado != 'sim' OR bloqueado IS NULL)";
    $stmt_t = $connUser->query($sql_teste);
    $testes = $stmt_t->fetchAll(PDO::FETCH_ASSOC);

    foreach ($testes as $t) {
        // Converte a data do banco para um formato comparável
        $venc = $t['data_premio'];
        $venc_timestamp = is_numeric($venc) ? (int)$venc : strtotime($venc);
        
        // Só exibe se ainda faltar tempo para vencer (ex: 48h)
        if ($venc_timestamp >= $tempo_atual) {
            echo "  <user>\n";
            echo "    <name>" . htmlspecialchars($t['usuario']) . "</name>\n";
            echo "    <password>" . htmlspecialchars($t['senha']) . "</password>\n";
            echo "    <type>test</type>\n";
            echo "  </user>\n";
        }
    }
} catch (Exception $e) { }

echo "</users>";
?>
