<?php
// =========================================================================
// API XTREAM UI / CODES - VERSÃO COMPLETA PARA CONTEÚDO
// =========================================================================

header('Content-Type: application/json; charset=utf-8');
error_reporting(0);
ini_set('display_errors', 0);

// 1. CONEXÃO COM BANCO DE DADOS
// Tenta encontrar o arquivo de conexão automaticamente
if (file_exists('includes/mysql.php')) {
    require_once('includes/mysql.php');
} elseif (file_exists('../includes/mysql.php')) {
    require_once('../includes/mysql.php');
} elseif (file_exists('init.php')) {
    require_once('init.php');
} else {
    echo json_encode(["status" => "error", "message" => "Erro: Conexão DB não encontrada."]);
    exit;
}

global $db; // Garante acesso à variável de conexão do Xtream UI

// 2. HIGIENIZAÇÃO
$get = filter_input_array(INPUT_GET, FILTER_SANITIZE_SPECIAL_CHARS);
$post = filter_input_array(INPUT_POST, FILTER_SANITIZE_SPECIAL_CHARS);
$request = array_merge((array)$get, (array)$post);

$action = isset($request['action']) ? $request['action'] : '';
$category_id = isset($request['category_id']) ? (int)$request['category_id'] : 0;

$response = [];

// 3. LÓGICA DE BUSCA
switch ($action) {

    // ---------------------------------------------------------------------
    // BUSCAR CANAIS (LIVE) DE UMA CATEGORIA
    // ---------------------------------------------------------------------
    case 'get_live_streams':
        if ($category_id > 0) {
            // Busca streams do tipo 1 (Live) na categoria específica
            $query = "SELECT id, stream_display_name, stream_icon, stream_source 
                      FROM streams 
                      WHERE category_id = $category_id AND type = 1 
                      ORDER BY stream_display_name ASC";
        } else {
            // Se não passar categoria, busca todos (Cuidado com performance)
            $query = "SELECT id, stream_display_name, stream_icon 
                      FROM streams WHERE type = 1 LIMIT 100";
        }
        
        $result = $db->query($query);
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                // Formata para o padrão esperado por apps
                $response[] = [
                    "stream_id" => $row['id'],
                    "num" => $row['id'],
                    "name" => $row['stream_display_name'],
                    "stream_type" => "live",
                    "stream_icon" => $row['stream_icon'],
                    "category_id" => $category_id
                ];
            }
        }
        break;

    // ---------------------------------------------------------------------
    // BUSCAR FILMES (VOD) DE UMA CATEGORIA
    // ---------------------------------------------------------------------
    case 'get_vod_streams':
        if ($category_id > 0) {
            // Busca streams do tipo 2 (Movie)
            $query = "SELECT id, stream_display_name, stream_icon, rating, added 
                      FROM streams 
                      WHERE category_id = $category_id AND type = 2 
                      ORDER BY id DESC";
        } else {
            $query = "SELECT id, stream_display_name, stream_icon FROM streams WHERE type = 2 LIMIT 100";
        }

        $result = $db->query($query);
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $response[] = [
                    "stream_id" => $row['id'],
                    "num" => $row['id'],
                    "name" => $row['stream_display_name'],
                    "stream_type" => "movie",
                    "stream_icon" => $row['stream_icon'],
                    "rating" => $row['rating'],
                    "added" => $row['added'],
                    "category_id" => $category_id,
                    "container_extension" => "mp4" // Padrão
                ];
            }
        }
        break;

    // ---------------------------------------------------------------------
    // BUSCAR SÉRIES DE UMA CATEGORIA
    // ---------------------------------------------------------------------
    case 'get_series':
        if ($category_id > 0) {
            $query = "SELECT id, title, cover, plot, releaseDate, rating 
                      FROM series 
                      WHERE category_id = $category_id 
                      ORDER BY title ASC";
        } else {
            $query = "SELECT id, title, cover FROM series LIMIT 50";
        }

        $result = $db->query($query);
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $response[] = [
                    "series_id" => $row['id'],
                    "num" => $row['id'],
                    "name" => $row['title'],
                    "cover" => $row['cover'],
                    "plot" => $row['plot'],
                    "releaseDate" => $row['releaseDate'],
                    "rating" => $row['rating'],
                    "category_id" => $category_id
                ];
            }
        }
        break;
        
    // ---------------------------------------------------------------------
    // TESTE BÁSICO
    // ---------------------------------------------------------------------
    case 'ping':
        $response = ["status" => "success", "message" => "API Online"];
        break;

    default:
        // Se a ação não for reconhecida, tenta retornar vazio ou erro
        // Alguns apps preferem array vazio [] do que objeto de erro
        $response = []; 
        break;
}

echo json_encode($response);
exit;
?>