<?php
// api_import_v2.php - VERSÃO FINAL: LEITURA INTELIGENTE
ini_set('display_errors', 0);
error_reporting(0);
require 'config.php';

// Aumenta memória para listas gigantes (400k+ canais)
@ini_set('memory_limit', '4096M'); 
@ini_set('max_execution_time', 0);
@ini_set('pcre.backtrack_limit', '10000000');

header('Content-Type: application/json; charset=utf-8');

try {
    if (!isset($pdo)) throw new Exception("Erro de conexão PDO.");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $action = $_POST['action'] ?? '';
    $temp_dir = sys_get_temp_dir();
    if (!is_writable($temp_dir)) $temp_dir = __DIR__; 

    // --- FUNÇÃO PARA LIMPAR NOMES (CRÍTICA PARA FUNCIONAR) ---
    if (!function_exists('clean_cat_name')) {
        function clean_cat_name($str) {
            // Remove aspas, espaços extras e coloca em MAIÚSCULO
            $str = str_replace(['"', "'"], '', $str);
            return mb_strtoupper(trim($str), 'UTF-8');
        }
    }

    // =================================================================
    // PREVIEW
    // =================================================================
    if ($action === 'preview') {
        $temp_file_name = "lista_" . time() . ".m3u";
        $temp_path = $temp_dir . DIRECTORY_SEPARATOR . $temp_file_name;
        $m3u_content = "";

        if (isset($_POST['type']) && $_POST['type'] === 'url') {
            $url = trim($_POST['m3u_url']);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
            $m3u_content = curl_exec($ch);
            curl_close($ch);
            if (!$m3u_content || strlen($m3u_content) < 50) {
                echo json_encode(['status' => 'blocked', 'message' => 'IP Bloqueado']); exit;
            }
            file_put_contents($temp_path, $m3u_content);
        } elseif (isset($_POST['type']) && $_POST['type'] === 'file') {
            move_uploaded_file($_FILES['m3u_file']['tmp_name'], $temp_path);
            $m3u_content = file_get_contents($temp_path);
        }

        // PREVIEW SIMPLES (Busca group-title onde quer que esteja)
        preg_match_all('/group-title=["\']?([^"\']+)["\']?/', $m3u_content, $matches);
        
        if (empty($matches[1])) {
             if(strpos($m3u_content, '#EXTINF') !== false) {
                 $lista_final = [['nome' => 'GERAL', 'qtd' => substr_count($m3u_content, '#EXTINF')]];
                 echo json_encode(['status' => 'success', 'temp_file' => $temp_file_name, 'categories' => $lista_final]); exit;
            }
            throw new Exception("Arquivo inválido.");
        }

        $contagem = array_count_values($matches[1]);
        $lista_final = [];
        foreach ($contagem as $nome => $qtd) {
            $lista_final[] = ['nome' => trim($nome), 'qtd' => $qtd];
        }
        usort($lista_final, function($a, $b) { return strcasecmp($a['nome'], $b['nome']); });

        echo json_encode(['status' => 'success', 'temp_file' => $temp_file_name, 'categories' => $lista_final]);
        exit;
    }

    // =================================================================
    // IMPORTAR - LÓGICA CORRIGIDA
    // =================================================================
    if ($action === 'import') {
        $temp_file = $_POST['temp_file'] ?? '';
        $cats_selected_raw = isset($_POST['cats']) ? json_decode($_POST['cats'], true) : [];
        $file_path = $temp_dir . DIRECTORY_SEPARATOR . $temp_file;

        if (!file_exists($file_path)) throw new Exception("Arquivo sumiu. Tente de novo.");
        
        // LER O ARQUIVO LINHA A LINHA (Mais seguro para memória)
        $lines = file($file_path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        
        // Mapa de Selecionados
        $selected_map = [];
        foreach($cats_selected_raw as $cat) {
            $selected_map[clean_cat_name($cat)] = true;
        }
        
        // Cache Banco de Dados
        $cat_db_map = [];
        $stmt = $pdo->query("SELECT id, category_name FROM streams_categories WHERE category_type = 'live'");
        while ($r = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $cat_db_map[clean_cat_name($r['category_name'])] = $r['id'];
        }

        $stmt_new_cat = $pdo->prepare("INSERT INTO streams_categories (category_type, category_name, cat_order) VALUES ('live', ?, 0)");
        
        $sql_insert = "INSERT INTO streams 
        (
            type, category_id, stream_display_name, stream_source, stream_icon, 
            direct_source, target_container, added, stream_all, 
            read_native, enable_transcode, transcode_profile_id, 
            gen_timestamps, rtmp_output, allow_record, notes, custom_sid, 
            transcode_attributes, movie_properties, movie_subtitles, custom_ffmpeg, custom_map,
            external_push, auto_restart, epg_api, epg_id, channel_id, epg_lang, `order`,
            series_no, tv_archive_duration, tv_archive_server_id, tv_archive_pid,
            vframes_server_id, vframes_pid, movie_symlink, probesize_ondemand, delay_minutes,
            remove_subtitles
        ) 
        VALUES 
        (
            1, ?, ?, ?, ?, 
            1, '[\"ts\"]', UNIX_TIMESTAMP(), 0, 
            0, 0, 0, 
            0, 0, 0, '', '', 
            '[]', '[]', '[]', '[]', '[]',
            '[]', '[]', 0, 0, '', '', 0,
            0, 0, 0, 0,
            0, 0, 0, 0, 0,
            0
        )";
        $stmt_add_stream = $pdo->prepare($sql_insert);

        $pdo->beginTransaction();
        
        $count = 0;
        $ignored = 0;
        $debug_last_cat = "";
        
        // Loop Inteligente: Processa em pares (Linha #EXTINF + Linha URL)
        $current_meta = "";
        
        foreach ($lines as $line) {
            $line = trim($line);
            
            // Se for linha de info
            if (strpos($line, '#EXTINF:') === 0) {
                $current_meta = $line;
                continue;
            }
            
            // Se for URL (e tivermos um meta anterior)
            if ($current_meta && (strpos($line, 'http') === 0 || strpos($line, '/') === 0)) {
                
                // 1. Extrair Nome da Categoria (Independente da posição)
                $group = "GERAL";
                if (preg_match('/group-title=["\']?([^"\']+)["\']?/', $current_meta, $m)) {
                    $group = $m[1];
                }
                
                // 2. Extrair Logo
                $logo = "";
                if (preg_match('/tvg-logo=["\']?([^"\']+)["\']?/', $current_meta, $m)) {
                    $logo = $m[1];
                }
                
                // 3. Extrair Nome do Canal (Tudo após a última vírgula)
                $name_parts = explode(',', $current_meta);
                $name = trim(end($name_parts));

                $link = $line;
                $current_meta = ""; // Limpa para o próximo

                // Verifica Seleção
                $group_normalized = clean_cat_name($group);
                $debug_last_cat = $group_normalized;

                if (!isset($selected_map[$group_normalized])) {
                    $ignored++;
                    continue;
                }

                // Salva ou Recupera Categoria
                if (isset($cat_db_map[$group_normalized])) {
                    $cat_id = $cat_db_map[$group_normalized];
                } else {
                    try {
                        $stmt_new_cat->execute([$group]);
                        $cat_id = $pdo->lastInsertId();
                        $cat_db_map[$group_normalized] = $cat_id;
                    } catch (Exception $e) { continue; }
                }

                // Salva Canal
                try {
                    $stmt_add_stream->execute([
                        json_encode([(string)$cat_id]), 
                        $name,
                        json_encode([$link]), 
                        $logo
                    ]);
                    $count++;
                } catch (Exception $e) { continue; }
            }
        }

        if ($count > 0) {
            $pdo->commit();
            @unlink($file_path);
            echo json_encode(['status' => 'success', 'message' => "Sucesso! $count canais importados."]);
        } else {
            $pdo->rollBack();
            $msg = "Falha: 0 salvos. Ignorados: $ignored. ";
            $msg .= "Última categoria lida: '$debug_last_cat'. ";
            $msg .= "Verifique se a lista tem o formato padrão #EXTINF.";
            throw new Exception($msg);
        }
        exit;
    }

} catch (Exception $e) {
    if(isset($pdo) && $pdo->inTransaction()) $pdo->rollBack();
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
