<?php
require 'config.php';
require 'header.php';

// Contagem Inicial
$total_filmes_ruins = $pdo->query("SELECT count(*) FROM streams WHERE type = 2 AND (stream_icon IS NULL OR stream_icon = '' OR stream_icon LIKE '%via.placeholder%')")->fetchColumn();
$total_series_ruins = $pdo->query("SELECT count(*) FROM streams_series WHERE (cover IS NULL OR cover = '' OR cover LIKE '%via.placeholder%') OR (plot IS NULL OR plot = '')")->fetchColumn();
?>

<div class="container mt-5">
    <div class="card shadow-lg border-0">
        <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
            <h4 class="mb-0"><i class="fas fa-magic me-2" style="color: #d63384;"></i>Atualizador TMDB Pro</h4>
            <div>
                <span class="badge bg-success me-2">API Ativa</span>
                <span class="badge bg-info text-dark">Modo Turbo (50/lote)</span>
            </div>
        </div>
        <div class="card-body bg-light">
            
            <div class="row text-center mb-4">
                <div class="col-md-6">
                    <div class="card border-0 shadow-sm mb-3">
                        <div class="card-body">
                            <h2 class="text-danger fw-bold display-4" id="count-movies"><?= $total_filmes_ruins ?></h2>
                            <p class="text-muted fw-bold text-uppercase small">Filmes Pendentes</p>
                            <button class="btn btn-outline-danger w-100 fw-bold" onclick="iniciarAtualizacao('movies')" <?= $total_filmes_ruins == 0 ? 'disabled' : '' ?>>
                                <i class="fas fa-film me-2"></i> ATUALIZAR FILMES
                            </button>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card border-0 shadow-sm mb-3">
                        <div class="card-body">
                            <h2 class="text-purple fw-bold display-4" style="color: #6f42c1;" id="count-series"><?= $total_series_ruins ?></h2>
                            <p class="text-muted fw-bold text-uppercase small">Séries Pendentes</p>
                            <button class="btn btn-outline-purple w-100 fw-bold" style="color: #6f42c1; border-color: #6f42c1;" onclick="iniciarAtualizacao('series')" <?= $total_series_ruins == 0 ? 'disabled' : '' ?>>
                                <i class="fas fa-tv me-2"></i> ATUALIZAR SÉRIES
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div id="terminal-area" style="display:none;">
                
                <div class="d-flex justify-content-between align-items-end mb-2">
                    <h6 class="fw-bold mb-0"><i class="fas fa-spinner fa-spin me-2"></i>Processando...</h6>
                    <div class="text-end">
                        <span class="d-block text-muted small fw-bold">TEMPO RESTANTE ESTIMADO:</span>
                        <span class="badge bg-primary fs-6" id="tempoRestante">Calculando...</span>
                    </div>
                </div>
                
                <div class="progress mb-2" style="height: 25px;">
                    <div id="progressBar" class="progress-bar progress-bar-striped progress-bar-animated bg-success" style="width: 0%">0%</div>
                </div>

                <div class="bg-black text-light p-3 rounded font-monospace border border-secondary" id="log-window" style="height: 350px; overflow-y: auto; font-size: 0.85rem; line-height: 1.4;">
                    <div class="text-muted">> Aguardando comando...</div>
                </div>
                
            </div>

        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    var totalInicial = 0;
    var processados = 0;
    var tipoAtual = '';
    var logInterval;
    var startTime;

    function iniciarAtualizacao(tipo) {
        tipoAtual = tipo;
        var valorTexto = (tipo == 'movies') ? $('#count-movies').text() : $('#count-series').text();
        totalInicial = parseInt(valorTexto);
        processados = 0;
        startTime = new Date().getTime(); // Marca o tempo de início

        if(totalInicial == 0) { alert("Nada para atualizar!"); return; }

        $('#terminal-area').fadeIn();
        $('button').prop('disabled', true);
        $('#log-window').html('<div class="text-info">> Iniciando motor TMDB...</div>');
        
        processarLote(true);
        logInterval = setInterval(lerLog, 1000);
    }

    function lerLog() {
        $.get('ler_log_tmdb.php', function(data) {
            if(data) {
                $('#log-window').html(data);
                var objDiv = document.getElementById("log-window");
                objDiv.scrollTop = objDiv.scrollHeight;
            }
        });
    }

    // Função para formatar segundos em MM:SS
    function formatTime(seconds) {
        if(seconds < 0) return "00:00";
        var m = Math.floor(seconds / 60);
        var s = Math.floor(seconds % 60);
        return (m < 10 ? "0" + m : m) + ":" + (s < 10 ? "0" + s : s);
    }

    function processarLote(primeiraVez = false) {
        $.ajax({
            url: 'processar_tmdb.php',
            type: 'POST',
            data: { 
                tipo: tipoAtual,
                limpar_log: primeiraVez ? 1 : 0
            },
            dataType: 'json',
            success: function(res) {
                if(res.status == 'ok') {
                    
                    processados += res.qtd_lote; 
                    
                    // --- CÁLCULO DE PROGRESSO ---
                    var porcentagem = Math.round((processados / totalInicial) * 100);
                    if(porcentagem > 100) porcentagem = 100;
                    $('#progressBar').css('width', porcentagem + '%').text(porcentagem + '%');

                    // --- CÁLCULO DE TEMPO ESTIMADO ---
                    var currentTime = new Date().getTime();
                    var timeElapsed = (currentTime - startTime) / 1000; // Segundos passados
                    
                    // Velocidade: itens por segundo
                    var speed = processados / timeElapsed;
                    
                    var itensRestantes = totalInicial - processados;
                    if(itensRestantes < 0) itensRestantes = 0;

                    if(speed > 0) {
                        var segundosRestantes = itensRestantes / speed;
                        $('#tempoRestante').text(formatTime(segundosRestantes) + " min");
                    }

                    // --- PRÓXIMO LOTE ---
                    if(res.restantes === true) {
                        processarLote(false);
                    } else {
                        clearInterval(logInterval);
                        setTimeout(lerLog, 500);
                        $('#progressBar').removeClass('progress-bar-animated').addClass('bg-primary');
                        $('#tempoRestante').text("CONCLUÍDO").removeClass('bg-primary').addClass('bg-success');
                        alert("Atualização finalizada!");
                        location.reload();
                    }
                } else {
                    clearInterval(logInterval);
                    alert("Erro interno.");
                }
            },
            error: function() {
                setTimeout(function(){ processarLote(false); }, 3000);
            }
        });
    }
</script>
</body>
</html>