<?php
// bouquets.php - Gerenciamento de Pacotes (Versão Corrigida)

// O header já carrega a conexão com o banco ($pdo) e as configurações.
// NÃO carregue o config.php aqui de novo para evitar o erro "Cannot redeclare".
require 'header.php'; 

// --- LÓGICA DE EXCLUSÃO ---
if (isset($_GET['deletar'])) {
    $id = (int)$_GET['deletar'];
    
    // Proteção: Não deixe deletar o pacote 1 se ele for o principal do sistema
    if($id > 1) { 
        $pdo->query("DELETE FROM bouquets WHERE id = $id");
        echo "<script>window.location='bouquets.php';</script>";
    } else {
        echo "<script>alert('O Pacote principal (ID 1) é padrão e não pode ser excluído.'); window.location='bouquets.php';</script>";
    }
}

// --- BUSCAR PACOTES ---
$pacotes = [];
try {
    $sql = "SELECT * FROM bouquets ORDER BY id ASC";
    $stmt = $pdo->query($sql);
    if($stmt) {
        $pacotes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
} catch (Exception $e) {
    echo "<div class='alert alert-danger m-3'>Erro ao buscar tabela bouquets: " . $e->getMessage() . "</div>";
}
?>

<div class="container-fluid mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="fw-bold text-dark mb-0">Gerenciar Pacotes</h3>
            <p class="text-muted">Controle quais categorias seus clientes podem assistir</p>
        </div>
        <a href="editar_bouquet.php" class="btn btn-primary shadow-sm">
            <i class="fas fa-plus me-2"></i>Novo Pacote
        </a>
    </div>

    <div class="card border-0 shadow-sm" style="border-radius: 12px;">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th class="ps-4">ID</th>
                            <th>Nome do Pacote</th>
                            <th class="text-center">Canais (Live)</th>
                            <th class="text-center">Filmes</th>
                            <th class="text-center">Séries</th>
                            <th class="text-end pe-4">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($pacotes as $p): 
                            // Contagem visual rápida dos itens no JSON
                            $canais = json_decode($p['bouquet_channels'] ?? '[]', true);
                            $filmes = json_decode($p['bouquet_movies'] ?? '[]', true);
                            $series = json_decode($p['bouquet_series'] ?? '[]', true);
                            
                            // Garante que é array antes de contar
                            $qtd_canais = is_array($canais) ? count($canais) : 0;
                            $qtd_filmes = is_array($filmes) ? count($filmes) : 0;
                            $qtd_series = is_array($series) ? count($series) : 0;
                        ?>
                        <tr>
                            <td class="ps-4 fw-bold">#<?= $p['id'] ?></td>
                            <td class="fw-bold text-primary"><?= htmlspecialchars($p['bouquet_name']) ?></td>
                            <td class="text-center"><span class="badge bg-info text-dark"><?= $qtd_canais ?></span></td>
                            <td class="text-center"><span class="badge bg-warning text-dark"><?= $qtd_filmes ?></span></td>
                            <td class="text-center"><span class="badge" style="background-color: #6f42c1; color: white;"><?= $qtd_series ?></span></td>
                            <td class="text-end pe-4">
                                <a href="editar_bouquet.php?id=<?= $p['id'] ?>" class="btn btn-sm btn-outline-primary me-1">
                                    <i class="fas fa-edit"></i> Editar
                                </a>
                                <?php if($p['id'] != 1): // Evita deletar o pacote padrão ?>
                                <a href="?deletar=<?= $p['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Tem certeza? Isso removerá o acesso dos clientes que usam este pacote.');">
                                    <i class="fas fa-trash"></i>
                                </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>

                        <?php if(count($pacotes) == 0): ?>
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted">
                                    <i class="fas fa-box-open fa-3x mb-3"></i><br>Nenhum pacote encontrado.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="content"> ```
