<?php 
require 'config.php'; 
require 'header.php'; 

// --- DETECTAR URL ---
$protocolo = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https://" : "http://";
$servidor_dns = $protocolo . $_SERVER['HTTP_HOST']; 

// --- FUNÇÃO AUXILIAR: PEGAR CATEGORIAS (LIVE) ---
function getLiveCategories($pdo) {
    return $pdo->query("SELECT id, category_name FROM streams_categories WHERE category_type = 'live' ORDER BY category_name ASC")->fetchAll(PDO::FETCH_ASSOC);
}
$categorias = getLiveCategories($pdo);

// --- 1. ADICIONAR CANAL ---
if(isset($_POST['add_channel'])) {
    $cat_id = json_encode([(int)$_POST['category_id']]); 
    $nome   = $_POST['nome'];
    $link   = $_POST['link'];
    $source = json_encode([$link]);
    $icon   = $_POST['logo'] ?? '';
    
    // Extensão padrão para live geralmente é .ts ou .m3u8, mas o sistema aceita vazio
    $ext    = 'ts'; 

    $sql = "INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, direct_source, target_container, added) 
            VALUES (1, ?, ?, ?, ?, 1, ?, UNIX_TIMESTAMP())";
    
    $pdo->prepare($sql)->execute([$cat_id, $nome, $source, $icon, $ext]);
    echo "<script>window.location='canais.php';</script>";
}

// --- 2. DELETAR ---
if(isset($_GET['del'])) {
    $id = (int)$_GET['del'];
    $pdo->query("DELETE FROM streams WHERE id = $id AND type = 1");
    echo "<script>window.location='canais.php';</script>";
}

// --- PAGINAÇÃO E BUSCA ---
$busca = $_GET['busca'] ?? '';
$filtro_cat = $_GET['categoria'] ?? ''; // <--- NOVO: Captura Categoria
$pagina = $_GET['pagina'] ?? 1;

// --- ALTERAÇÃO: Limite Dinâmico ---
$limite = isset($_GET['limite']) ? (int)$_GET['limite'] : 50; 
if($limite < 1) $limite = 50;
// ----------------------------------

$inicio = ($pagina - 1) * $limite;

$sql_base = "FROM streams WHERE type = 1";
if($busca) $sql_base .= " AND stream_display_name LIKE :busca";
if($filtro_cat) $sql_base .= " AND category_id LIKE :cat_filter"; // <--- NOVO: Filtro SQL

$stmt_count = $pdo->prepare("SELECT count(*) $sql_base");
if($busca) $stmt_count->bindValue(':busca', "%$busca%");
if($filtro_cat) $stmt_count->bindValue(':cat_filter', "%$filtro_cat%"); // <--- NOVO: Bind
$stmt_count->execute();
$total_registros = $stmt_count->fetchColumn();
$total_paginas = ceil($total_registros / $limite);

$sql = "SELECT id, stream_display_name, stream_source, stream_icon, added, category_id $sql_base ORDER BY id DESC LIMIT $inicio, $limite";
$stmt = $pdo->prepare($sql);
if($busca) $stmt->bindValue(':busca', "%$busca%");
if($filtro_cat) $stmt->bindValue(':cat_filter', "%$filtro_cat%"); // <--- NOVO: Bind
$stmt->execute();
$canais = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
    .k-card { background: #fff; border-radius: 12px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; }
    .table thead th { background-color: #f8f9fa; color: #6c757d; font-weight: 700; text-transform: uppercase; font-size: 0.75rem; letter-spacing: 0.5px; border-bottom: 2px solid #e9ecef; padding: 15px; }
    .table tbody td { padding: 12px 15px; vertical-align: middle; color: #495057; font-size: 0.95rem; border-bottom: 1px solid #f1f1f1; }
    
    /* Logo do Canal */
    .channel-logo { width: 40px; height: 40px; object-fit: contain; border-radius: 6px; background: #f8f9fa; border: 1px solid #dee2e6; padding: 2px; }
    
    .btn-icon { width: 34px; height: 34px; border-radius: 8px; display: inline-flex; align-items: center; justify-content: center; border: none; transition: all 0.2s; margin-left: 4px; }
    .btn-icon:hover { transform: translateY(-2px); }
    .btn-play { background-color: #e7f1ff; color: #0d6efd; }
    .btn-edit { background-color: #fff3cd; color: #ffc107; }
    .btn-del  { background-color: #f8d7da; color: #dc3545; }
    .search-box { border-radius: 30px; padding-left: 20px; border: 1px solid #dee2e6; box-shadow: 0 2px 5px rgba(0,0,0,0.03); }
</style>

<div class="container-fluid">

    <div class="row align-items-center mb-4 mt-2">
        <div class="col-md-6">
            <h4 class="fw-bold mb-0 text-dark"><i class="fas fa-broadcast-tower me-2 text-primary"></i>Canais (Live)</h4>
            <small class="text-muted">Gerencie sua lista de canais ao vivo</small>
        </div>
        <div class="col-md-6 text-end">
            <button class="btn btn-primary px-4 py-2 rounded-pill shadow-sm fw-bold" data-bs-toggle="modal" data-bs-target="#modalAdd">
                <i class="fas fa-plus me-2"></i> Adicionar Canal
            </button>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-8"> <form class="d-flex">
                <select name="limite" class="form-select bg-light me-2" style="max-width: 80px;" onchange="this.form.submit()">
                    <?php 
                    $opcoes = [10, 20, 50, 100, 200, 500, 1000];
                    foreach($opcoes as $op) {
                        $selected = ($limite == $op) ? 'selected' : '';
                        echo "<option value='$op' $selected>$op</option>";
                    }
                    ?>
                </select>

                <select name="categoria" class="form-select bg-white me-2" style="max-width: 200px;" onchange="this.form.submit()">
                    <option value="">Todas Categorias</option>
                    <?php foreach($categorias as $cat): 
                        $selCat = ($filtro_cat == $cat['id']) ? 'selected' : '';
                    ?>
                        <option value="<?= $cat['id'] ?>" <?= $selCat ?>><?= $cat['category_name'] ?></option>
                    <?php endforeach; ?>
                </select>

                <input type="text" name="busca" class="form-control search-box" placeholder="Pesquisar canal..." value="<?= $busca ?>">
                <button class="btn btn-dark rounded-pill ms-2 px-3"><i class="fas fa-search"></i></button>
            </form>
        </div>
    </div>

    <div class="k-card">
        <div class="table-responsive">
            <table class="table mb-0 table-hover">
                <thead>
                    <tr>
                        <th width="5%">ID</th>
                        <th width="10%">Logo</th>
                        <th width="35%">Nome do Canal</th>
                        <th width="20%">Categoria ID</th>
                        <th width="30%" class="text-end">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($canais as $c): 
                        $source = json_decode($c['stream_source']);
                        $link = is_array($source) ? $source[0] : $c['stream_source'];
                        $cat_clean = trim(str_replace(['"', '[', ']'], '', $c['category_id']));
                        $logo = $c['stream_icon'] ? $c['stream_icon'] : 'https://via.placeholder.com/40x40?text=TV';
                    ?>
                    <tr>
                        <td class="fw-bold text-muted">#<?= $c['id'] ?></td>
                        <td>
                            <img src="<?= $logo ?>" class="channel-logo" onerror="this.src='https://via.placeholder.com/40x40?text=TV'">
                        </td>
                        <td>
                            <span class="fw-bold text-dark d-block"><?= $c['stream_display_name'] ?></span>
                            <small class="text-muted text-truncate d-block" style="max-width: 250px; font-size: 0.75rem;">
                                <i class="fas fa-link me-1"></i> <?= $link ?>
                            </small>
                        </td>
                        <td>
                            <span class="badge bg-light text-dark border"><?= $cat_clean ?></span>
                        </td>
                        <td class="text-end">
                            <button class="btn-icon btn-play" onclick="playStream('<?= $link ?>', '<?= addslashes($c['stream_display_name']) ?>')" title="Assistir">
                                <i class="fas fa-play"></i>
                            </button>
                            
                            <a href="editar.php?tipo=stream&id=<?= $c['id'] ?>" class="btn-icon btn-edit text-decoration-none" title="Editar">
                                <i class="fas fa-pen"></i>
                            </a>
                            
                            <a href="?del=<?= $c['id'] ?>" class="btn-icon btn-del text-decoration-none" onclick="return confirm('Excluir este canal?')" title="Excluir">
                                <i class="fas fa-trash"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <?php if($total_paginas > 1): ?>
        <div class="d-flex justify-content-center py-3 border-top">
            <nav>
                <ul class="pagination pagination-sm mb-0">
                    <?php if($pagina > 1): ?>
                        <li class="page-item"><a class="page-link border-0 text-dark" href="?pagina=<?= $pagina-1 ?>&busca=<?= $busca ?>&limite=<?= $limite ?>&categoria=<?= $filtro_cat ?>"><i class="fas fa-chevron-left"></i></a></li>
                    <?php endif; ?>
                    <li class="page-item disabled"><span class="page-link border-0 fw-bold bg-light"><?= $pagina ?> / <?= $total_paginas ?></span></li>
                    <?php if($pagina < $total_paginas): ?>
                        <li class="page-item"><a class="page-link border-0 text-dark" href="?pagina=<?= $pagina+1 ?>&busca=<?= $busca ?>&limite=<?= $limite ?>&categoria=<?= $filtro_cat ?>"><i class="fas fa-chevron-right"></i></a></li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
        <?php endif; ?>
    </div>
</div>

<div class="modal fade" id="modalAdd">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-primary text-white border-0">
                <h5 class="modal-title fw-bold"><i class="fas fa-tv me-2"></i>Novo Canal</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="add_channel" value="1">
                    
                    <div class="mb-3">
                        <label class="form-label small fw-bold text-muted">NOME DO CANAL</label>
                        <input type="text" name="nome" class="form-control" placeholder="Ex: Globo SP" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label small fw-bold text-muted">LINK (M3U8 / TS)</label>
                        <input type="text" name="link" class="form-control" placeholder="http://servidor.com/live/globo.m3u8" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label small fw-bold text-muted">URL DO LOGO (Opcional)</label>
                        <input type="text" name="logo" class="form-control" placeholder="http://site.com/logo.png">
                    </div>

                    <div class="mb-3">
                        <label class="form-label small fw-bold text-muted">CATEGORIA</label>
                        <select name="category_id" class="form-select" required>
                            <option value="">Selecione...</option>
                            <?php foreach($categorias as $cat): ?>
                                <option value="<?= $cat['id'] ?>"><?= $cat['category_name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                </div>
                <div class="modal-footer border-0 bg-light">
                    <button type="button" class="btn btn-link text-muted text-decoration-none" data-bs-dismiss="modal">Cancelar</button>
                    <button class="btn btn-primary px-4 fw-bold shadow-sm">Salvar Canal</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body></html>
