<?php 
require 'config.php'; 
require 'header.php'; 

// --- CONFIGURAÇÕES DE DNS ---
$protocolo = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https://" : "http://";
$dns_painel = $protocolo . $_SERVER['HTTP_HOST']; 
$porta_streaming = ":8080"; 
$dns_streaming = $dns_painel . $porta_streaming;

$my_id = $_SESSION['user_id'];
$is_admin = ($_SESSION['group_id'] == 1);

// --- BUSCAR BOUQUETS (PACOTES) PARA O SELECT ---
// Adicionado para preencher o dropdown
$lista_bouquets = $pdo->query("SELECT id, bouquet_name FROM bouquets ORDER BY bouquet_name ASC")->fetchAll(PDO::FETCH_ASSOC);

// --- FUNÇÃO CRÉDITO ---
function processarCredito($pdo, $user_id, $qtd=1) {
    if($_SESSION['group_id'] == 1) return true; 
    $stmt = $pdo->prepare("SELECT credits FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $saldo = (float)$stmt->fetchColumn();
    if($saldo < $qtd) return false;
    $pdo->prepare("UPDATE users SET credits = credits - ? WHERE id = ?")->execute([$qtd, $user_id]);
    return true;
}

// --- LÓGICA DE FILTROS (GET) ---
$filtro_status = $_GET['status'] ?? 'todos'; 
$filtro_revenda = $_GET['revenda'] ?? '';   
$busca_texto = $_GET['busca'] ?? '';        

// --- 1. ADICIONAR CLIENTE (COM BOUQUET) ---
if(isset($_POST['add_user'])) {
    if(!processarCredito($pdo, $my_id, 1)) {
        echo "<script>alert('ERRO: Saldo insuficiente!'); window.location='clientes.php';</script>"; exit;
    }
    $exp = strtotime($_POST['vencimento'] . ' 23:59:59');
    
    // Tratamento do Bouquet
    $pacote_id = (int)$_POST['pacote_selecionado'];
    $bouquet_formatado = "[" . $pacote_id . "]";

    $check = $pdo->prepare("SELECT id FROM `lines` WHERE username = ?");
    $check->execute([$_POST['user']]);
    
    if($check->rowCount() > 0){
        echo "<script>alert('Usuário já existe!');</script>";
    } else {
        // SQL ATUALIZADO COM BOUQUET E PACKAGE_ID
        $sql = "INSERT INTO `lines` (member_id, username, password, exp_date, max_connections, created_at, admin_enabled, enabled, bouquet, package_id) 
                VALUES (?, ?, ?, ?, ?, UNIX_TIMESTAMP(), 1, 1, ?, ?)";
        $pdo->prepare($sql)->execute([$my_id, $_POST['user'], $_POST['pass'], $exp, $_POST['conexoes'], $bouquet_formatado, $pacote_id]);
        
        $novo_id = $pdo->lastInsertId();
        echo "<script>window.location='clientes.php?created=$novo_id';</script>"; exit;
    }
}

// --- 2. RENOVAR ---
if(isset($_POST['quick_renew'])) {
    $id = (int)$_POST['id_user'];
    $meses = (int)$_POST['meses'] < 1 ? 1 : (int)$_POST['meses'];
    if(!processarCredito($pdo, $my_id, $meses)) {
        echo "<script>alert('Saldo insuficiente!'); window.location='clientes.php';</script>"; exit;
    }
    $stmt = $pdo->query("SELECT exp_date FROM `lines` WHERE id = $id");
    $atual = $stmt->fetchColumn();
    $base = ($atual > time()) ? $atual : time();
    $novo_vencimento = $base + ($meses * 30 * 86400);
    $pdo->prepare("UPDATE `lines` SET exp_date = ?, enabled = 1 WHERE id = ?")->execute([$novo_vencimento, $id]);
    echo "<script>window.location='clientes.php?created=$id';</script>"; exit;
}

// --- 3. EDITAR (COM BOUQUET) ---
if(isset($_POST['edit_user'])) {
    $id = (int)$_POST['id_user'];
    $nova_data = strtotime($_POST['vencimento'] . ' 23:59:59');
    $status_edit = (int)$_POST['status_cliente']; 
    
    // Tratamento do Bouquet na Edição
    $pacote_id = (int)$_POST['pacote_selecionado'];
    $bouquet_formatado = "[" . $pacote_id . "]";
    
    $atual_date = $pdo->query("SELECT exp_date FROM `lines` WHERE id = $id")->fetchColumn();
    if($nova_data > $atual_date && !processarCredito($pdo, $my_id, 1)) {
        echo "<script>alert('Saldo insuficiente!'); window.location='clientes.php';</script>"; exit;
    }
    
    // SQL ATUALIZADO COM BOUQUET E PACKAGE_ID
    $pdo->prepare("UPDATE `lines` SET password=?, exp_date=?, max_connections=?, enabled=?, bouquet=?, package_id=? WHERE id=?")
        ->execute([$_POST['pass'], $nova_data, (int)$_POST['conexoes'], $status_edit, $bouquet_formatado, $pacote_id, $id]);
    
    echo "<script>window.location='clientes.php';</script>";
}

// --- 4. DELETAR ---
if(isset($_GET['del'])) {
    $id = (int)$_GET['del'];
    $sql = "DELETE FROM `lines` WHERE id = $id";
    if(!$is_admin) $sql .= " AND member_id = $my_id";
    $pdo->query($sql);
    echo "<script>window.location='clientes.php';</script>";
}

// --- CONSULTA COM FILTROS (Trazendo nome do pacote) ---
$sql_lista = "SELECT L.*, U.username as dono_nome, B.bouquet_name 
              FROM `lines` L 
              LEFT JOIN users U ON L.member_id = U.id 
              LEFT JOIN bouquets B ON L.package_id = B.id 
              WHERE 1=1 ";

if(!$is_admin) { $sql_lista .= " AND L.member_id = $my_id "; }
if($is_admin && !empty($filtro_revenda)) { $sql_lista .= " AND L.member_id = " . (int)$filtro_revenda; }

$agora = time();
if($filtro_status == 'ativo') { $sql_lista .= " AND L.exp_date > $agora AND L.enabled = 1 "; } 
elseif($filtro_status == 'vencido') { $sql_lista .= " AND L.exp_date <= $agora "; } 
elseif($filtro_status == 'bloqueado') { $sql_lista .= " AND L.enabled = 0 "; }

if(!empty($busca_texto)) { $sql_lista .= " AND L.username LIKE '%$busca_texto%' "; }

$sql_lista .= " ORDER BY L.id DESC LIMIT 200";
$users = $pdo->query($sql_lista)->fetchAll(PDO::FETCH_ASSOC);

$lista_revendedores = [];
if($is_admin) {
    $lista_revendedores = $pdo->query("SELECT id, username FROM users WHERE member_group_id != 1")->fetchAll(PDO::FETCH_ASSOC);
}

// --- MODAL AUTOMÁTICO ---
$show_created_modal = false;
$id_created = 0;
if(isset($_GET['created'])) {
    $show_created_modal = true;
    $id_created = (int)$_GET['created'];
}
?>

<div class="container-fluid">
    
    <div class="d-md-flex justify-content-between align-items-center mb-4 mt-2">
        <div>
            <h4 class="fw-bold mb-0 text-dark">Gerenciar Clientes</h4>
            <small class="text-muted">Total: <b><?= count($users) ?></b></small>
        </div>
        <div class="d-flex gap-2 mt-3 mt-md-0">
            <button class="btn btn-primary px-4 py-2 rounded-pill shadow-sm fw-bold" data-bs-toggle="modal" data-bs-target="#modalAdd">
                <i class="fas fa-plus me-2"></i> Novo Cliente
            </button>
        </div>
    </div>

    <div class="card border-0 shadow-sm mb-4" style="border-radius: 12px; background: #f8f9fa;">
        <div class="card-body py-3">
            <form method="GET" class="row g-2 align-items-center">
                <div class="col-md-3">
                    <div class="input-group">
                        <span class="input-group-text bg-white border-end-0"><i class="fas fa-search text-muted"></i></span>
                        <input type="text" name="busca" class="form-control border-start-0 ps-0" placeholder="Buscar usuário..." value="<?= $busca_texto ?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select" onchange="this.form.submit()">
                        <option value="todos" <?= $filtro_status == 'todos' ? 'selected' : '' ?>>Todos os Status</option>
                        <option value="ativo" <?= $filtro_status == 'ativo' ? 'selected' : '' ?>>✅ Ativos</option>
                        <option value="vencido" <?= $filtro_status == 'vencido' ? 'selected' : '' ?>>⏰ Vencidos</option>
                        <option value="bloqueado" <?= $filtro_status == 'bloqueado' ? 'selected' : '' ?>>🚫 Bloqueados</option>
                    </select>
                </div>
                <?php if($is_admin): ?>
                <div class="col-md-3">
                    <select name="revenda" class="form-select" onchange="this.form.submit()">
                        <option value="">Todos os Revendedores</option>
                        <?php foreach($lista_revendedores as $r): ?>
                            <option value="<?= $r['id'] ?>" <?= $filtro_revenda == $r['id'] ? 'selected' : '' ?>>
                                👤 <?= $r['username'] ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <?php endif; ?>
                <div class="col-md-auto">
                    <a href="clientes.php" class="btn btn-outline-secondary w-100" title="Limpar"><i class="fas fa-eraser"></i></a>
                </div>
            </form>
        </div>
    </div>

    <div class="k-card" style="background: #fff; border-radius: 12px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); overflow: hidden;">
        <div class="table-responsive">
            <table class="table mb-0 table-hover align-middle">
                <thead class="bg-light">
                    <tr>
                        <th width="10%">Status</th>
                        <th width="20%">Usuário</th>
                        <th width="15%">Senha</th>
                        <th width="15%">Vencimento</th> <th width="10%">Pacote</th> <th width="5%">Telas</th>
                        <th width="25%" class="text-end">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($users) == 0): ?>
                        <tr><td colspan="7" class="text-center py-5 text-muted">Nenhum cliente encontrado.</td></tr>
                    <?php endif; ?>

                    <?php foreach($users as $u): 
                        $is_enabled = $u['enabled'];
                        $is_expired = $u['exp_date'] < time();
                        
                        if($is_enabled == 0) { $status_class = 'bg-secondary'; $status_text = 'BLOQUEADO'; } 
                        elseif($is_expired) { $status_class = 'bg-danger'; $status_text = 'VENCIDO'; } 
                        else { $status_class = 'bg-success'; $status_text = 'ATIVO'; }

                        $vencimento_fmt = date('d/m/Y H:i', $u['exp_date']);
                        $link_ssiptv = "{$dns_painel}/ssiptv.php?username={$u['username']}&password={$u['password']}";
                        $nome_pacote = $u['bouquet_name'] ?? 'Padrão'; // Pega nome do JOIN

                        $msg  = "╭──🔥 Seu Acesso foi criado com Sucesso\n";
                        $msg .= "├\n";
                        $msg .= "├● 💻 *Cliente* ➤ {$u['username']}\n";
                        $msg .= "├● 👨‍💼 *Login* : {$u['username']}\n";
                        $msg .= "├● 🔑 *Senha* : {$u['password']}\n";
                        $msg .= "├● 📦 *Pacote* : {$nome_pacote}\n"; // Adicionei o pacote na mensagem
                        $msg .= "├● 🌐 *DNS Smarters*: {$dns_streaming}\n";
                        $msg .= "├● 🕓 *Vencimento*: {$vencimento_fmt}\n";
                        $msg .= "╰──\n";
                        $msg .= "-----------------------------\n";
                        $msg .= "╭──\n";
                        $msg .= "├● 🔴 *Lista M3U:* {$dns_streaming}/get.php?username={$u['username']}&password={$u['password']}&type=m3u_plus&output=ts\n";
                        $msg .= "├● 🔴 *Lista HLS:* {$dns_streaming}/get.php?username={$u['username']}&password={$u['password']}&type=m3u_plus&output=m3u8\n";
                        $msg .= "├● 🔴 *Lista SSIPTV:* {$link_ssiptv}\n";
                        $msg .= "---------------------------------------------------------------------------\n";
                        $msg .= "✅ *Área do cliente:* {$dns_painel}/cliente\n";
                        $msg .= "---------------------------------------------------------------------------\n\n";
                        $msg .= "ATT: TOP IPTV";
                        
                        $link_zap = "https://wa.me/?text=" . urlencode($msg);
                    ?>
                    <tr>
                        <td><span class="badge <?= $status_class ?> rounded-pill" style="font-size:0.7rem"><?= $status_text ?></span></td>
                        <td>
                            <div class="fw-bold text-dark"><?= $u['username'] ?></div>
                            <?php if($is_admin && isset($u['dono_nome'])): ?>
                                <small class="text-muted" style="font-size: 0.7rem;"><i class="fas fa-user-tie"></i> <?= $u['dono_nome'] ?></small>
                            <?php endif; ?>
                        </td>
                        <td class="text-muted small"><?= $u['password'] ?></td>
                        <td><?= date('d/m/y', $u['exp_date']) ?></td>
                        <td><small class="badge bg-light text-dark border"><?= $nome_pacote ?></small></td> <td><?= $u['max_connections'] ?></td>
                        <td class="text-end">
                            <button class="btn btn-sm btn-success text-white fw-bold" data-bs-toggle="modal" data-bs-target="#renew<?= $u['id'] ?>" title="Renovar"><i class="fas fa-dollar-sign"></i></button>
                            <button class="btn btn-sm btn-info text-white" data-bs-toggle="modal" data-bs-target="#info<?= $u['id'] ?>" title="Ver Dados"><i class="fas fa-eye"></i></button>
                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#edit<?= $u['id'] ?>"><i class="fas fa-pen"></i></button>
                            <a href="?del=<?= $u['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Excluir?')"><i class="fas fa-trash"></i></a>
                        </td>
                    </tr>
                    
                    <div class="modal fade" id="info<?= $u['id'] ?>" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content border-0 shadow-lg">
                                <div class="modal-header bg-dark text-white border-0">
                                    <h5 class="modal-title fw-bold"><i class="fas fa-share-alt me-2"></i>Dados de Acesso</h5>
                                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body bg-light">
                                    <textarea class="form-control mb-3 shadow-sm" id="msg<?= $u['id'] ?>" rows="12" style="font-size: 0.85rem; font-family: monospace; background: #fff;" readonly><?= $msg ?></textarea>
                                    <div class="row g-2">
                                        <div class="col-6"><button class="btn btn-secondary w-100 fw-bold py-2" onclick="copiarTexto('msg<?= $u['id'] ?>')"><i class="fas fa-copy me-2"></i>Copiar</button></div>
                                        <div class="col-6"><a href="<?= $link_zap ?>" target="_blank" class="btn btn-success w-100 fw-bold py-2"><i class="fab fa-whatsapp me-2"></i>Enviar Zap</a></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="renew<?= $u['id'] ?>" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header bg-success text-white">
                                    <h5 class="modal-title fw-bold">Renovar Cliente</h5>
                                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                                </div>
                                <form method="POST">
                                    <div class="modal-body text-center">
                                        <input type="hidden" name="quick_renew" value="1">
                                        <input type="hidden" name="id_user" value="<?= $u['id'] ?>">
                                        <h4 class="fw-bold mt-2"><?= $u['username'] ?></h4>
                                        <div class="mb-3 px-4">
                                            <select name="meses" class="form-select form-select-lg fw-bold text-success text-center">
                                                <option value="1">1 Mês (1 Crédito)</option>
                                                <option value="3">3 Meses (3 Créditos)</option>
                                                <option value="6">6 Meses (6 Créditos)</option>
                                                <option value="12">12 Meses (12 Créditos)</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="modal-footer"><button class="btn btn-success w-100 fw-bold">Confirmar</button></div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="edit<?= $u['id'] ?>" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header bg-warning"><h5 class="modal-title">Editar</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
                                <form method="POST">
                                    <div class="modal-body">
                                        <input type="hidden" name="edit_user" value="1"><input type="hidden" name="id_user" value="<?= $u['id'] ?>">
                                        <div class="row">
                                            <div class="col-6 mb-2">
                                                <label class="small fw-bold">Senha</label>
                                                <input type="text" name="pass" class="form-control" value="<?= $u['password'] ?>">
                                            </div>
                                            <div class="col-6 mb-2">
                                                <label class="small fw-bold">Telas</label>
                                                <input type="number" name="conexoes" class="form-control" value="<?= $u['max_connections'] ?>">
                                            </div>
                                        </div>
                                        
                                        <div class="mb-2">
                                            <label class="small fw-bold text-primary">Pacote (Bouquet)</label>
                                            <select name="pacote_selecionado" class="form-select border-primary" required>
                                                <?php foreach($lista_bouquets as $bq): ?>
                                                    <option value="<?= $bq['id'] ?>" <?= $u['package_id'] == $bq['id'] ? 'selected' : '' ?>>
                                                        📦 <?= $bq['bouquet_name'] ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>

                                        <label class="small fw-bold">Vencimento</label>
                                        <input type="date" name="vencimento" class="form-control mb-3" value="<?= date('Y-m-d', $u['exp_date']) ?>">
                                        <label class="small fw-bold">Status do Cliente</label>
                                        <select name="status_cliente" class="form-select">
                                            <option value="1" <?= $u['enabled'] == 1 ? 'selected' : '' ?>>✅ Ativo (Liberado)</option>
                                            <option value="0" <?= $u['enabled'] == 0 ? 'selected' : '' ?>>🚫 Bloqueado</option>
                                        </select>
                                    </div>
                                    <div class="modal-footer"><button class="btn btn-warning w-100 fw-bold">Salvar</button></div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="modalAdd">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-primary text-white border-0">
                <h5 class="modal-title fw-bold"><i class="fas fa-user-plus me-2"></i>Novo Cliente</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="add_user" value="1">
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label small fw-bold text-muted">USUÁRIO</label>
                            <input type="text" name="user" class="form-control" required>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label small fw-bold text-muted">SENHA</label>
                            <input type="text" name="pass" class="form-control" required>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label small fw-bold text-primary">SELECIONE O PACOTE</label>
                        <select name="pacote_selecionado" class="form-select border-primary" required>
                            <?php foreach($lista_bouquets as $bq): ?>
                                <option value="<?= $bq['id'] ?>">📦 <?= $bq['bouquet_name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label small fw-bold text-muted">VENCIMENTO</label>
                            <input type="date" name="vencimento" class="form-control" value="<?= date('Y-m-d', strtotime('+30 days')) ?>" required>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label small fw-bold text-muted">TELAS</label>
                            <select name="conexoes" class="form-select">
                                <option value="1">1 Tela</option>
                                <option value="2">2 Telas</option>
                                <option value="3">3 Telas</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0 bg-light">
                    <button class="btn btn-primary px-4 fw-bold shadow-sm w-100">Criar Cliente</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php if($show_created_modal && $id_created > 0): ?>
<script>
    document.addEventListener("DOMContentLoaded", function(){
        var modalId = 'info' + <?= $id_created ?>;
        var myModal = new bootstrap.Modal(document.getElementById(modalId));
        myModal.show();
        window.history.replaceState({}, document.title, window.location.pathname);
    });
</script>
<?php endif; ?>

<script>
function copiarTexto(id) {
    var copyText = document.getElementById(id);
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    navigator.clipboard.writeText(copyText.value).then(() => { alert("Copiado!"); });
}
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body></html>
