<?php
/**
 * config.php - Versão FINAL Otimizada
 * - Garante compatibilidade com 9xtream/SSIPTV (pulando sessão).
 * - Garante que a variável $pdo esteja acessível globalmente para o Painel de Admin.
 */

// 1. Inclui a conexão com o banco
// A variável $pdo deve ser criada dentro de conexao.php
require_once 'conexao.php';

// -------------------------------------------------------------------
// CONFIGURAÇÕES GLOBAIS E API
// -------------------------------------------------------------------
define('TMDB_API_KEY', 'f99aa9ae1fe7619969cc7db0938c1ae5'); // Sua chave de API

// Define URL do Painel automaticamente
$base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
define('MAIN_DIR', $base_url);

// -------------------------------------------------------------------
// CONTROLE DE SESSÃO INTELIGENTE (Painel vs Apps)
// -------------------------------------------------------------------

// Pega o nome do arquivo atual (ex: get.php)
$script_atual = basename($_SERVER['SCRIPT_NAME']);

// Lista de arquivos que os APPS usam (NÃO podem ter bloqueio de login/sessão)
$arquivos_livres = [
    'get.php', 
    'player_api.php', 
    'api.php', 
    'xmltv.php', 
    'ssiptv.php', 
    'login.php', // Login nunca deve ser bloqueado
    'cron.php'
];

// Se NÃO for um arquivo de API, ativamos a segurança do painel
if (!in_array($script_atual, $arquivos_livres)) {
    
    if (session_status() === PHP_SESSION_NONE) {
        // Inicia a sessão APENAS se o arquivo não for de streaming
        session_start();
    }

    // Verifica se está logado no painel
    if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
        header("Location: login.php");
        exit;
    }
    
    // Carrega variáveis do usuário logado (Admin/Revenda)
    $my_id = $_SESSION['user_id'] ?? 0;
    $is_admin = ($_SESSION['group_id'] ?? 0) == 1; 
}

// -------------------------------------------------------------------
// FUNÇÕES AUXILIARES (Compatibilidade e Acesso ao DB)
// -------------------------------------------------------------------

// Se o seu painel usa a função conectar_bd(), mantemos ela
function conectar_bd() {
    global $pdo;
    return $pdo;
}

// === CORREÇÃO ESSENCIAL: GARANTE ACESSO GLOBAL AO $pdo ===
// Isso corrige o problema do arquivo Gerenciar Atividade não encontrar $pdo
global $pdo;
// ========================================================
