<?php 
require 'config.php'; 
require 'header.php'; 

// --- SALVAR STREAM ---
if(isset($_POST['add_stream'])) {
    $type = (int)$_POST['type']; // 1=Live, 2=Movie
    $name = $_POST['name'];
    $cat_id = json_encode([(int)$_POST['category_id']]); // Xtream usa array JSON
    $source = json_encode([$_POST['source']]); 
    $ext = pathinfo($_POST['source'], PATHINFO_EXTENSION);
    if(!$ext) $ext = 'mp4';

    $sql = "INSERT INTO streams (type, category_id, stream_display_name, stream_source, direct_source, target_container, added) 
            VALUES (?, ?, ?, ?, 1, ?, UNIX_TIMESTAMP())";
    
    $pdo->prepare($sql)->execute([$type, $cat_id, $name, $source, $ext]);
    echo "<script>alert('Adicionado com sucesso!'); window.location='conteudos.php';</script>";
}

// Listar últimos 50
$streams = $pdo->query("SELECT id, stream_display_name, type, stream_source FROM streams ORDER BY id DESC LIMIT 50")->fetchAll(PDO::FETCH_ASSOC);

// Carregar Categorias para o Select
$cats_live = getCategories($pdo, 'live');
$cats_movie = getCategories($pdo, 'movie');
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between mb-3">
        <h3>Gerenciar Filmes & Canais</h3>
        <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalStream"><i class="fas fa-plus"></i> Adicionar Conteúdo</button>
    </div>

    <div class="card">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Nome</th>
                    <th>Tipo</th>
                    <th>Link (Fonte)</th>
                    <th>Ação</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($streams as $s): 
                    $label = ($s['type'] == 1) ? '<span class="badge bg-primary">Live</span>' : '<span class="badge bg-warning text-dark">Filme</span>';
                    $src = json_decode($s['stream_source']);
                    $link = is_array($src) ? $src[0] : $s['stream_source'];
                ?>
                <tr>
                    <td><?= $s['stream_display_name'] ?></td>
                    <td><?= $label ?></td>
                    <td><small class="text-muted"><?= substr($link, 0, 50) ?>...</small></td>
                    <td><a href="?del=<?= $s['id'] ?>" class="btn btn-sm btn-danger">X</a></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="modalStream">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5>Adicionar Novo</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="add_stream" value="1">
                    
                    <label>Tipo de Conteúdo</label>
                    <select name="type" class="form-select mb-3" id="selType" onchange="mudarCats()">
                        <option value="1">Canal (Live TV)</option>
                        <option value="2">Filme (VOD)</option>
                    </select>

                    <label>Nome</label>
                    <input type="text" name="name" class="form-control mb-3" required>

                    <label>Categoria</label>
                    <select name="category_id" id="catLive" class="form-select mb-3">
                        <?php foreach($cats_live as $c) echo "<option value='{$c['id']}'>{$c['category_name']}</option>"; ?>
                    </select>
                    <select name="category_id" id="catMovie" class="form-select mb-3" style="display:none" disabled>
                        <?php foreach($cats_movie as $c) echo "<option value='{$c['id']}'>{$c['category_name']}</option>"; ?>
                    </select>

                    <label>Link Direto (URL)</label>
                    <input type="text" name="source" class="form-control mb-3" placeholder="http://..." required>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success">Adicionar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function mudarCats() {
    var tipo = document.getElementById('selType').value;
    if(tipo == '1') {
        document.getElementById('catLive').style.display = 'block';
        document.getElementById('catLive').disabled = false;
        document.getElementById('catMovie').style.display = 'none';
        document.getElementById('catMovie').disabled = true;
    } else {
        document.getElementById('catLive').style.display = 'none';
        document.getElementById('catLive').disabled = true;
        document.getElementById('catMovie').style.display = 'block';
        document.getElementById('catMovie').disabled = false;
    }
}
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body></html>