<?php
require 'config.php';
require 'header.php';

$id = $_GET['id'] ?? null;
$tabela = $_GET['tipo'] ?? 'stream'; // 'stream' (canais/filmes) ou 'serie'

if (!$id) { echo "ID não informado."; exit; }

// --- 1. BUSCAR TODAS AS CATEGORIAS (Para o Dropdown) ---
// Precisamos disso para preencher o <select>
$categorias = $pdo->query("SELECT id, category_name FROM streams_categories ORDER BY category_name ASC")->fetchAll(PDO::FETCH_ASSOC);

// --- 2. PROCESSAR O SALVAMENTO ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // Tratamento Padrão Xtream para Categoria (Salva como ["ID"])
    $cat_id_formatado = json_encode([(string)$_POST['category_id']]);

    if ($tabela == 'stream') {
        // --- ATUALIZAR STREAM (Canal/Filme) ---
        $nome = $_POST['nome'];
        $link = json_encode([$_POST['link']]); // Xtream usa JSON para links também
        $logo = $_POST['logo']; // Novo campo Logo
        
        $sql = "UPDATE streams SET stream_display_name = ?, stream_source = ?, stream_icon = ?, category_id = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$nome, $link, $logo, $cat_id_formatado, $id]);
        
        // Redireciona
        $destino = ($_POST['origem_tipo'] == 2) ? 'filmes.php' : 'canais.php'; // Se for tipo 2 é filme, senão canal
        echo "<script>window.location='$destino';</script>";
        
    } elseif ($tabela == 'serie') {
        // --- ATUALIZAR SÉRIE ---
        $nome = $_POST['nome'];
        $capa = $_POST['capa'];
        $plot = $_POST['plot'];
        
        // Nota: Séries no Xtream UI geralmente usam a tabela 'streams_series' ou 'series' dependendo da versão.
        // Mantive 'series' conforme seu código original, mas adicionei category_id.
        $sql = "UPDATE series SET title = ?, cover = ?, plot = ?, category_id = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$nome, $capa, $plot, $cat_id_formatado, $id]);
        
        echo "<script>window.location='series.php';</script>";
    }
}

// --- 3. BUSCAR DADOS ATUAIS PARA PREENCHER O FORMULÁRIO ---
if ($tabela == 'stream') {
    $dado = $pdo->query("SELECT * FROM streams WHERE id = $id")->fetch(PDO::FETCH_ASSOC);
    $links = json_decode($dado['stream_source']);
    $link_real = is_array($links) ? $links[0] : $dado['stream_source'];
    $imagem_atual = $dado['stream_icon'];
    
    // Limpa o ID da categoria atual (remove [" e "])
    $cat_atual_id = str_replace(['[', ']', '"'], '', $dado['category_id']);
    
} else {
    $dado = $pdo->query("SELECT * FROM series WHERE id = $id")->fetch(PDO::FETCH_ASSOC);
    $imagem_atual = $dado['cover'];
    $cat_atual_id = str_replace(['[', ']', '"'], '', $dado['category_id']);
}
?>

<div class="container mt-4 mb-5">
    <div class="card shadow">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h4 class="mb-0"><i class="fas fa-pen me-2"></i>Editar Conteúdo (ID: <?= $id ?>)</h4>
            <a href="javascript:history.back()" class="btn btn-light btn-sm fw-bold">Voltar</a>
        </div>
        <div class="card-body">
            <form method="POST">
                
                <div class="row">
                    <div class="col-md-8">
                        <?php if($tabela == 'stream'): ?>
                            <input type="hidden" name="origem_tipo" value="<?= $dado['type'] ?>">
                            
                            <div class="mb-3">
                                <label class="fw-bold">Nome de Exibição</label>
                                <input type="text" name="nome" class="form-control" value="<?= htmlspecialchars($dado['stream_display_name']) ?>" required>
                            </div>
                            
                            <div class="mb-3">
                                <label class="fw-bold">Link Direto (Source)</label>
                                <input type="text" name="link" class="form-control" value="<?= htmlspecialchars($link_real) ?>" required>
                                <small class="text-muted">Links .m3u8, .ts ou .mp4</small>
                            </div>

                            <div class="mb-3">
                                <label class="fw-bold">Logo do Canal / Capa Filme</label>
                                <input type="text" name="logo" class="form-control" value="<?= htmlspecialchars($dado['stream_icon']) ?>" onchange="document.getElementById('preview_img').src = this.value">
                            </div>

                        <?php else: ?>
                            <div class="mb-3">
                                <label class="fw-bold">Título da Série</label>
                                <input type="text" name="nome" class="form-control" value="<?= htmlspecialchars($dado['title']) ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="fw-bold">Capa (URL)</label>
                                <input type="text" name="capa" class="form-control" value="<?= htmlspecialchars($dado['cover']) ?>" onchange="document.getElementById('preview_img').src = this.value">
                            </div>
                            <div class="mb-3">
                                <label class="fw-bold">Sinopse</label>
                                <textarea name="plot" class="form-control" rows="4"><?= htmlspecialchars($dado['plot']) ?></textarea>
                            </div>
                        <?php endif; ?>

                        <div class="mb-3">
                            <label class="fw-bold text-primary">Categoria</label>
                            <select name="category_id" class="form-select" required>
                                <option value="">Selecione...</option>
                                <?php foreach($categorias as $cat): ?>
                                    <option value="<?= $cat['id'] ?>" <?= ($cat['id'] == $cat_atual_id) ? 'selected' : '' ?>>
                                        <?= $cat['category_name'] ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-4 text-center">
                        <label class="fw-bold mb-2">Pré-visualização</label>
                        <div class="p-2 border rounded bg-light">
                            <img id="preview_img" src="<?= $imagem_atual ?: 'https://via.placeholder.com/150' ?>" 
                                 style="max-width: 100%; height: auto; max-height: 300px; border-radius: 5px;" 
                                 onerror="this.src='https://via.placeholder.com/150?text=Sem+Imagem'">
                        </div>
                    </div>
                </div>

                <hr>
                <div class="d-flex justify-content-end gap-2">
                    <a href="javascript:history.back()" class="btn btn-secondary">Cancelar</a>
                    <button type="submit" class="btn btn-success fw-bold px-4">Salvar Alterações</button>
                </div>

            </form>
        </div>
    </div>
</div>

<script>
    // Script simples para atualizar a imagem se ela falhar ao carregar
    document.getElementById('preview_img').addEventListener('error', function() {
        this.src = 'https://via.placeholder.com/150?text=Erro+Imagem';
    });
</script>

</body>
</html>
