<?php
require 'config.php';
require 'header.php';

$id = $_GET['id'] ?? null;
$tabela = $_GET['tipo'] ?? 'stream'; // 'stream' (canais/filmes) ou 'serie'

if (!$id) { echo "ID não informado."; exit; }

// --- PROCESSAR O SALVAMENTO ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if ($tabela == 'stream') {
        // Atualiza Canal ou Filme
        $nome = $_POST['nome'];
        $link = json_encode([$_POST['link']]); // Xtream usa JSON
        $stmt = $pdo->prepare("UPDATE streams SET stream_display_name = ?, stream_source = ? WHERE id = ?");
        $stmt->execute([$nome, $link, $id]);
        
        // Redireciona de volta
        $destino = ($_POST['origem_tipo'] == 1) ? 'canais.php' : 'filmes.php';
        echo "<script>alert('Atualizado!'); window.location='$destino';</script>";
        
    } elseif ($tabela == 'serie') {
        // Atualiza Série
        $nome = $_POST['nome'];
        $capa = $_POST['capa'];
        $plot = $_POST['plot'];
        $stmt = $pdo->prepare("UPDATE series SET title = ?, cover = ?, plot = ? WHERE id = ?");
        $stmt->execute([$nome, $capa, $plot, $id]);
        echo "<script>alert('Série Atualizada!'); window.location='series.php';</script>";
    }
}

// --- BUSCAR DADOS PARA O FORMULÁRIO ---
if ($tabela == 'stream') {
    $dado = $pdo->query("SELECT * FROM streams WHERE id = $id")->fetch(PDO::FETCH_ASSOC);
    $links = json_decode($dado['stream_source']);
    $link_real = is_array($links) ? $links[0] : $dado['stream_source'];
} else {
    $dado = $pdo->query("SELECT * FROM series WHERE id = $id")->fetch(PDO::FETCH_ASSOC);
}
?>

<div class="container mt-4">
    <div class="card shadow">
        <div class="card-header bg-primary text-white">
            <h4>Editar Conteúdo (ID: <?= $id ?>)</h4>
        </div>
        <div class="card-body">
            <form method="POST">
                
                <?php if($tabela == 'stream'): ?>
                    <input type="hidden" name="origem_tipo" value="<?= $dado['type'] ?>">
                    
                    <div class="mb-3">
                        <label>Nome de Exibição</label>
                        <input type="text" name="nome" class="form-control" value="<?= htmlspecialchars($dado['stream_display_name']) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label>Link Direto (Source)</label>
                        <input type="text" name="link" class="form-control" value="<?= htmlspecialchars($link_real) ?>" required>
                    </div>

                <?php else: ?>
                    <div class="mb-3">
                        <label>Título da Série</label>
                        <input type="text" name="nome" class="form-control" value="<?= htmlspecialchars($dado['title']) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label>Capa (URL)</label>
                        <input type="text" name="capa" class="form-control" value="<?= htmlspecialchars($dado['cover']) ?>">
                        <img src="<?= $dado['cover'] ?>" style="height:100px; margin-top:10px;">
                    </div>
                    <div class="mb-3">
                        <label>Sinopse</label>
                        <textarea name="plot" class="form-control" rows="4"><?= htmlspecialchars($dado['plot']) ?></textarea>
                    </div>
                <?php endif; ?>

                <button type="submit" class="btn btn-success">Salvar Alterações</button>
                <a href="javascript:history.back()" class="btn btn-secondary">Cancelar</a>
            </form>
        </div>
    </div>
</div>
</body></html>