<?php
// editar_bouquet.php - Versão Otimizada com Fatiamento (Chunking) para Listas Grandes

require 'header.php'; 

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$pacote = [
    'bouquet_name' => '', 
    'bouquet_channels' => '[]', 
    'bouquet_movies' => '[]', 
    'bouquet_series' => '[]'
];

// --- 1. SALVAR DADOS ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nome = $_POST['nome'];
    
    $cats_live   = $_POST['cats_live'] ?? [];
    $cats_movie  = $_POST['cats_movie'] ?? [];
    $cats_series = $_POST['cats_series'] ?? [];

    // Detecção "Sem Categoria"
    $include_uncategorized_movies = in_array('0', $cats_movie);
    $cats_movie = array_diff($cats_movie, ['0']);

    // A. CANAIS (LIVE)
    $json_channels = "[]";
    $count_live = 0;
    if (!empty($cats_live)) {
        $lista = implode(',', array_map('intval', $cats_live));
        $sql = "SELECT id FROM streams WHERE type = 1 AND category_id IN ($lista)";
        $ids = $pdo->query($sql)->fetchAll(PDO::FETCH_COLUMN);
        $count_live = count($ids);
        if($count_live > 0) $json_channels = json_encode(array_map('intval', $ids));
    }

    // B. FILMES (MOVIES)
    $ids_movies = [];
    
    // 1. Categorias normais
    if (!empty($cats_movie)) {
        $lista = implode(',', array_map('intval', $cats_movie));
        $sql = "SELECT id FROM streams WHERE type = 2 AND category_id IN ($lista)";
        $res = $pdo->query($sql)->fetchAll(PDO::FETCH_COLUMN);
        if($res) $ids_movies = array_merge($ids_movies, $res);
    }
    
    // 2. Filmes Sem Categoria (Órfãos)
    if ($include_uncategorized_movies) {
        $sql_orphans = "SELECT id FROM streams WHERE type = 2 AND (category_id = 0 OR category_id IS NULL)";
        $ids_orphans = $pdo->query($sql_orphans)->fetchAll(PDO::FETCH_COLUMN);
        if($ids_orphans) $ids_movies = array_merge($ids_movies, $ids_orphans);
    }

    $ids_movies = array_unique($ids_movies); // Remove duplicados
    $count_movie = count($ids_movies);
    $json_movies = $count_movie > 0 ? json_encode(array_values(array_map('intval', $ids_movies))) : "[]";

    // C. SÉRIES
    $json_series = "[]";
    $count_series = 0;
    if (!empty($cats_series)) {
        $lista = implode(',', array_map('intval', $cats_series));
        $sql = "SELECT id FROM streams_series WHERE category_id IN ($lista)";
        $ids = $pdo->query($sql)->fetchAll(PDO::FETCH_COLUMN);
        $count_series = count($ids);
        if($count_series > 0) $json_series = json_encode(array_map('intval', $ids));
    }

    try {
        if ($id > 0) {
            $stmt = $pdo->prepare("UPDATE bouquets SET bouquet_name=?, bouquet_channels=?, bouquet_movies=?, bouquet_series=? WHERE id=?");
            $stmt->execute([$nome, $json_channels, $json_movies, $json_series, $id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO bouquets (bouquet_name, bouquet_channels, bouquet_movies, bouquet_series) VALUES (?, ?, ?, ?)");
            $stmt->execute([$nome, $json_channels, $json_movies, $json_series]);
            $id = $pdo->lastInsertId(); // Pega o ID novo para redirecionar corretamente
        }

        $msg = "Pacote Salvo!\\n\\nResumo:\\n- TV: $count_live\\n- Filmes: $count_movie\\n- Séries: $count_series";
        echo "<script>alert(`$msg`); window.location='editar_bouquet.php?id=$id';</script>";
        exit;

    } catch (Exception $e) {
        echo "<div class='alert alert-danger'>Erro SQL: " . $e->getMessage() . "</div>";
    }
}

// --- 2. CARREGAR DADOS ---
$cats_checked_live = [];
$cats_checked_movie = [];
$cats_checked_series = [];
$check_orphans = false;

if ($id > 0) {
    $stmt = $pdo->prepare("SELECT * FROM bouquets WHERE id = ?");
    $stmt->execute([$id]);
    $pacote = $stmt->fetch(PDO::FETCH_ASSOC);

    // --- FUNÇÃO DE FATIAMENTO (CHUNKING) PARA LER LISTAS GIGANTES ---
    function recuperarCategorias($pdo, $ids_json, $tabela, $is_orphan_check = false) {
        $ids = json_decode($ids_json, true);
        if (empty($ids)) return $is_orphan_check ? false : [];

        $cats_encontradas = [];
        $has_orphans = false;

        // Divide a lista gigante em pedaços de 1000 para não travar o SQL
        $chunks = array_chunk($ids, 1000);

        foreach ($chunks as $chunk) {
            $ids_str = implode(',', $chunk);
            
            // Busca categorias normais
            if (!$is_orphan_check) {
                if ($tabela == 'streams_series') {
                    $sql = "SELECT DISTINCT category_id FROM streams_series WHERE id IN ($ids_str)";
                } else {
                    $sql = "SELECT DISTINCT category_id FROM streams WHERE id IN ($ids_str)";
                }
                $res = $pdo->query($sql)->fetchAll(PDO::FETCH_COLUMN);
                if($res) $cats_encontradas = array_merge($cats_encontradas, $res);
            }

            // Verifica órfãos (apenas para filmes)
            if ($is_orphan_check) {
                $sql_orp = "SELECT count(*) FROM streams WHERE id IN ($ids_str) AND (category_id = 0 OR category_id IS NULL)";
                if ($pdo->query($sql_orp)->fetchColumn() > 0) {
                    $has_orphans = true;
                }
            }
        }
        
        return $is_orphan_check ? $has_orphans : array_unique($cats_encontradas);
    }

    // APLICA O RECUPERADOR FATIADO
    $cats_checked_live = recuperarCategorias($pdo, $pacote['bouquet_channels'], 'streams');
    $cats_checked_movie = recuperarCategorias($pdo, $pacote['bouquet_movies'], 'streams');
    $check_orphans = recuperarCategorias($pdo, $pacote['bouquet_movies'], 'streams', true); // Verifica checkbox órfão
    $cats_checked_series = recuperarCategorias($pdo, $pacote['bouquet_series'], 'streams_series');
}

// --- 3. LISTAR CATEGORIAS ---
$lista_cat_live = $pdo->query("SELECT id, category_name FROM streams_categories WHERE category_type = 'live' ORDER BY category_name ASC")->fetchAll(PDO::FETCH_ASSOC);
$lista_cat_movie = $pdo->query("SELECT id, category_name FROM streams_categories WHERE category_type = 'movie' ORDER BY category_name ASC")->fetchAll(PDO::FETCH_ASSOC);
try {
    $lista_cat_series = $pdo->query("SELECT id, category_name FROM streams_categories WHERE category_type = 'series' ORDER BY category_name ASC")->fetchAll(PDO::FETCH_ASSOC);
} catch(Exception $e) { $lista_cat_series = []; }

// Contagem para o alerta amarelo
$count_orphans = $pdo->query("SELECT count(*) FROM streams WHERE type = 2 AND (category_id = 0 OR category_id IS NULL)")->fetchColumn();

?>

<div class="container mt-4 mb-5">
    
    <div class="row justify-content-center">
        <div class="col-lg-10">
            
            <form method="POST">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="fw-bold text-dark">
                        <?= $id > 0 ? 'Editar Pacote' : 'Criar Novo Pacote' ?>
                    </h3>
                    <button type="submit" class="btn btn-success btn-lg shadow">
                        <i class="fas fa-save me-2"></i> Salvar e Aplicar
                    </button>
                </div>

                <div class="card shadow-sm border-0 mb-4">
                    <div class="card-body">
                        <label class="form-label fw-bold">Nome do Pacote</label>
                        <input type="text" name="nome" class="form-control form-control-lg" required value="<?= htmlspecialchars($pacote['bouquet_name']) ?>">
                    </div>
                </div>

                <div class="card shadow-sm border-0">
                    <div class="card-header bg-white border-bottom-0 pt-3">
                        <ul class="nav nav-tabs card-header-tabs" id="myTab" role="tablist">
                            <li class="nav-item"><button class="nav-link active fw-bold" id="live-tab" data-bs-toggle="tab" data-bs-target="#live" type="button"><i class="fas fa-tv me-2 text-primary"></i>Canais TV</button></li>
                            <li class="nav-item"><button class="nav-link fw-bold" id="movies-tab" data-bs-toggle="tab" data-bs-target="#movies" type="button"><i class="fas fa-film me-2 text-warning"></i>Filmes</button></li>
                            <li class="nav-item"><button class="nav-link fw-bold" id="series-tab" data-bs-toggle="tab" data-bs-target="#series" type="button"><i class="fas fa-layer-group me-2" style="color: #6f42c1;"></i>Séries</button></li>
                        </ul>
                    </div>
                    
                    <div class="card-body p-0">
                        <div class="tab-content" id="myTabContent">
                            
                            <div class="tab-pane fade show active" id="live">
                                <div class="p-3 bg-light border-bottom d-flex justify-content-between">
                                    <span class="fw-bold text-primary">Categorias de TV</span>
                                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="marcarTodos('live')">Marcar Tudo</button>
                                </div>
                                <div class="p-4" style="max-height: 500px; overflow-y: auto;">
                                    <div class="row">
                                        <?php foreach($lista_cat_live as $c): 
                                            $checked = in_array($c['id'], $cats_checked_live) ? 'checked' : '';
                                        ?>
                                            <div class="col-md-6 col-lg-4 mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input check-live" type="checkbox" name="cats_live[]" value="<?= $c['id'] ?>" id="live_<?= $c['id'] ?>" <?= $checked ?>>
                                                    <label class="form-check-label w-100 text-truncate" for="live_<?= $c['id'] ?>"><?= htmlspecialchars($c['category_name']) ?></label>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="movies">
                                <div class="p-3 bg-light border-bottom d-flex justify-content-between">
                                    <span class="fw-bold text-warning">Categorias de Filmes</span>
                                    <button type="button" class="btn btn-sm btn-outline-warning" onclick="marcarTodos('movie')">Marcar Tudo</button>
                                </div>
                                <div class="p-4" style="max-height: 500px; overflow-y: auto;">
                                    <div class="row">
                                        
                                        <?php if($count_orphans > 0): ?>
                                            <div class="col-12 mb-3">
                                                <div class="card border-warning bg-warning-subtle">
                                                    <div class="card-body d-flex align-items-center">
                                                        <div class="form-check">
                                                            <input class="form-check-input check-movie" type="checkbox" name="cats_movie[]" value="0" id="movie_0" style="transform: scale(1.3);" <?= $check_orphans ? 'checked' : '' ?>>
                                                            <label class="form-check-label fw-bold ms-2 text-dark" for="movie_0">
                                                                ⚠️ INCLUIR FILMES SEM CATEGORIA (<?= $count_orphans ?> encontrados)
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <?php foreach($lista_cat_movie as $c): 
                                            $checked = in_array($c['id'], $cats_checked_movie) ? 'checked' : '';
                                        ?>
                                            <div class="col-md-6 col-lg-4 mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input check-movie" type="checkbox" name="cats_movie[]" value="<?= $c['id'] ?>" id="movie_<?= $c['id'] ?>" <?= $checked ?>>
                                                    <label class="form-check-label w-100 text-truncate" for="movie_<?= $c['id'] ?>"><?= htmlspecialchars($c['category_name']) ?></label>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="series">
                                <div class="p-3 bg-light border-bottom d-flex justify-content-between">
                                    <span class="fw-bold" style="color: #6f42c1;">Categorias de Séries</span>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="marcarTodos('series')">Marcar Tudo</button>
                                </div>
                                <div class="p-4" style="max-height: 500px; overflow-y: auto;">
                                    <div class="row">
                                        <?php foreach($lista_cat_series as $c): 
                                            $checked = in_array($c['id'], $cats_checked_series) ? 'checked' : '';
                                        ?>
                                            <div class="col-md-6 col-lg-4 mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input check-series" type="checkbox" name="cats_series[]" value="<?= $c['id'] ?>" id="series_<?= $c['id'] ?>" <?= $checked ?>>
                                                    <label class="form-check-label w-100 text-truncate" for="series_<?= $c['id'] ?>"><?= htmlspecialchars($c['category_name']) ?></label>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function marcarTodos(tipo) {
        let checkboxes = document.querySelectorAll('.check-' + tipo);
        if(checkboxes.length === 0) return;
        let estado = !checkboxes[0].checked;
        checkboxes.forEach(c => c.checked = estado);
    }
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<div class="content">