<?php
require 'config.php';
require 'header.php';

// Segurança: Apenas Admin
$grupo = $_SESSION['group_id'] ?? 0;
if ($grupo != 1) { echo "<script>window.location='index.php';</script>"; exit; }

// Processar Atualização
if (isset($_POST['salvar_links'])) {
    foreach ($_POST['links'] as $id => $novo_link) {
        // Recria o JSON Array que o Xtream precisa ["link"]
        $json_link = json_encode([$novo_link]);
        $pdo->prepare("UPDATE streams SET stream_source = ? WHERE id = ?")->execute([$json_link, $id]);
    }
    echo "<div class='alert alert-success fw-bold'>Links atualizados com sucesso!</div>";
}

// Filtros
$tipo = $_GET['tipo'] ?? 1; // 1=Live, 2=Movie
$busca = $_GET['busca'] ?? '';

// Busca no Banco
$sql = "SELECT id, stream_display_name, stream_source FROM streams WHERE type = $tipo";
if($busca) { $sql .= " AND stream_display_name LIKE '%$busca%'"; }
$sql .= " LIMIT 100"; // Limite para não travar a tela
$itens = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4 mt-2">
        <h4 class="fw-bold">Editor Manual de Links</h4>
    </div>

    <div class="card p-3 mb-4">
        <form method="GET" class="row g-2">
            <div class="col-md-3">
                <select name="tipo" class="form-select" onchange="this.form.submit()">
                    <option value="1" <?= $tipo == 1 ? 'selected' : '' ?>>Canais (Live)</option>
                    <option value="2" <?= $tipo == 2 ? 'selected' : '' ?>>Filmes (VOD)</option>
                </select>
            </div>
            <div class="col-md-6">
                <input type="text" name="busca" class="form-control" placeholder="Buscar por nome..." value="<?= $busca ?>">
            </div>
            <div class="col-md-3">
                <button class="btn btn-primary w-100">Filtrar</button>
            </div>
        </form>
    </div>

    <div class="card p-3 mb-4 bg-light border-warning">
        <label class="fw-bold">Troca Rápida (Aplica apenas na lista abaixo)</label>
        <div class="input-group">
            <input type="text" id="find" class="form-control" placeholder="Texto Antigo (ex: http://velho.com)">
            <input type="text" id="replace" class="form-control" placeholder="Texto Novo (ex: http://novo.com)">
            <button type="button" class="btn btn-warning fw-bold" onclick="aplicarTroca()">Aplicar na Tela</button>
        </div>
        <small class="text-muted">Isso muda os textos abaixo. Clique em "SALVAR TUDO" para gravar no banco.</small>
    </div>

    <form method="POST">
        <button type="submit" name="salvar_links" class="btn btn-success btn-lg w-100 mb-3 fw-bold sticky-top" style="top:10px; z-index:999;">
            <i class="fas fa-save me-2"></i> SALVAR ALTERAÇÕES
        </button>

        <div class="card">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-dark text-white">
                        <tr>
                            <th width="30%">Nome</th>
                            <th width="70%">Link (Edite aqui)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($itens as $item): 
                            // Limpa o JSON para mostrar link limpo
                            $link_sujo = $item['stream_source'];
                            $link_limpo = str_replace(['["', '"]', '\/'], ['', '', '/'], $link_sujo);
                        ?>
                        <tr>
                            <td class="fw-bold"><?= $item['stream_display_name'] ?></td>
                            <td>
                                <input type="text" name="links[<?= $item['id'] ?>]" class="form-control link-input" value="<?= $link_limpo ?>">
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </form>
</div>

<script>
function aplicarTroca() {
    var antigo = document.getElementById('find').value;
    var novo = document.getElementById('replace').value;
    
    if(!antigo) { alert('Digite o texto antigo!'); return; }

    var inputs = document.querySelectorAll('.link-input');
    var count = 0;

    inputs.forEach(function(input) {
        if(input.value.includes(antigo)) {
            input.value = input.value.split(antigo).join(novo);
            input.style.backgroundColor = '#d4edda'; // Marca de verde o que mudou
            count++;
        }
    });
    alert(count + " links alterados na tela. Clique em SALVAR para confirmar.");
}
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body></html>
