<?php
require 'config.php';
require 'header.php';

// Pega o ID da série da URL
$id_serie = $_GET['id'] ?? 0;
if(!$id_serie) { echo "<script>window.location='series.php';</script>"; exit; }

// --- 1. ATUALIZAR DADOS DA SÉRIE (Lado Esquerdo) ---
if(isset($_POST['update_serie'])) {
    $title = $_POST['title'];
    $plot  = $_POST['plot'];
    $cover = $_POST['cover'];
    $backdrop = $_POST['backdrop'];
    $genre = $_POST['genre'];
    $release = $_POST['release_date'];
    $rating = $_POST['rating'];
    $director = $_POST['director'];
    $cast = $_POST['cast'];
    $youtube = $_POST['youtube_trailer'];
    
    $sql = "UPDATE streams_series SET title=?, plot=?, cover=?, cover_big=?, genre=?, release_date=?, rating=?, backdrop_path=?, director=?, cast=?, youtube_trailer=? WHERE id=?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$title, $plot, $cover, $cover, $genre, $release, $rating, $backdrop, $director, $cast, $youtube, $id_serie]);
    
    echo "<script>window.location='editar_serie.php?id=$id_serie';</script>";
}

// --- 2. ADICIONAR EPISÓDIO ---
if(isset($_POST['add_episode'])) {
    $season_num  = (int)$_POST['season_num'];
    $episode_num = (int)$_POST['episode_num'];
    $ep_title    = $_POST['ep_title']; 
    $url         = $_POST['url_stream']; 
    $extension   = $_POST['extension']; 
    
    $source_json = json_encode([$url]);
    
    // Cria o arquivo
    $sql_stream = "INSERT INTO streams (type, stream_display_name, stream_source, target_container, added) VALUES (2, ?, ?, ?, UNIX_TIMESTAMP())";
    $stmt = $pdo->prepare($sql_stream);
    $stmt->execute([$ep_title, $source_json, $extension]);
    $new_stream_id = $pdo->lastInsertId();
    
    // Vincula
    $sql_link = "INSERT INTO streams_episodes (series_id, stream_id, season_num, episode_num) VALUES (?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql_link);
    $stmt->execute([$id_serie, $new_stream_id, $season_num, $episode_num]);
    
    echo "<script>window.location='editar_serie.php?id=$id_serie';</script>";
}

// --- 3. EDITAR EPISÓDIO (NOVO!) ---
if(isset($_POST['edit_episode'])) {
    $id_stream   = (int)$_POST['ep_stream_id']; // ID oculto
    $season_num  = (int)$_POST['season_num'];
    $episode_num = (int)$_POST['episode_num'];
    $ep_title    = $_POST['ep_title'];
    $url         = $_POST['url_stream'];
    $extension   = $_POST['extension'];

    $source_json = json_encode([$url]);

    // A. Atualiza o arquivo (Tabela streams)
    $sql_file = "UPDATE streams SET stream_display_name=?, stream_source=?, target_container=? WHERE id=?";
    $pdo->prepare($sql_file)->execute([$ep_title, $source_json, $extension, $id_stream]);

    // B. Atualiza a ordem/temporada (Tabela streams_episodes)
    $sql_order = "UPDATE streams_episodes SET season_num=?, episode_num=? WHERE stream_id=? AND series_id=?";
    $pdo->prepare($sql_order)->execute([$season_num, $episode_num, $id_stream, $id_serie]);

    echo "<script>window.location='editar_serie.php?id=$id_serie';</script>";
}

// --- 4. DELETAR EPISÓDIO ---
if(isset($_GET['del_ep'])) {
    $id_stream = (int)$_GET['del_ep'];
    $pdo->query("DELETE FROM streams_episodes WHERE stream_id = $id_stream");
    $pdo->query("DELETE FROM streams WHERE id = $id_stream");
    echo "<script>window.location='editar_serie.php?id=$id_serie';</script>";
}

// --- BUSCAR DADOS ---
$serie = $pdo->query("SELECT * FROM streams_series WHERE id = $id_serie")->fetch(PDO::FETCH_ASSOC);

$sql_eps = "SELECT e.*, s.stream_display_name, s.stream_source, s.target_container 
            FROM streams_episodes e 
            LEFT JOIN streams s ON e.stream_id = s.id 
            WHERE e.series_id = $id_serie 
            ORDER BY e.season_num ASC, e.episode_num ASC";
$episodes = $pdo->query($sql_eps)->fetchAll(PDO::FETCH_ASSOC);

$seasons = [];
foreach($episodes as $ep) {
    $seasons[$ep['season_num']][] = $ep;
}
?>

<div class="container-fluid mt-4 mb-5">
    
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold text-dark"><i class="fas fa-edit me-2" style="color: #6f42c1;"></i>Gerenciar: <?= $serie['title'] ?></h4>
        <a href="series.php" class="btn btn-outline-secondary rounded-pill px-4"><i class="fas fa-arrow-left me-2"></i>Voltar</a>
    </div>

    <div class="row">
        
        <div class="col-lg-4 mb-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-white border-0 fw-bold pt-3 pb-0">Detalhes da Série</div>
                <div class="card-body">
                    <form method="POST">
                        <input type="hidden" name="update_serie" value="1">
                        <div class="text-center mb-3">
                            <img src="<?= $serie['cover'] ?>" class="img-fluid rounded shadow-sm" style="height: 200px; object-fit: cover;" onerror="this.src='https://via.placeholder.com/200?text=Capa'">
                        </div>
                        <div class="mb-2">
                            <label class="form-label small fw-bold text-muted">Título</label>
                            <input type="text" name="title" class="form-control" value="<?= $serie['title'] ?>" required>
                        </div>
                        <div class="row">
                             <div class="col-6 mb-2">
                                <label class="form-label small fw-bold text-muted">Capa</label>
                                <input type="text" name="cover" class="form-control form-control-sm" value="<?= $serie['cover'] ?>">
                            </div>
                            <div class="col-6 mb-2">
                                <label class="form-label small fw-bold text-muted">Fundo</label>
                                <input type="text" name="backdrop" class="form-control form-control-sm" value="<?= $serie['backdrop_path'] ?>">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-4 mb-2">
                                <label class="form-label small fw-bold text-muted">Nota</label>
                                <input type="text" name="rating" class="form-control form-control-sm" value="<?= $serie['rating'] ?>">
                            </div>
                            <div class="col-8 mb-2">
                                <label class="form-label small fw-bold text-muted">Lançamento</label>
                                <input type="text" name="release_date" class="form-control form-control-sm" value="<?= $serie['release_date'] ?>">
                            </div>
                        </div>
                        <div class="mb-2"><label class="form-label small fw-bold text-muted">Gênero</label><input type="text" name="genre" class="form-control form-control-sm" value="<?= $serie['genre'] ?>"></div>
                        <div class="mb-2"><label class="form-label small fw-bold text-muted">Elenco</label><input type="text" name="cast" class="form-control form-control-sm" value="<?= $serie['cast'] ?>"></div>
                        <div class="mb-2"><label class="form-label small fw-bold text-muted">Diretor</label><input type="text" name="director" class="form-control form-control-sm" value="<?= $serie['director'] ?>"></div>
                        <div class="mb-2"><label class="form-label small fw-bold text-muted">Trailer</label><input type="text" name="youtube_trailer" class="form-control form-control-sm" value="<?= $serie['youtube_trailer'] ?>"></div>
                        <div class="mb-3"><label class="form-label small fw-bold text-muted">Sinopse</label><textarea name="plot" class="form-control form-control-sm" rows="3"><?= $serie['plot'] ?></textarea></div>
                        <button class="btn btn-primary w-100 fw-bold rounded-pill" style="background-color: #6f42c1; border:none;">Salvar Alterações</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-8">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="fw-bold text-secondary mb-0">Episódios</h5>
                <button class="btn btn-success rounded-pill px-4 fw-bold shadow-sm" data-bs-toggle="modal" data-bs-target="#modalAddEp">
                    <i class="fas fa-plus me-2"></i> Adicionar Episódio
                </button>
            </div>

            <?php if(empty($seasons)): ?>
                <div class="alert alert-light border text-center py-5">
                    <i class="fas fa-film fa-3x text-muted mb-3"></i><br>
                    <span class="text-muted">Nenhum episódio adicionado ainda.</span>
                </div>
            <?php else: ?>
                <?php foreach($seasons as $num_season => $lista_eps): ?>
                    <div class="card mb-4 border-0 shadow-sm overflow-hidden">
                        <div class="card-header fw-bold text-white d-flex justify-content-between align-items-center" style="background-color: #8c68cd;">
                            <span><i class="fas fa-folder-open me-2"></i>TEMPORADA <?= $num_season ?></span>
                            <span class="badge bg-white text-dark rounded-pill"><?= count($lista_eps) ?> Eps</span>
                        </div>
                        <div class="list-group list-group-flush">
                            <?php foreach($lista_eps as $ep): 
                                $link_limpo = str_replace(['[', ']', '"', '\\'], '', $ep['stream_source']);
                            ?>
                            <div class="list-group-item d-flex justify-content-between align-items-center py-3">
                                <div class="d-flex align-items-center overflow-hidden">
                                    <div class="bg-light rounded-circle d-flex justify-content-center align-items-center me-3 text-secondary fw-bold" style="width: 40px; height: 40px; min-width:40px;">
                                        <?= $ep['episode_num'] ?>
                                    </div>
                                    <div class="text-truncate">
                                        <div class="fw-bold text-dark"><?= $ep['stream_display_name'] ?></div>
                                        <small class="text-muted d-block text-truncate">
                                            <i class="fas fa-link me-1 text-secondary"></i> <?= substr($link_limpo, 0, 50) ?>...
                                        </small>
                                    </div>
                                </div>
                                <div class="ps-2 d-flex gap-2">
                                    <span class="badge bg-light text-secondary border align-self-center"><?= strtoupper($ep['target_container']) ?></span>
                                    
                                    <button class="btn btn-sm btn-warning text-white rounded-circle" style="width: 32px; height: 32px; padding: 0;" title="Editar"
                                            onclick='openEditModal(<?= json_encode($ep) ?>)'>
                                        <i class="fas fa-pen" style="line-height: 30px;"></i>
                                    </button>

                                    <a href="?id=<?= $id_serie ?>&del_ep=<?= $ep['stream_id'] ?>" class="btn btn-sm btn-outline-danger rounded-circle" style="width: 32px; height: 32px; padding: 0;" title="Apagar" onclick="return confirm('Tem certeza?')">
                                        <i class="fas fa-trash" style="line-height: 30px;"></i>
                                    </a>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="modal fade" id="modalAddEp">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header text-white" style="background-color: #28a745;">
                <h5 class="modal-title fw-bold">Novo Episódio</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="add_episode" value="1">
                    <div class="row g-2 mb-3">
                        <div class="col-6"><label class="form-label fw-bold small text-muted">TEMPORADA</label><input type="number" name="season_num" class="form-control text-center fw-bold" placeholder="1" required></div>
                        <div class="col-6"><label class="form-label fw-bold small text-muted">EPISÓDIO</label><input type="number" name="episode_num" class="form-control text-center fw-bold" placeholder="1" required></div>
                    </div>
                    <div class="mb-3"><label class="form-label fw-bold small text-muted">NOME</label><input type="text" name="ep_title" class="form-control" required></div>
                    <div class="mb-3"><label class="form-label fw-bold small text-muted">LINK (URL)</label><input type="text" name="url_stream" class="form-control" required></div>
                    <div class="mb-3"><label class="form-label fw-bold small text-muted">FORMATO</label>
                        <select name="extension" class="form-select"><option value="mp4">MP4</option><option value="mkv">MKV</option></select>
                    </div>
                </div>
                <div class="modal-footer border-0 bg-light">
                    <button type="button" class="btn btn-link text-muted" data-bs-dismiss="modal">Cancelar</button>
                    <button class="btn btn-success px-4 fw-bold rounded-pill">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditEp">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header text-white" style="background-color: #ffc107;">
                <h5 class="modal-title fw-bold text-dark">Editar Episódio</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="edit_episode" value="1">
                    <input type="hidden" name="ep_stream_id" id="edit_id"> <div class="row g-2 mb-3">
                        <div class="col-6"><label class="form-label fw-bold small text-muted">TEMPORADA</label><input type="number" name="season_num" id="edit_season" class="form-control text-center fw-bold" required></div>
                        <div class="col-6"><label class="form-label fw-bold small text-muted">EPISÓDIO</label><input type="number" name="episode_num" id="edit_num" class="form-control text-center fw-bold" required></div>
                    </div>
                    <div class="mb-3"><label class="form-label fw-bold small text-muted">NOME</label><input type="text" name="ep_title" id="edit_title" class="form-control" required></div>
                    <div class="mb-3"><label class="form-label fw-bold small text-muted">LINK (URL)</label><input type="text" name="url_stream" id="edit_url" class="form-control" required></div>
                    <div class="mb-3"><label class="form-label fw-bold small text-muted">FORMATO</label>
                        <select name="extension" id="edit_ext" class="form-select"><option value="mp4">MP4</option><option value="mkv">MKV</option></select>
                    </div>
                </div>
                <div class="modal-footer border-0 bg-light">
                    <button type="button" class="btn btn-link text-muted" data-bs-dismiss="modal">Cancelar</button>
                    <button class="btn btn-warning px-4 fw-bold rounded-pill text-dark">Atualizar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Função Javascript para preencher o Modal de Edição
function openEditModal(epData) {
    // Limpa a URL que vem do banco ["http..."]
    let urlClean = epData.stream_source.replace(/\[|\]|"/g, '').replace(/\\/g, '');

    // Preenche os campos
    document.getElementById('edit_id').value = epData.stream_id;
    document.getElementById('edit_season').value = epData.season_num;
    document.getElementById('edit_num').value = epData.episode_num;
    document.getElementById('edit_title').value = epData.stream_display_name;
    document.getElementById('edit_url').value = urlClean;
    document.getElementById('edit_ext').value = epData.target_container;

    // Abre o Modal
    var myModal = new bootstrap.Modal(document.getElementById('modalEditEp'));
    myModal.show();
}
</script>
</body></html>