<?php
require 'config.php';
session_start();

// VERIFICAÇÃO DE SEGURANÇA
if ($_SESSION['group_id'] != 1) { echo "Acesso negado"; exit; }

// --- CONFIGURAÇÃO TMDB ---
$tmdb_key = 'f99aa9ae1fe7619969cc7db0938c1ae5'; // <--- COLE SUA CHAVE ENTRE AS ASPAS
$idioma_tmdb = 'pt-BR';       // Idioma da sinopse e capa
// -------------------------

set_time_limit(0); 
ini_set('display_errors', 0); 

$cats_selecionadas = $_POST['categorias'] ?? [];
$temp_file = $_POST['temp_file'] ?? '';

if (empty($cats_selecionadas) || empty($temp_file) || !file_exists($temp_file)) {
    http_response_code(400); echo "Arquivo temporário não encontrado."; exit;
}

$dados_brutos = json_decode(file_get_contents($temp_file), true);
file_put_contents('log_importacao.txt', '');

// FUNÇÃO DE LOG
function logMsg($msg, $tipo = 'INFO') {
    $time = date('H:i:s');
    $prefix = ($tipo == 'ERRO') ? '[ERRO] ' : '';
    file_put_contents('log_importacao.txt', "[$time] $prefix$msg" . PHP_EOL, FILE_APPEND);
}

// FUNÇÃO PARA LIMPAR NOME E BUSCAR NO TMDB
function buscarTMDB($nome_sujo, $key, $lang) {
    // Se não tiver chave, nem tenta
    if (empty($key) || $key == 'SUA_CHAVE_AQUI') return false;

    // 1. Limpeza do nome para melhorar a busca
    // Remove coisas entre colchetes [] e parenteses () ex: [FHD] (2023)
    $nome_limpo = preg_replace('/\[.*?\]|\(.*?\)/', '', $nome_sujo);
    // Remove palavras técnicas comuns
    $remove = ['FHD', 'HD', '4K', '1080p', '720p', 'DUAL', 'LEG', 'DUB', 'MP4', 'MKV', 'AVI', 'H265', 'HEVC'];
    $nome_limpo = str_ireplace($remove, ' ', $nome_limpo);
    // Remove caracteres especiais
    $nome_limpo = str_replace(['-', '_', '.'], ' ', $nome_limpo);
    $nome_limpo = trim(preg_replace('/\s+/', ' ', $nome_limpo)); // Tira espaços duplos

    if (strlen($nome_limpo) < 2) return false;

    // 2. Chama a API do TMDB
    $url = "https://api.themoviedb.org/3/search/movie?api_key=$key&query=" . urlencode($nome_limpo) . "&language=$lang&page=1";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 3); // Espera max 3 segundos por filme
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    curl_close($ch);

    $json = json_decode($response, true);

    if (!empty($json['results'][0])) {
        $top = $json['results'][0];
        return [
            'poster'   => $top['poster_path'] ? "https://image.tmdb.org/t/p/w600_and_h900_bestv2" . $top['poster_path'] : '',
            'backdrop' => $top['backdrop_path'] ? "https://image.tmdb.org/t/p/original" . $top['backdrop_path'] : '',
            'plot'     => $top['overview'] ?? '',
            'rating'   => $top['vote_average'] ?? 0,
            'date'     => $top['release_date'] ?? ''
        ];
    }
    return false;
}

logMsg(">>> INICIANDO IMPORTAÇÃO COM TMDB...");

foreach ($cats_selecionadas as $cat_nome) {
    if (!isset($dados_brutos[$cat_nome])) continue;

    logMsg("--- Categoria: $cat_nome ---");

    $primeiro_item = $dados_brutos[$cat_nome][0];
    $tipo_bd = ($primeiro_item['type'] == 'VOD') ? 'movie' : 'live'; 
    $is_vod_cat = ($tipo_bd == 'movie');

    // CRIA OU BUSCA CATEGORIA
    try {
        $stmt = $pdo->prepare("SELECT id FROM streams_categories WHERE category_name = ? AND category_type = ?");
        $stmt->execute([$cat_nome, $tipo_bd]);
        $cat_row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($cat_row) {
            $cat_id = $cat_row['id'];
        } else {
            $stmt = $pdo->prepare("INSERT INTO streams_categories (category_name, category_type) VALUES (?, ?)");
            $stmt->execute([$cat_nome, $tipo_bd]);
            $cat_id = $pdo->lastInsertId();
        }
    } catch (Exception $e) {
        logMsg("Erro Crítico Categoria: " . $e->getMessage(), 'ERRO');
        continue;
    }

    $cat_id_json = '["' . $cat_id . '"]'; 
    $count_sucesso = 0;

    foreach ($dados_brutos[$cat_nome] as $item) {
        $nome = trim($item['name']);
        if (empty($nome)) $nome = "Item " . rand(1000, 9999);
        $url = trim($item['url']);
        $logo = trim($item['logo']); 
        $is_vod_item = ($item['type'] == 'VOD');

        // --- INTEGRAÇÃO TMDB ---
        $movie_propeties = NULL; // Começa nulo
        
        // Só busca se for filme E tiver chave configurada
        if ($is_vod_item && strlen($tmdb_key) > 5 && $tmdb_key != 'SUA_CHAVE_AQUI') {
            $infos = buscarTMDB($nome, $tmdb_key, $idioma_tmdb);
            
            if ($infos) {
                // Se achou capa, substitui a original
                if (!empty($infos['poster'])) {
                    $logo = $infos['poster'];
                }
                
                // Monta o JSON de propriedades (formato padrão XUI)
                $props = [
                    'plot' => $infos['plot'],
                    'rating' => $infos['rating'],
                    'releasedate' => $infos['date'],
                    'backdrop_path' => [$infos['backdrop']]
                ];
                $movie_propeties = json_encode($props);
            }
        }

        $stream_type = $is_vod_item ? 2 : 1; 
        $added_time = time(); 

        try {
            // Verifica duplicidade
            $stmtCheck = $pdo->prepare("SELECT id FROM streams WHERE stream_source = ?");
            $stmtCheck->execute([$url]);
            
            if ($stmtCheck->rowCount() == 0) {
                
                // TENTATIVA 1: Inserir COMPLETO (com sinopse/properties)
                // Usamos try/catch interno porque seu banco pode não ter a coluna 'movie_propeties'
                $inserido = false;

                if ($movie_propeties) {
                    try {
                        $sqlFull = "INSERT INTO streams 
                        (type, category_id, stream_display_name, stream_source, stream_icon, movie_propeties, direct_source, added, read_native) 
                        VALUES (?, ?, ?, ?, ?, ?, 1, ?, 0)";
                        $stmtFull = $pdo->prepare($sqlFull);
                        $stmtFull->execute([$stream_type, $cat_id_json, $nome, $url, $logo, $movie_propeties, $added_time]);
                        $inserido = true;
                    } catch (PDOException $e) {
                        // Se falhar (ex: coluna não existe), deixa cair para a tentativa 2
                    }
                }

                // TENTATIVA 2: Inserir BÁSICO (Se a 1 falhou ou não tinha dados do TMDB)
                if (!$inserido) {
                    $sqlBasic = "INSERT INTO streams 
                    (type, category_id, stream_display_name, stream_source, stream_icon, direct_source, added, read_native) 
                    VALUES (?, ?, ?, ?, ?, 1, ?, 0)";
                    $stmtBasic = $pdo->prepare($sqlBasic);
                    $stmtBasic->execute([$stream_type, $cat_id_json, $nome, $url, $logo, $added_time]);
                }

                $count_sucesso++;
                if ($count_sucesso % 10 == 0) logMsg("Importados $count_sucesso itens...");
            }
        } catch (Exception $e) {
            logMsg("FALHA ($nome): " . $e->getMessage(), 'ERRO');
        }
    }
    logMsg("Fim da categoria. Total Importado: $count_sucesso");
}

if (file_exists($temp_file)) unlink($temp_file);
logMsg(">>> FINALIZADO <<<");
?>
