<?php
// executar_importacao.php - VERSÃO CORRIGIDA PARA AGRUPAR EPISÓDIOS
require 'config.php';

// Configurações para importação pesada
set_time_limit(0);
ini_set('memory_limit', '2048M'); // Aumentei memória

function logMsg($msg, $tipo = 'info') {
    $linha = "<div class='log-line log-$tipo'>[" . date('H:i:s') . "] $msg</div>\n";
    file_put_contents('log_processo.txt', $linha, FILE_APPEND);
}
file_put_contents('log_processo.txt', "");

try {
    logMsg("Iniciando motor de importação V2 (Agrupamento Rígido)...", "info");

    $nome_arquivo = $_POST['temp_file'] ?? '';
    $cats_selecionadas = $_POST['categorias'] ?? [];
    $caminho_arquivo = 'uploads/' . $nome_arquivo;

    if (!file_exists($caminho_arquivo)) throw new Exception("Arquivo temporário sumiu.");

    $itens = json_decode(file_get_contents($caminho_arquivo), true);
    if (!$itens) throw new Exception("Erro no JSON.");

    // --- CACHES PARA PERFORMANCE ---
    // Categorias
    $cat_cache = [];
    $stmt = $pdo->query("SELECT id, category_name, category_type FROM streams_categories");
    while ($r = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $chave = strtoupper(trim($r['category_name'])) . '_' . $r['category_type'];
        $cat_cache[$chave] = $r['id'];
    }

    // Séries (Nome -> ID)
    $series_cache = [];
    $stmtS = $pdo->query("SELECT id, title FROM streams_series");
    while ($r = $stmtS->fetch(PDO::FETCH_ASSOC)) {
        // Normaliza o título para garantir match
        $titulo_norm = strtoupper(trim($r['title']));
        $series_cache[$titulo_norm] = $r['id'];
    }

    $importados = 0;
    $novas_series = 0;

    foreach ($itens as $item) {
        if (!in_array($item['cat'], $cats_selecionadas)) continue;

        $nome_original = trim($item['nome']);
        $url = trim($item['link']);
        $logo = trim($item['logo']);
        $cat_nome = strtoupper(trim($item['cat']));
        $tipo_detectado = $item['tipo']; 

        // 1. Resolve Categoria (Series, Movie, Live)
        $cat_type_db = ($tipo_detectado == 'SERIES') ? 'series' : (($tipo_detectado == 'VOD') ? 'movie' : 'live');
        
        $chave_cat = $cat_nome . '_' . $cat_type_db;
        if (isset($cat_cache[$chave_cat])) {
            $cat_id = $cat_cache[$chave_cat];
        } else {
            $pdo->prepare("INSERT INTO streams_categories (category_type, category_name, parent_id) VALUES (?, ?, 0)")->execute([$cat_type_db, $item['cat']]);
            $cat_id = $pdo->lastInsertId();
            $cat_cache[$chave_cat] = $cat_id;
        }

        // 2. IMPORTAÇÃO DE SÉRIES (AQUI ESTAVA O ERRO)
        if ($tipo_detectado == 'SERIES') {
            
            // --- DETECTAR TEMPORADA E EPISÓDIO ---
            $season = 1; $episode = 1;
            // Procura padrões: S01E01, 1x01, S1 E1
            if (preg_match('/S(\d+).*?E(\d+)/i', $nome_original, $se)) {
                $season = (int)$se[1]; $episode = (int)$se[2];
            } elseif (preg_match('/(\d+)x(\d+)/i', $nome_original, $se)) {
                $season = (int)$se[1]; $episode = (int)$se[2];
            }

            // --- LIMPEZA DE NOME AGRESSIVA (FIX) ---
            // O objetivo é pegar tudo O QUE VEM ANTES do S01E01
            // Ex: "Breaking Bad S01E05 - Ozymandias" -> Vira "Breaking Bad"
            
            $nome_serie = $nome_original;
            
            // Corta a string onde começa S00, E00 ou 0x00
            $padroes_corte = ['/S\d+/i', '/E\d+/i', '/\d+x\d+/i', '/ TEMPORADA/i', '/ SEASON/i'];
            foreach($padroes_corte as $regex) {
                $partes = preg_split($regex, $nome_serie);
                if(count($partes) > 1) {
                    $nome_serie = $partes[0]; // Pega só a primeira parte (antes do episódio)
                    break; 
                }
            }

            // Remove sujeiras comuns do final (tracinhos, pontos, espaços)
            $nome_serie = trim($nome_serie, " -.:;|");
            
            // Se o nome ficou vazio (erro de regex), usa o original
            if (strlen($nome_serie) < 2) $nome_serie = $nome_original;

            $serie_key = strtoupper($nome_serie);

            // --- BUSCAR OU CRIAR A SÉRIE PAI ---
            if (isset($series_cache[$serie_key])) {
                $series_id = $series_cache[$serie_key];
            } else {
                // Cria a Série Pai
                $sqlSerie = "INSERT INTO streams_series (title, category_id, cover, cover_big, plot, last_modified) VALUES (?, ?, ?, ?, 'Importado via M3U', UNIX_TIMESTAMP())";
                $pdo->prepare($sqlSerie)->execute([$nome_serie, $cat_id, $logo, $logo]);
                $series_id = $pdo->lastInsertId();
                $series_cache[$serie_key] = $series_id;
                $novas_series++;
                logMsg("Nova Série Cadastrada: $nome_serie", "success");
            }

            // --- VERIFICAR SE O EPISÓDIO JÁ EXISTE (Para não duplicar arquivo) ---
            $chk = $pdo->prepare("SELECT id FROM streams WHERE stream_source LIKE ?");
            $chk->execute(['%' . $url . '%']);
            
            if ($chk->rowCount() > 0) {
                 $stream_id = $chk->fetchColumn();
            } else {
                $ext = pathinfo(parse_url($url, PHP_URL_PATH), PATHINFO_EXTENSION) ?: 'mp4';
                $source_json = json_encode([$url]);
                // Nome do episódio: Se sobrar texto depois do nome da série, usa. Senão usa "Episódio X"
                $ep_nome = str_replace($nome_serie, '', $nome_original);
                $ep_nome = trim($ep_nome, " -");
                if(empty($ep_nome)) $ep_nome = "Episódio $episode";

                $pdo->prepare("INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, target_container, added, direct_source) VALUES (2, ?, ?, ?, ?, ?, UNIX_TIMESTAMP(), 1)")
                    ->execute([$cat_id, $ep_nome, $source_json, $logo, $ext]);
                $stream_id = $pdo->lastInsertId();
            }

            // --- VINCULAR (SÉRIE -> EPISÓDIO) ---
            $chkLink = $pdo->prepare("SELECT id FROM streams_episodes WHERE series_id=? AND stream_id=?");
            $chkLink->execute([$series_id, $stream_id]);
            if ($chkLink->rowCount() == 0) {
                $pdo->prepare("INSERT INTO streams_episodes (series_id, stream_id, season_num, episode_num) VALUES (?, ?, ?, ?)")
                    ->execute([$series_id, $stream_id, $season, $episode]);
            }
            $importados++;

        } else {
            // Importação Normal (Live/VOD)
            // ... (Código igual ao anterior para canais)
             $type_db = ($tipo_detectado == 'LIVE') ? 1 : 2;
             $chk = $pdo->prepare("SELECT id FROM streams WHERE stream_source LIKE ?");
             $chk->execute(['%' . $url . '%']);
             if ($chk->rowCount() == 0) {
                 $ext = pathinfo(parse_url($url, PHP_URL_PATH), PATHINFO_EXTENSION) ?: ($type_db==2?'mp4':'');
                 $source_json = json_encode([$url]);
                 $pdo->prepare("INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, target_container, added, direct_source) VALUES (?, ?, ?, ?, ?, ?, UNIX_TIMESTAMP(), 1)")
                    ->execute([$type_db, $cat_id, $nome_original, $source_json, $logo, $ext]);
                 $importados++;
             }
        }

        if ($importados % 50 == 0) logMsg("Processando... $importados itens (Séries novas: $novas_series)");
    }

    logMsg("FIM! Total Importado: $importados | Séries Criadas: $novas_series", "success");
    @unlink($caminho_arquivo);

} catch (Exception $e) {
    logMsg("ERRO: " . $e->getMessage(), "error");
}
?>