<?php 
require 'config.php'; 

// --- CONFIGURAÇÃO TMDB (Sua Key) ---
$tmdb_key = 'f99aa9ae1fe7619969cc7db0938c1ae5'; 

// ====================================================================
// 0. API AJAX (BUSCA TMDB)
// ====================================================================
if(isset($_POST['ajax_action'])) {
    if (ob_get_length()) ob_clean();
    ini_set('display_errors', 0);
    error_reporting(0);
    
    $termo = urlencode($_POST['term']);
    $url = "https://api.themoviedb.org/3/search/movie?api_key=$tmdb_key&query=$termo&language=pt-BR";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $res = curl_exec($ch);
    
    if(curl_errno($ch)){
        echo json_encode(['error' => curl_error($ch)]);
    } else {
        echo $res; 
    }
    curl_close($ch);
    exit;
}

require 'header.php'; 

// --- FUNÇÕES AUXILIARES ---
function getVodCategories($pdo) {
    return $pdo->query("SELECT id, category_name FROM streams_categories WHERE category_type = 'movie' ORDER BY category_name ASC")->fetchAll(PDO::FETCH_ASSOC);
}
$categorias = getVodCategories($pdo);

// ====================================================================
// 1. LÓGICA PHP (Salvar no Banco)
// ====================================================================

// A. ADICIONAR
if(isset($_POST['add_movie'])) {
    $cat_id = json_encode([(int)$_POST['category_id']]); 
    $link   = $_POST['link'];
    $source = json_encode([$link]);
    $ext    = pathinfo($link, PATHINFO_EXTENSION) ?: 'mp4';
    
    $nome   = $_POST['final_title'] ?? pathinfo($link, PATHINFO_FILENAME);
    $icon   = $_POST['final_icon'] ?? "";
    $rating = $_POST['final_rating'] ?? 0;
    $notes  = $_POST['final_plot'] ?? "";

    if(empty($nome)) $nome = "Filme Sem Nome";

    $sql = "INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, direct_source, target_container, added, rating, notes) 
            VALUES (2, ?, ?, ?, ?, 1, ?, UNIX_TIMESTAMP(), ?, ?)";
    
    $pdo->prepare($sql)->execute([$cat_id, $nome, $source, $icon, $ext, $rating, $notes]);
    echo "<script>window.location='filmes.php';</script>";
}

// B. EDITAR (ATUALIZADO PARA SALVAR METADADOS)
if(isset($_POST['edit_movie'])) {
    $id = (int)$_POST['edit_id'];
    $nome = $_POST['edit_name'];
    $link = $_POST['edit_link'];
    $cat_id = json_encode([(int)$_POST['edit_category']]);
    $source = json_encode([$link]);
    
    $icon = $_POST['edit_icon_final'];
    $rating = $_POST['edit_rating_final'] ?? 0;
    $notes = $_POST['edit_plot_final'] ?? '';

    $sql = "UPDATE streams SET stream_display_name = ?, stream_source = ?, category_id = ?, stream_icon = ?, rating = ?, notes = ? WHERE id = ?";
    $pdo->prepare($sql)->execute([$nome, $source, $cat_id, $icon, $rating, $notes, $id]);
    echo "<script>window.location='filmes.php';</script>";
}

// C. EXCLUIR
if(isset($_GET['del'])) {
    $id = (int)$_GET['del'];
    $pdo->query("DELETE FROM streams WHERE id = $id AND type = 2");
    echo "<script>window.location='filmes.php';</script>";
}

// LISTAGEM
$busca = $_GET['busca'] ?? '';
$pagina = $_GET['pagina'] ?? 1;
$limite = isset($_GET['limite']) ? (int)$_GET['limite'] : 50; 
if($limite < 1) $limite = 50;

$inicio = ($pagina - 1) * $limite;

$sql_base = "WHERE type = 2";
if($busca) $sql_base .= " AND stream_display_name LIKE :busca";

$stmt_count = $pdo->prepare("SELECT count(*) FROM streams $sql_base");
if($busca) $stmt_count->bindValue(':busca', "%$busca%");
$stmt_count->execute();
$total_registros = $stmt_count->fetchColumn();

$sql = "SELECT id, stream_display_name, stream_source, stream_icon, added, category_id, rating, notes 
        FROM streams $sql_base ORDER BY id DESC LIMIT $inicio, $limite";
$stmt = $pdo->prepare($sql);
if($busca) $stmt->bindValue(':busca', "%$busca%");
$stmt->execute();
$filmes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
    .xui-card { background: #fff; border-radius: 6px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); border: 1px solid #e1e4e8; }
    .movie-poster-row { width: 45px; height: 68px; object-fit: cover; border-radius: 4px; background: #eee; }
    
    /* Grid de Resultados TMDB */
    .tmdb-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(120px, 1fr)); gap: 15px; padding: 10px; }
    .tmdb-item { cursor: pointer; position: relative; border-radius: 6px; overflow: hidden; transition: transform 0.2s; background: #000; }
    .tmdb-item:hover { transform: scale(1.05); z-index: 10; box-shadow: 0 5px 15px rgba(0,0,0,0.3); }
    .tmdb-item.selected { outline: 3px solid #28a745; transform: scale(1.02); }
    .tmdb-poster { width: 100%; aspect-ratio: 2/3; object-fit: cover; opacity: 0.8; transition: 0.2s; }
    .tmdb-item:hover .tmdb-poster, .tmdb-item.selected .tmdb-poster { opacity: 1; }
    .tmdb-overlay { position: absolute; bottom: 0; left: 0; right: 0; background: linear-gradient(to top, rgba(0,0,0,0.9), transparent); color: #fff; padding: 40px 5px 5px 5px; font-size: 11px; text-align: center; pointer-events: none; }
    .tmdb-year { font-size: 10px; color: #ffc107; font-weight: bold; }
    
    .tmdb-wrapper { height: 450px; overflow-y: auto; background: #fff; border: 1px solid #dee2e6; border-radius: 6px; }
</style>

<div class="container-fluid py-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0 text-dark">Gerenciar Filmes</h4>
            <small class="text-muted">Total: <?= $total_registros ?></small>
        </div>
        <div>
            <form class="d-inline-block me-2" method="GET">
                <div class="input-group">
                    <select name="limite" class="form-select bg-light" style="max-width: 90px;" onchange="this.form.submit()">
                        <?php 
                        $opcoes = [10, 20, 50, 100, 200, 500, 1000];
                        foreach($opcoes as $op) {
                            $selected = ($limite == $op) ? 'selected' : '';
                            echo "<option value='$op' $selected>$op</option>";
                        }
                        ?>
                    </select>
                    <input type="text" name="busca" class="form-control" placeholder="Buscar..." value="<?= htmlspecialchars($busca) ?>">
                    <button class="btn btn-secondary"><i class="fas fa-search"></i></button>
                </div>
            </form>
            <button class="btn btn-success fw-bold" data-bs-toggle="modal" data-bs-target="#modalAdd">
                <i class="fas fa-plus me-2"></i> Adicionar Filme
            </button>
        </div>
    </div>

    <div class="xui-card">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light text-muted text-uppercase small">
                    <tr>
                        <th class="ps-3">ID</th>
                        <th>Capa</th>
                        <th>Título / Link</th>
                        <th>Nota</th>
                        <th class="text-end pe-3">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($filmes as $f): 
                        $source = json_decode($f['stream_source']);
                        $link = is_array($source) ? $source[0] : $f['stream_source'];
                        $link = str_replace(['[',']','"'], '', $link);
                        $capa = $f['stream_icon'] ?: 'https://via.placeholder.com/45x68?text=X';
                    ?>
                    <tr>
                        <td class="ps-3 text-muted">#<?= $f['id'] ?></td>
                        <td><img src="<?= $capa ?>" class="movie-poster-row" onerror="this.src='https://via.placeholder.com/45x68?text=Erro'"></td>
                        <td>
                            <div class="fw-bold text-dark"><?= $f['stream_display_name'] ?></div>
                            <div class="text-muted small text-truncate" style="max-width: 350px;">
                                <i class="fas fa-link text-info me-1"></i> <?= $link ?>
                            </div>
                        </td>
                        <td><span class="badge bg-light text-dark border"><?= $f['rating'] > 0 ? $f['rating'] : '-' ?></span></td>
                        <td class="text-end pe-3">
                            <button class="btn btn-sm btn-primary" onclick="abrirPlayer('<?= $link ?>')"><i class="fas fa-play"></i></button>
                            <button class="btn btn-sm btn-warning text-white" 
                                onclick='prepararEdicao(<?= json_encode($f) ?>, "<?= $link ?>")'>
                                <i class="fas fa-pen"></i>
                            </button>
                            <a href="?del=<?= $f['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Apagar?')"><i class="fas fa-trash"></i></a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="modalAdd" data-bs-backdrop="static">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white py-2">
                <h6 class="modal-title"><i class="fas fa-magic me-2"></i>Adicionar Filme</h6>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body bg-light">
                <form method="POST">
                    <input type="hidden" name="add_movie" value="1">
                    <input type="hidden" name="final_title" id="final_title">
                    <input type="hidden" name="final_icon" id="final_icon">
                    <input type="hidden" name="final_rating" id="final_rating">
                    <input type="hidden" name="final_plot" id="final_plot">

                    <div class="row g-3">
                        <div class="col-lg-4">
                            <div class="bg-white p-3 rounded shadow-sm border">
                                <label class="fw-bold small text-muted">1. Link do Arquivo</label>
                                <div class="input-group mb-2">
                                    <input type="text" id="videoLink" name="link" class="form-control" placeholder="http://..." required onchange="detectarNome()">
                                    <button class="btn btn-primary" type="button" onclick="detectarNome()"><i class="fas fa-sync-alt"></i></button>
                                </div>
                                
                                <label class="fw-bold small text-muted">2. Busca TMDB</label>
                                <div class="input-group mb-3">
                                    <input type="text" id="termBusca" class="form-control fw-bold text-primary">
                                    <button class="btn btn-success" type="button" onclick="buscarTMDB('add')">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>

                                <label class="fw-bold small text-muted">3. Categoria</label>
                                <select name="category_id" class="form-select mb-3" required>
                                    <option value="">Selecione...</option>
                                    <?php foreach($categorias as $cat): ?>
                                        <option value="<?= $cat['id'] ?>"><?= $cat['category_name'] ?></option>
                                    <?php endforeach; ?>
                                </select>

                                <div class="d-grid">
                                    <button type="submit" class="btn btn-dark fw-bold py-2">SALVAR</button>
                                </div>
                            </div>

                            <div class="mt-3 p-3 bg-white border rounded">
                                <h6 class="small fw-bold border-bottom pb-2">Pré-visualização</h6>
                                <div class="d-flex">
                                    <img id="view_poster" src="https://via.placeholder.com/60x90" style="width:60px; height:90px; object-fit:cover" class="rounded me-2">
                                    <div class="small">
                                        <div class="fw-bold text-dark" id="view_title">...</div>
                                        <div class="text-warning"><i class="fas fa-star"></i> <span id="view_rating">-</span></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div id="gridResultados" class="tmdb-grid tmdb-wrapper">
                                <div class="text-center text-muted py-5">Resultados aparecerão aqui...</div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEdit">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark py-2">
                <h6 class="modal-title"><i class="fas fa-pen me-2"></i>Editar Filme</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body bg-light">
                <form method="POST">
                    <input type="hidden" name="edit_movie" value="1">
                    <input type="hidden" name="edit_id" id="edit_id">
                    
                    <input type="hidden" name="edit_icon_final" id="edit_icon_final">
                    <input type="hidden" name="edit_rating_final" id="edit_rating_final">
                    <input type="hidden" name="edit_plot_final" id="edit_plot_final">

                    <div class="row g-3">
                        <div class="col-lg-4">
                            <div class="bg-white p-3 rounded border shadow-sm h-100">
                                <label class="small fw-bold text-muted">Link do Vídeo</label>
                                <input type="text" name="edit_link" id="edit_link" class="form-control mb-3">

                                <label class="small fw-bold text-muted">Nome / Termo de Busca</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="edit_name" id="edit_name" class="form-control fw-bold text-primary">
                                    <button class="btn btn-warning" type="button" onclick="buscarTMDB('edit')">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>

                                <label class="small fw-bold text-muted">Categoria</label>
                                <select name="edit_category" id="edit_category" class="form-select mb-3">
                                    <?php foreach($categorias as $cat): ?>
                                        <option value="<?= $cat['id'] ?>"><?= $cat['category_name'] ?></option>
                                    <?php endforeach; ?>
                                </select>

                                <button type="submit" class="btn btn-primary w-100 fw-bold py-2 mb-3">
                                    <i class="fas fa-save me-2"></i> SALVAR MUDANÇAS
                                </button>
                                
                                <div class="text-center p-2 border rounded bg-light">
                                    <small class="d-block text-muted mb-1">Capa Atual / Nova</small>
                                    <img id="edit_view_poster" src="" style="width: 80px; height: 120px; object-fit: cover; border-radius: 4px;">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <h6 class="small fw-bold text-muted mb-2">Selecione a Capa no TMDB:</h6>
                            <div id="editGridResultados" class="tmdb-grid tmdb-wrapper">
                                <div class="text-center text-muted pt-5">Faça uma busca para alterar a capa/info.</div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
var tmdbCache = [];

// Limpa nome de arquivo para busca (ex: "Filme.2023.mp4" -> "Filme")
function limparNomeArquivo(nome) {
    if(!nome) return "";
    var limpo = nome;
    // Tenta remover extensão se parecer arquivo
    if(limpo.includes('.')) limpo = limpo.replace(/\.[^/.]+$/, "");
    
    limpo = limpo.replace(/\(\d{4}\)/g, ''); // Remove (1990)
    limpo = limpo.replace(/\[.*?\]/g, '');   // Remove [texto]
    limpo = limpo.replace(/[._\-]/g, ' ');   // Troca . _ - por espaço
    limpo = limpo.replace(/\s{2,}/g, ' ').trim(); // Remove espaços duplos
    return limpo;
}

function detectarNome() {
    var url = $('#videoLink').val();
    if(!url) return;
    try { url = decodeURIComponent(url); } catch(e){}
    var filename = url.substring(url.lastIndexOf('/')+1);
    var nome = limparNomeArquivo(filename);
    
    $('#termBusca').val(nome);
    if(nome.length > 2) buscarTMDB('add');
}

function buscarTMDB(modo) {
    var termo = (modo === 'add') ? $('#termBusca').val() : $('#edit_name').val();
    var gridId = (modo === 'add') ? '#gridResultados' : '#editGridResultados';
    
    $(gridId).html('<div class="text-center p-5"><div class="spinner-border text-primary"></div></div>');

    $.ajax({
        url: 'filmes.php', // Chama o próprio arquivo
        type: 'POST',
        data: { ajax_action: 'search', term: termo },
        success: function(resp) {
            try {
                var json = JSON.parse(resp);
                if(json.results && json.results.length > 0) {
                    tmdbCache = json.results; 
                    renderizarGrid(json.results, modo);
                } else {
                    $(gridId).html('<div class="text-center p-5 text-muted">Nenhum filme encontrado para "'+termo+'".</div>');
                }
            } catch(e) {
                $(gridId).html('<div class="text-center p-5 text-danger">Erro na API.</div>');
            }
        }
    });
}

function renderizarGrid(filmes, modo) {
    var html = '';
    var gridId = (modo === 'add') ? '#gridResultados' : '#editGridResultados';
    
    filmes.forEach(function(f, index) {
        var poster = f.poster_path ? 'https://image.tmdb.org/t/p/w200' + f.poster_path : 'https://via.placeholder.com/200x300?text=Sem+Capa';
        var ano = f.release_date ? f.release_date.split('-')[0] : '';
        
        html += `
            <div class="tmdb-item" onclick="selecionarFilme(${index}, '${modo}', this)">
                <img src="${poster}" class="tmdb-poster">
                <div class="tmdb-overlay">
                    <div class="fw-bold text-truncate">${f.title}</div>
                    <div class="tmdb-year">${ano}</div>
                </div>
            </div>
        `;
    });
    
    $(gridId).html(html);
    // Auto seleciona o primeiro se for ADD
    if(modo === 'add') setTimeout(() => { $(gridId).find('.tmdb-item').first().trigger('click'); }, 200);
}

function selecionarFilme(index, modo, elemento) {
    var f = tmdbCache[index];
    if(!f) return;

    $('.tmdb-item').removeClass('selected');
    $(elemento).addClass('selected');

    var poster = f.poster_path ? 'https://image.tmdb.org/t/p/w300' + f.poster_path : '';
    var rating = f.vote_average;
    var plot = f.overview;
    var title = f.title;

    if(modo === 'add') {
        $('#final_title').val(title);
        $('#final_icon').val(poster);
        $('#final_rating').val(rating);
        $('#final_plot').val(plot);
        $('#view_poster').attr('src', poster || 'https://via.placeholder.com/60x90');
        $('#view_title').text(title);
        $('#view_rating').text(rating);
        $('#termBusca').val(title); 
    } else {
        // MODO EDITAR: Atualiza os campos e a preview
        $('#edit_name').val(title);
        $('#edit_icon_final').val(poster);
        $('#edit_rating_final').val(rating);
        $('#edit_plot_final').val(plot);
        $('#edit_view_poster').attr('src', poster);
    }
}

function prepararEdicao(filme, link) {
    $('#edit_id').val(filme.id);
    $('#edit_link').val(link);
    $('#edit_name').val(filme.stream_display_name);
    
    // Tira caracteres extras da categoria se tiver ["25"]
    var catClean = filme.category_id.toString().replace(/[\[\]"]/g, '');
    $('#edit_category').val(catClean);
    
    // Popula dados atuais nos inputs ocultos (IMPORTANTE para não perder info se não buscar nada)
    $('#edit_icon_final').val(filme.stream_icon);
    $('#edit_rating_final').val(filme.rating);
    $('#edit_plot_final').val(filme.notes);
    $('#edit_view_poster').attr('src', filme.stream_icon);

    // Limpa a grid anterior
    $('#editGridResultados').html('<div class="text-center pt-5 text-muted">Buscando...</div>');
    
    var modal = new bootstrap.Modal(document.getElementById('modalEdit'));
    modal.show();
    
    // Tenta limpar o nome para buscar melhor (ex: tira .mp4)
    var nomeLimpo = limparNomeArquivo(filme.stream_display_name);
    $('#edit_name').val(nomeLimpo); // Coloca o nome limpo no input
    
    // Faz a busca automática
    buscarTMDB('edit');
}

function abrirPlayer(url) {
    var win = window.open('', '_blank');
    win.document.write('<body style="margin:0;background:#000;display:flex;justify-content:center;align-items:center;height:100vh;">' +
        '<video controls autoplay style="max-width:100%;max-height:100%"><source src="'+url+'" type="video/mp4"></video></body>');
}
</script>
