<?php
require 'config.php'; 
require 'header.php'; 

// --- SEGURANÇA: APENAS ADMIN ---
$grupo = $_SESSION['group_id'] ?? 0;
if ($grupo != 1) { 
    echo "<script>window.location='index.php';</script>"; 
    exit; 
}

// ====================================================================
// --- LÓGICA DE AÇÕES ---
// ====================================================================

$mensagem = '';
$tipo_msg = '';

// Ação 1: Desconectar Conexão Ativa (lines_live)
if (isset($_GET['kill_live'])) {
    $activity_id = (int)$_GET['kill_live'];
    
    // Deleta o registro da conexão ativa
    $pdo->query("DELETE FROM lines_live WHERE activity_id = $activity_id");

    $mensagem = "Conexão ativa #$activity_id desconectada com sucesso!";
    $tipo_msg = "success";
}

// ====================================================================
// --- BUSCAR DADOS ---
// ====================================================================

// Tabela 1: Conexões Ativas (lines_live)
// Junta com a tabela 'lines' para obter o nome de usuário.
$sql_live = "
    SELECT 
        ll.activity_id, ll.user_id, ll.stream_id, ll.user_agent, ll.user_ip, ll.date_start,
        ll.container, ll.isp, ll.geoip_country_code,
        l.username, s.stream_display_name AS stream_name
    FROM lines_live ll
    LEFT JOIN `lines` l ON ll.user_id = l.id
    LEFT JOIN streams s ON ll.stream_id = s.id
    ORDER BY ll.date_start DESC";
    
$live_connections = $pdo->query($sql_live)->fetchAll(PDO::FETCH_ASSOC);

// Tabela 2: Logs de Atividade (lines_activity) - Limitado a 500 para não travar
$sql_logs = "
    SELECT 
        la.activity_id, la.user_id, la.stream_id, la.user_ip, la.date_start, la.date_end,
        l.username, s.stream_display_name AS stream_name
    FROM lines_activity la
    LEFT JOIN `lines` l ON la.user_id = l.id
    LEFT JOIN streams s ON la.stream_id = s.id
    ORDER BY la.date_start DESC
    LIMIT 500";
    
$activity_logs = $pdo->query($sql_logs)->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
    .k-card { background: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 25px; }
    .table thead th { font-size: 0.75rem; text-transform: uppercase; color: #6c757d; background-color: #f8f9fa; }
    .nav-pills .nav-link { font-weight: bold; }
    code { font-size: 0.8rem; background-color: #f0f0f0; padding: 2px 4px; border-radius: 3px; }
    .status-active { color: #198754; font-weight: bold; }
    .status-ended { color: #dc3545; font-weight: bold; }
</style>

<div class="container-fluid py-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0 text-dark"><i class="fas fa-signal me-2 text-success"></i>Gerenciar Atividade e Conexões</h4>
    </div>

    <?php if (isset($mensagem) && !empty($mensagem)): ?>
    <div class="alert alert-<?= $tipo_msg ?> alert-dismissible fade show" role="alert">
        <?= $mensagem ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="pill" data-bs-target="#pills-live" type="button">
                Conexões Ativas (<?= count($live_connections) ?>)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-logs" type="button">
                Logs de Conexão (<?= count($activity_logs) ?>)
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pills-tabContent">
        
        <div class="tab-pane fade show active" id="pills-live" role="tabpanel">
            <div class="k-card">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3" width="5%">ID</th>
                                <th width="15%">Usuário</th>
                                <th width="20%">Stream Assistida</th>
                                <th width="10%">IP / País</th>
                                <th width="15%">Início da Conexão</th>
                                <th width="25%">Dispositivo (UA)</th>
                                <th width="10%" class="text-end pe-3">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($live_connections as $c): 
                                $start_time = date('H:i:s', $c['date_start']);
                                $country = $c['geoip_country_code'] ?: '??';
                                $ip_link = "https://www.iplocation.net/?query={$c['user_ip']}";
                            ?>
                            <tr>
                                <td class="ps-3 text-muted small">#<?= $c['activity_id'] ?></td>
                                <td><span class="fw-bold"><?= $c['username'] ?: "ID: {$c['user_id']}" ?></span></td>
                                <td><?= $c['stream_name'] ?: "ID: {$c['stream_id']}" ?></td>
                                <td>
                                    <span class="badge bg-secondary"><?= $country ?></span>
                                    <a href="<?= $ip_link ?>" target="_blank" title="Ver IP no mapa"><?= $c['user_ip'] ?></a>
                                </td>
                                <td><?= $start_time ?></td>
                                <td><small class="text-muted" title="<?= htmlspecialchars($c['user_agent']) ?>"><?= $c['container'] ?: substr($c['user_agent'], 0, 40) . '...' ?></small></td>
                                <td class="text-end pe-3">
                                    <a href="?kill_live=<?= $c['activity_id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Desconectar o usuário <?= $c['username'] ?>?')">
                                        <i class="fas fa-plug"></i> Desconectar
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-logs" role="tabpanel">
            <div class="k-card">
                 <div class="p-3 bg-light">
                    <span class="text-muted small">Registros de conexões recentes (início e fim da sessão). Limite: 500 logs.</span>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3" width="10%">ID Log</th>
                                <th width="15%">Usuário</th>
                                <th width="20%">Stream</th>
                                <th width="10%">IP</th>
                                <th width="15%">Início (Date Start)</th>
                                <th width="15%">Fim (Date End)</th>
                                <th width="15%">Duração</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($activity_logs as $l): 
                                $date_start = date('Y-m-d H:i:s', $l['date_start']);
                                $date_end = ($l['date_end'] > 0) ? date('Y-m-d H:i:s', $l['date_end']) : '<span class="status-active">Em andamento</span>';
                                
                                $duration = '';
                                if ($l['date_end'] > 0) {
                                    $diff = $l['date_end'] - $l['date_start'];
                                    $duration = gmdate("H:i:s", $diff);
                                }
                            ?>
                            <tr>
                                <td class="ps-3 text-muted small">#<?= $l['activity_id'] ?></td>
                                <td><?= $l['username'] ?: "ID: {$l['user_id']}" ?></td>
                                <td><?= $l['stream_name'] ?: "ID: {$l['stream_id']}" ?></td>
                                <td><?= $l['user_ip'] ?></td>
                                <td><?= $date_start ?></td>
                                <td><?= $date_end ?></td>
                                <td><?= $duration ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
