<?php
require 'config.php'; 
require 'header.php'; 

// --- SEGURANÇA: APENAS ADMIN ---
$grupo = $_SESSION['group_id'] ?? 0;
if ($grupo != 1) { 
    echo "<script>window.location='index.php';</script>"; 
    exit; 
}

// ====================================================================
// --- LÓGICA DE AÇÕES (Bloquear/Desbloquear) ---
// ====================================================================

// Bloquear IP Manualmente
if (isset($_POST['action']) && $_POST['action'] == 'add_ip') {
    $ip = trim($_POST['ip']);
    $notes = trim($_POST['notes']);
    
    if (filter_var($ip, FILTER_VALIDATE_IP)) {
        try {
            // CORREÇÃO: Removida a coluna 'blocked' da inserção e usado o campo 'date' para registro
            $sql = "INSERT INTO blocked_ips (ip, notes, date) VALUES (?, ?, UNIX_TIMESTAMP())";
            $pdo->prepare($sql)->execute([$ip, $notes]);
            $mensagem = "IP $ip bloqueado com sucesso!";
            $tipo_msg = "success";
        } catch (PDOException $e) {
            $mensagem = "Erro: IP já existe ou falha no banco de dados.";
            $tipo_msg = "danger";
        }
    } else {
        $mensagem = "Erro: Endereço IP inválido.";
        $tipo_msg = "danger";
    }
}

// Desbloquear IP
if (isset($_GET['del_ip'])) {
    $id = (int)$_GET['del_ip'];
    $pdo->query("DELETE FROM blocked_ips WHERE id = $id");
    $mensagem = "IP desbloqueado com sucesso!";
    $tipo_msg = "success";
}

// ====================================================================
// --- BUSCAR DADOS ---
// ====================================================================

// Tabela 1: IPs Bloqueados
// CORREÇÃO: Removida a coluna 'blocked' da seleção, pois não existe em blocked_ips (Foto 1000650714.jpg)
$ips = $pdo->query("SELECT id, ip, notes, FROM_UNIXTIME(date) as date_added FROM blocked_ips ORDER BY date DESC")->fetchAll(PDO::FETCH_ASSOC);

// Tabela 2: User Agents Bloqueados (Foto 1000650717.jpg)
$uas = $pdo->query("SELECT id, user_agent, attempts_blocked FROM blocked_user_agents ORDER BY user_agent ASC")->fetchAll(PDO::FETCH_ASSOC);

// Tabela 3: ASNs/ISPs Bloqueados (Foto 1000650713.jpg)
// Mantida a coluna 'blocked' pois existe nessa tabela
$asns = $pdo->query("SELECT id, asn, isp, domain, country, num_ips, blocked FROM blocked_asns ORDER BY asn ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
    .k-card { background: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 25px; }
    .table thead th { font-size: 0.75rem; text-transform: uppercase; color: #6c757d; background-color: #f8f9fa; }
    .nav-pills .nav-link { font-weight: bold; }
</style>

<div class="container-fluid py-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0 text-dark"><i class="fas fa-shield-alt me-2 text-danger"></i>Gerenciar Bloqueios</h4>
        <button class="btn btn-danger fw-bold shadow-sm" data-bs-toggle="modal" data-bs-target="#modalAddIP">
            <i class="fas fa-ban me-2"></i> Bloquear IP Manual
        </button>
    </div>

    <?php if (isset($mensagem)): ?>
    <div class="alert alert-<?= $tipo_msg ?> alert-dismissible fade show" role="alert">
        <?= $mensagem ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="pill" data-bs-target="#pills-ips" type="button">
                Bloqueio por IP (<?= count($ips) ?>)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-uas" type="button">
                Bloqueio por User Agent (<?= count($uas) ?>)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-asns" type="button">
                Bloqueio por ASN/ISP (<?= count($asns) ?>)
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pills-tabContent">
        
        <div class="tab-pane fade show active" id="pills-ips" role="tabpanel">
            <div class="k-card">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3" width="10%">ID</th>
                                <th width="20%">Endereço IP</th>
                                <th width="40%">Notas</th>
                                <th width="15%">Adicionado em</th>
                                <th width="15%" class="text-end pe-3">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($ips as $i): ?>
                            <tr>
                                <td class="ps-3 text-muted small">#<?= $i['id'] ?></td>
                                <td><span class="badge bg-dark fw-bold"><?= $i['ip'] ?></span></td>
                                <td><?= empty($i['notes']) ? 'N/A' : $i['notes'] ?></td>
                                <td><?= $i['date_added'] ?></td>
                                <td class="text-end pe-3">
                                    <a href="?del_ip=<?= $i['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Deseja realmente desbloquear este IP?')">
                                        <i class="fas fa-trash"></i> Desbloquear
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-uas" role="tabpanel">
            <div class="k-card">
                 <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3" width="5%">ID</th>
                                <th width="65%">User Agent Bloqueado</th>
                                <th width="10%">Tentativas</th>
                                <th width="20%" class="text-end pe-3">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($uas as $u): ?>
                            <tr>
                                <td class="ps-3 text-muted small">#<?= $u['id'] ?></td>
                                <td><code><?= $u['user_agent'] ?></code></td>
                                <td><?= $u['attempts_blocked'] ?></td>
                                <td class="text-end pe-3">
                                     <button class="btn btn-sm btn-outline-danger" disabled><i class="fas fa-trash"></i> Desbloquear</button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <div class="p-3 text-muted small border-top">
                    *Esta lista é preenchida automaticamente pelo sistema (ou via API) para bloquear players não autorizados.
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-asns" role="tabpanel">
             <div class="k-card">
                 <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3" width="10%">ASN</th>
                                <th width="25%">ISP / Domínio</th>
                                <th width="15%">País</th>
                                <th width="15%">IPs Bloqueados</th>
                                <th width="15%">Status</th>
                                <th width="20%" class="text-end pe-3">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($asns as $a): ?>
                            <tr>
                                <td class="ps-3 text-muted small"><?= $a['asn'] ?></td>
                                <td><?= $a['isp'] ?> / <?= $a['domain'] ?></td>
                                <td><?= $a['country'] ?></td>
                                <td><?= $a['num_ips'] ?></td>
                                <td><span class="badge bg-<?= $a['blocked'] ? 'danger' : 'success' ?>"><?= $a['blocked'] ? 'Bloqueado' : 'Automático' ?></span></td>
                                <td class="text-end pe-3">
                                     <button class="btn btn-sm btn-outline-primary" disabled><i class="fas fa-sync"></i> Gerenciar</button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>

<div class="modal fade" id="modalAddIP" tabindex="-1">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title"><i class="fas fa-ban me-2"></i> Bloquear Endereço IP</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="add_ip">

                    <div class="mb-3">
                        <label class="form-label fw-bold">Endereço IP (ou Range)</label>
                        <input type="text" name="ip" class="form-control" placeholder="Ex: 192.168.1.1 ou 1.1.1.0/24" required>
                        <div class="form-text">Adicione um IP único ou um bloco CIDR (ex: /24).</div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Notas (Opcional)</label>
                        <textarea name="notes" class="form-control" rows="2" placeholder="Motivo do bloqueio..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-danger fw-bold"><i class="fas fa-lock me-1"></i> Bloquear</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
