<?php
require 'config.php'; 
require 'header.php'; 

// --- SEGURANÇA: APENAS ADMIN ---
$grupo = $_SESSION['group_id'] ?? 0;
if ($grupo != 1) { 
    echo "<script>window.location='index.php';</script>"; 
    exit; 
}

// ====================================================================
// --- LÓGICA DE AÇÕES ---
// ====================================================================

$mensagem = '';
$tipo_msg = '';

// Ação 1: Deletar Dispositivo
if (isset($_GET['del_device'])) {
    $id = (int)$_GET['del_device'];
    
    $pdo->query("DELETE FROM devices WHERE device_id = $id");

    $mensagem = "Dispositivo #$id deletado com sucesso!";
    $tipo_msg = "success";
}

// Ação 2: Adicionar Novo Dispositivo
if (isset($_POST['action']) && $_POST['action'] == 'add_device') {
    $device_name = trim($_POST['device_name']);
    $device_key = trim($_POST['device_key']);
    $device_filename = trim($_POST['device_filename']);
    $device_header = $_POST['device_header'];
    $device_conf = $_POST['device_conf'];
    $device_footer = $_POST['device_footer'];
    $default_output = (int)$_POST['default_output'];

    if (!empty($device_name) && !empty($device_key)) {
        try {
            $sql = "INSERT INTO devices (device_name, device_key, device_filename, device_header, device_conf, device_footer, default_output) 
                    VALUES (?, ?, ?, ?, ?, ?, ?)";
            $pdo->prepare($sql)->execute([
                $device_name, $device_key, $device_filename, $device_header, 
                $device_conf, $device_footer, $default_output
            ]);

            $mensagem = "Dispositivo '$device_name' adicionado com sucesso!";
            $tipo_msg = "success";
        } catch (PDOException $e) {
            $mensagem = "Erro: Falha no banco de dados ao adicionar dispositivo.";
            $tipo_msg = "danger";
        }
    } else {
        $mensagem = "Erro: Nome e Chave do Dispositivo são obrigatórios.";
        $tipo_msg = "danger";
    }
}

// Ação 3: Editar Dispositivo Existente
if (isset($_POST['action']) && $_POST['action'] == 'edit_device') {
    $id = (int)$_POST['edit_id'];
    $device_name = trim($_POST['edit_device_name']);
    $device_key = trim($_POST['edit_device_key']);
    $device_filename = trim($_POST['edit_device_filename']);
    $device_header = $_POST['edit_device_header'];
    $device_conf = $_POST['edit_device_conf'];
    $device_footer = $_POST['edit_device_footer'];
    $default_output = (int)$_POST['edit_default_output'];

    if ($id > 0 && !empty($device_name) && !empty($device_key)) {
        $sql = "UPDATE devices SET device_name=?, device_key=?, device_filename=?, device_header=?, device_conf=?, device_footer=?, default_output=? WHERE device_id=?";
        $pdo->prepare($sql)->execute([
            $device_name, $device_key, $device_filename, $device_header, 
            $device_conf, $device_footer, $default_output, $id
        ]);
        
        $mensagem = "Dispositivo '$device_name' editado com sucesso!";
        $tipo_msg = "success";
    } else {
        $mensagem = "Erro: ID, Nome ou Chave do Dispositivo inválidos na edição.";
        $tipo_msg = "danger";
    }
}

// ====================================================================
// --- BUSCAR DADOS ---
// ====================================================================

// Tabela: Dispositivos (devices)
$devices = $pdo->query("SELECT * FROM devices ORDER BY device_name ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
    .k-card { background: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 25px; }
    .table thead th { font-size: 0.75rem; text-transform: uppercase; color: #6c757d; background-color: #f8f9fa; }
    .nav-pills .nav-link { font-weight: bold; }
    code { font-size: 0.8rem; background-color: #f0f0f0; padding: 2px 4px; border-radius: 3px; }
    textarea.form-control { font-family: monospace; font-size: 0.8rem; }
    .btn-action-group { white-space: nowrap; }
</style>

<div class="container-fluid py-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0 text-dark"><i class="fas fa-mobile-alt me-2 text-info"></i>Gerenciar Dispositivos/APIs</h4>
        <button class="btn btn-info text-white fw-bold shadow-sm" data-bs-toggle="modal" data-bs-target="#modalAddDevice">
            <i class="fas fa-plus me-2"></i> Adicionar Dispositivo
        </button>
    </div>

    <?php if (isset($mensagem) && !empty($mensagem)): ?>
    <div class="alert alert-<?= $tipo_msg ?> alert-dismissible fade show" role="alert">
        <?= $mensagem ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <div class="k-card">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead>
                    <tr>
                        <th class="ps-3" width="5%">ID</th>
                        <th width="15%">Nome</th>
                        <th width="10%">Chave (Key)</th>
                        <th width="15%">Nome do Arquivo</th>
                        <th width="40%">Estrutura (Header/Conf/Footer)</th>
                        <th width="10%">Output Padrão</th>
                        <th width="10%" class="text-end pe-3">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($devices as $d): ?>
                    <tr>
                        <td class="ps-3 text-muted small">#<?= $d['device_id'] ?></td>
                        <td><span class="fw-bold"><?= $d['device_name'] ?></span></td>
                        <td><code><?= $d['device_key'] ?></code></td>
                        <td><?= $d['device_filename'] ?></td>
                        <td>
                            <small class="text-muted">Header: <?= substr($d['device_header'], 0, 30) ?>...</small><br>
                            <small class="text-muted">Conf: <?= substr($d['device_conf'], 0, 30) ?>...</small>
                        </td>
                        <td>
                            <span class="badge bg-secondary"><?= $d['default_output'] ?></span>
                        </td>
                        <td class="text-end pe-3 btn-action-group">
                            <button class="btn btn-sm btn-outline-info me-1" 
                                onclick='abrirModalEdicao(<?= json_encode($d) ?>)'>
                                <i class="fas fa-pen"></i>
                            </button>
                            <a href="?del_device=<?= $d['device_id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Deseja realmente deletar o dispositivo <?= $d['device_name'] ?>?')">
                                <i class="fas fa-trash"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="modalAddDevice" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title"><i class="fas fa-plus me-2"></i> Adicionar Novo Dispositivo/API</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="add_device">

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Nome do Dispositivo</label>
                            <input type="text" name="device_name" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Chave de Identificação (Key)</label>
                            <input type="text" name="device_key" class="form-control" required>
                            <div class="form-text">Usado na URL (ex: &device_key=X).</div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Nome do Arquivo (Ex: m3u)</label>
                            <input type="text" name="device_filename" class="form-control" placeholder="ex: get.php?username=...&output=m3u">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Output Padrão (Ex: 0, 1, 2)</label>
                            <input type="number" name="default_output" class="form-control" value="0">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Header (Cabeçalho da Playlist/API)</label>
                        <textarea name="device_header" class="form-control" rows="3" placeholder="#EXTM3U... ou Código de API"></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Configuração/Formato (Conf)</label>
                        <textarea name="device_conf" class="form-control" rows="3" placeholder="#EXTINF:-1 tvg-name="{NAME}"..."></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Footer (Rodapé da Playlist/API)</label>
                        <textarea name="device_footer" class="form-control" rows="3"></textarea>
                    </div>
                    
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-info text-white fw-bold"><i class="fas fa-save me-1"></i> Adicionar Dispositivo</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditDevice" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title"><i class="fas fa-pen me-2"></i> Editar Dispositivo/API</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="edit_device">
                    <input type="hidden" name="edit_id" id="edit_id">

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Nome do Dispositivo</label>
                            <input type="text" name="edit_device_name" id="edit_device_name" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Chave de Identificação (Key)</label>
                            <input type="text" name="edit_device_key" id="edit_device_key" class="form-control" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Nome do Arquivo</label>
                            <input type="text" name="edit_device_filename" id="edit_device_filename" class="form-control">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Output Padrão</label>
                            <input type="number" name="edit_default_output" id="edit_default_output" class="form-control">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Header (Cabeçalho)</label>
                        <textarea name="edit_device_header" id="edit_device_header" class="form-control" rows="3"></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Configuração/Formato (Conf)</label>
                        <textarea name="edit_device_conf" id="edit_device_conf" class="form-control" rows="3"></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Footer (Rodapé)</label>
                        <textarea name="edit_device_footer" id="edit_device_footer" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-info text-white fw-bold"><i class="fas fa-save me-1"></i> Salvar Edição</button>
                </div>
            </form>
        </div>
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    // Função para abrir o modal de edição e preencher os campos
    function abrirModalEdicao(d) {
        // Preenche os campos do formulário
        $('#edit_id').val(d.device_id);
        $('#edit_device_name').val(d.device_name);
        $('#edit_device_key').val(d.device_key);
        $('#edit_device_filename').val(d.device_filename);
        $('#edit_device_header').val(d.device_header);
        $('#edit_device_conf').val(d.device_conf);
        $('#edit_device_footer').val(d.device_footer);
        $('#edit_default_output').val(d.default_output);

        // Exibe o modal
        var modal = new bootstrap.Modal(document.getElementById('modalEditDevice'));
        modal.show();
    }
</script>
</body>
</html>
