<?php
// Inclui as configurações e segurança
require_once 'config.php';

if (!isset($is_admin) || !$is_admin) {
    die("<h2 style='color:red; text-align:center;'>Acesso negado. Apenas administradores.</h2>");
}

$arquivo_dominios = __DIR__ . '/dominios.json';
$mensagem = '';

// Processa a adição ou exclusão
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $dominios_atuais = file_exists($arquivo_dominios) ? json_decode(file_get_contents($arquivo_dominios), true) : [];
    if (!is_array($dominios_atuais)) $dominios_atuais = [];

    // Adicionar Domínio
    if (isset($_POST['adicionar']) && !empty(trim($_POST['novo_dominio']))) {
        $novo = trim(strtolower($_POST['novo_dominio']));
        $novo = str_replace(['http://', 'https://', '/'], '', $novo);
        
        if (!in_array($novo, $dominios_atuais)) {
            $dominios_atuais[] = $novo;
            file_put_contents($arquivo_dominios, json_encode(array_values($dominios_atuais)));
            $mensagem = "<div class='alert alert-success' style='padding:10px; border-radius:5px; background:#d1e7dd; color:#0f5132; text-align:center; margin-bottom:15px; border: 1px solid #badbcc;'>✅ Domínio <b>$novo</b> adicionado!</div>";
        } else {
            $mensagem = "<div class='alert alert-warning' style='padding:10px; border-radius:5px; background:#fff3cd; color:#664d03; text-align:center; margin-bottom:15px; border: 1px solid #ffecb5;'>⚠️ O domínio já está na lista.</div>";
        }
    }

    // Excluir Domínio
    if (isset($_POST['excluir']) && !empty($_POST['dominio_excluir'])) {
        $excluir = $_POST['dominio_excluir'];
        $dominios_atuais = array_filter($dominios_atuais, function($d) use ($excluir) {
            return $d !== $excluir;
        });
        file_put_contents($arquivo_dominios, json_encode(array_values($dominios_atuais)));
        $mensagem = "<div class='alert alert-danger' style='padding:10px; border-radius:5px; background:#f8d7da; color:#842029; text-align:center; margin-bottom:15px; border: 1px solid #f5c2c7;'>🗑️ Domínio <b>$excluir</b> removido.</div>";
    }
}

// Carrega a lista atualizada
$dominios_atuais = file_exists($arquivo_dominios) ? json_decode(file_get_contents($arquivo_dominios), true) : [];
if (!is_array($dominios_atuais)) $dominios_atuais = [];

// =========================================================
// PUXA O MENU LATERAL E O CABEÇALHO DO SEU PAINEL
// =========================================================
if (file_exists('header.php')) { include 'header.php'; }
if (file_exists('sidebar.php')) { include 'sidebar.php'; }
?>

<style>
    /* Fundo do card agora é branco */
    .meu-card { background: #ffffff; border-radius: 8px; padding: 25px; color: #212529; margin-top: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.08); width: 100%; box-sizing: border-box; border: 1px solid #eaeaea; }
    
    .input-group-mobile { display: flex; flex-wrap: wrap; gap: 10px; margin-bottom: 20px; }
    
    /* Inputs agora são claros com borda suave */
    .input-group-mobile input { flex: 1 1 200px; padding: 12px; border-radius: 5px; border: 1px solid #ced4da; background: #ffffff; color: #212529; font-size: 16px; width: 100%; box-sizing: border-box; }
    
    .input-group-mobile button { flex: 0 1 auto; padding: 12px 20px; border-radius: 5px; border: none; font-weight: bold; cursor: pointer; white-space: nowrap; font-size: 16px; transition: background-color 0.2s; }
    .btn-add { background: #0d6efd; color: #fff; } .btn-add:hover { background: #0b5ed7; }
    .btn-del { background: #dc3545; color: #fff; padding: 8px 15px; border: none; border-radius: 4px; cursor: pointer; font-size: 14px; transition: background-color 0.2s; } .btn-del:hover { background: #bb2d3b; }
    
    .lista-dominios { list-style: none; padding: 0; margin: 0; }
    
    /* Itens da lista agora são cinza claro */
    .lista-dominios li { background: #f8f9fa; margin-bottom: 12px; padding: 15px; border-radius: 5px; display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px; border-left: 4px solid #0d6efd; border: 1px solid #e9ecef; border-left-width: 4px; }
    
    .dominio-texto { word-break: break-all; font-size: 16px; flex: 1; color: #212529; }
    
    /* Regras específicas para a tela do Celular */
    @media (max-width: 768px) {
        .meu-card { padding: 15px; margin-top: 10px; }
        .input-group-mobile button { flex: 1 1 100%; width: 100%; }
        .lista-dominios li { flex-direction: column; align-items: flex-start; }
        .btn-del { width: 100%; text-align: center; padding: 12px; }
    }
</style>

<div class="content-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12 col-12">
                <div class="meu-card">
                    <h3 style="text-align:center; margin-bottom: 10px; font-size: 22px; color: #212529;">🌐 Gerenciar Domínios</h3>
                    <p style="text-align:center; color:#6c757d; font-size: 14px; margin-bottom: 25px;">
                        Domínios cadastrados conectarão à VPS.
                    </p>

                    <?= $mensagem ?>

                    <form method="POST" class="input-group-mobile">
                        <input type="text" name="novo_dominio" placeholder="Ex: painel.seusite.com" required autocomplete="off">
                        <button type="submit" name="adicionar" class="btn-add">+ Adicionar</button>
                    </form>

                    <ul class="lista-dominios">
                        <?php if(empty($dominios_atuais)): ?>
                            <li style="border-left: 4px solid #ffc107; background-color: #fff3cd; color: #664d03;">Nenhum domínio cadastrado.</li>
                        <?php endif; ?>
                        
                        <?php foreach ($dominios_atuais as $dom): ?>
                            <li>
                                <span class="dominio-texto"><b><?= htmlspecialchars($dom) ?></b></span>
                                <form method="POST" style="margin: 0; width: 100%; max-width: max-content;">
                                    <input type="hidden" name="dominio_excluir" value="<?= htmlspecialchars($dom) ?>">
                                    <button type="submit" name="excluir" class="btn-del" onclick="return confirm('Excluir <?= htmlspecialchars($dom) ?>?');">Remover</button>
                                </form>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// =========================================================
// PUXA O RODAPÉ DO SEU PAINEL (Se existir)
// =========================================================
if (file_exists('footer.php')) { include 'footer.php'; }
?>
