<?php
require 'config.php'; 
require 'header.php'; 

// --- SEGURANÇA: APENAS ADMIN ---
$grupo = $_SESSION['group_id'] ?? 0;
if ($grupo != 1) { 
    echo "<script>window.location='index.php';</script>"; 
    exit; 
}

// ====================================================================
// --- LÓGICA DE AÇÕES ---
// ====================================================================

$mensagem = '';
$tipo_msg = '';

// Ação 1: Deletar Arquivo EPG (Tabela e Mapeamentos)
if (isset($_GET['del_epg'])) {
    $id = (int)$_GET['del_epg'];
    
    $pdo->query("DELETE FROM epg WHERE id = $id");
    $pdo->query("DELETE FROM epg_channels WHERE epg_id = $id");

    $mensagem = "Arquivo EPG e mapeamentos associados deletados com sucesso!";
    $tipo_msg = "success";
}

// Ação 2: Adicionar Novo Arquivo EPG
if (isset($_POST['action']) && $_POST['action'] == 'add_epg_file') {
    $epg_name = trim($_POST['epg_name']);
    $epg_file = trim($_POST['epg_file']); // URL do arquivo XML
    $days_keep = (int)$_POST['days_keep'];

    if (!empty($epg_name) && filter_var($epg_file, FILTER_VALIDATE_URL)) {
        try {
            // Insere o novo EPG (Não manipulamos o 'data' nem 'offset' aqui, apenas o registro)
            $sql = "INSERT INTO epg (epg_name, epg_file, last_updated, days_keep) 
                    VALUES (?, ?, UNIX_TIMESTAMP(), ?)";
            $pdo->prepare($sql)->execute([$epg_name, $epg_file, $days_keep]);

            $mensagem = "Arquivo EPG '$epg_name' adicionado com sucesso! Lembre-se de rodar o cronjob para carregar os dados.";
            $tipo_msg = "success";
        } catch (PDOException $e) {
            $mensagem = "Erro: Falha no banco de dados ao adicionar EPG.";
            $tipo_msg = "danger";
        }
    } else {
        $mensagem = "Erro: Nome e/ou URL do EPG inválidos.";
        $tipo_msg = "danger";
    }
}

// Ação 3: Editar Arquivo EPG Existente
if (isset($_POST['action']) && $_POST['action'] == 'edit_epg_file') {
    $id = (int)$_POST['edit_id'];
    $epg_name = trim($_POST['edit_epg_name']);
    $epg_file = trim($_POST['edit_epg_file']);
    $days_keep = (int)$_POST['edit_days_keep'];

    if ($id > 0 && !empty($epg_name) && filter_var($epg_file, FILTER_VALIDATE_URL)) {
        $sql = "UPDATE epg SET epg_name = ?, epg_file = ?, days_keep = ? WHERE id = ?";
        $pdo->prepare($sql)->execute([$epg_name, $epg_file, $days_keep, $id]);
        
        $mensagem = "Arquivo EPG '$epg_name' editado com sucesso!";
        $tipo_msg = "success";
    } else {
        $mensagem = "Erro: ID, Nome ou URL do EPG inválidos na edição.";
        $tipo_msg = "danger";
    }
}

// Ação 4: Atribuir EPG em Massa aos Canais
if (isset($_POST['action']) && $_POST['action'] == 'atribuir_epg_massa') {
    $epg_id = (int)$_POST['epg_id'];
    $epg_channel_id_padrao = trim($_POST['epg_channel_id_padrao']);
    
    $stmt = $pdo->query("SELECT id FROM streams WHERE type = 1");
    $canais_streams = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $sql_update = "INSERT INTO epg_channels (epg_id, channel_id, name) 
                   VALUES (?, ?, ?) 
                   ON DUPLICATE KEY UPDATE epg_id = VALUES(epg_id), name = VALUES(name)";
    $stmt_update = $pdo->prepare($sql_update);
    
    $canais_afetados = 0;
    
    foreach($canais_streams as $canal) {
        $stream_id = $canal['id'];
        $channel_key = empty($epg_channel_id_padrao) ? $stream_id : $epg_channel_id_padrao;
        
        $stmt_update->execute([$epg_id, $stream_id, $channel_key]);
        $canais_afetados++;
    }

    $mensagem = "EPG atribuído a $canais_afetados canais em massa!";
    $tipo_msg = "success";
}

// Ação 5: Atribuição Seletiva (EPG para Canais Selecionados)
if (isset($_POST['action']) && $_POST['action'] == 'atribuir_epg_seletivo') {
    $epg_id = (int)$_POST['epg_id_seletivo'];
    $epg_channel_id = trim($_POST['epg_channel_id']);
    $canais_selecionados = $_POST['canais_selecionados'] ?? [];

    if ($epg_id > 0 && !empty($epg_channel_id) && !empty($canais_selecionados)) {
        
        $sql_update = "INSERT INTO epg_channels (epg_id, channel_id, name) 
                       VALUES (?, ?, ?) 
                       ON DUPLICATE KEY UPDATE epg_id = VALUES(epg_id), name = VALUES(name)";
        $stmt_update = $pdo->prepare($sql_update);
        
        $canais_afetados = 0;
        
        foreach($canais_selecionados as $stream_id) {
            $stream_id = (int)$stream_id;
            
            $stmt_update->execute([$epg_id, $stream_id, $epg_channel_id]);
            $canais_afetados++;
        }

        $mensagem = "EPG ID '$epg_channel_id' atribuído a $canais_afetados canais selecionados!";
        $tipo_msg = "success";
    } else {
        $mensagem = "Erro: Selecione um EPG, forneça um ID de canal EPG e selecione pelo menos um canal.";
        $tipo_msg = "danger";
    }
}

// ====================================================================
// --- BUSCAR DADOS (Para Exibição) ---
// ====================================================================

// Tabela 1: Arquivos EPG Carregados (epg)
$epg_arquivos = $pdo->query("SELECT id, epg_name, epg_file, FROM_UNIXTIME(last_updated) as last_updated, days_keep FROM epg ORDER BY epg_name ASC")->fetchAll(PDO::FETCH_ASSOC);

// Tabela 2: Canais EPG (epg_channels) - Limitado a 500 para não travar
$epg_canais = $pdo->query("
    SELECT ec.id, ec.channel_id, s.stream_display_name, e.epg_name 
    FROM epg_channels ec
    LEFT JOIN streams s ON ec.channel_id = s.id
    LEFT JOIN epg e ON ec.epg_id = e.id
    ORDER BY s.stream_display_name ASC LIMIT 500
")->fetchAll(PDO::FETCH_ASSOC);

// --- BUSCAR CANAIS (Para Atribuição Seletiva) ---
$canais_para_selecao = [];
if (isset($_POST['search_term'])) {
    $search_term = '%' . trim($_POST['search_term']) . '%';
    
    $stmt = $pdo->prepare("SELECT id, stream_display_name FROM streams WHERE type = 1 AND stream_display_name LIKE ? ORDER BY stream_display_name ASC LIMIT 100");
    $stmt->execute([$search_term]);
    $canais_para_selecao = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<style>
    .k-card { background: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 25px; }
    .table thead th { font-size: 0.75rem; text-transform: uppercase; color: #6c757d; background-color: #f8f9fa; }
    .nav-pills .nav-link { font-weight: bold; }
    .channel-list-box { max-height: 400px; overflow-y: auto; border: 1px solid #dee2e6; border-radius: 5px; padding: 10px; background: #f8f9fa; }
    .btn-action-group { white-space: nowrap; }
</style>

<div class="container-fluid py-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0 text-dark"><i class="fas fa-list-alt me-2 text-primary"></i>Gerenciar EPG (Guia de Programação)</h4>
        <button class="btn btn-primary fw-bold shadow-sm" data-bs-toggle="modal" data-bs-target="#modalAddEPG">
            <i class="fas fa-plus me-2"></i> Adicionar Arquivo EPG
        </button>
    </div>

    <?php if (isset($mensagem) && !empty($mensagem)): ?>
    <div class="alert alert-<?= $tipo_msg ?> alert-dismissible fade show" role="alert">
        <?= $mensagem ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="pill" data-bs-target="#pills-gestao" type="button">
                Arquivos EPG (<?= count($epg_arquivos) ?>)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-seletiva" type="button">
                Atribuição Seletiva
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-massa" type="button">
                Atribuição em Massa
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-canais" type="button">
                Canais Mapeados (<?= count($epg_canais) ?>)
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pills-tabContent">
        
        <div class="tab-pane fade show active" id="pills-gestao" role="tabpanel">
            <div class="k-card">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3" width="5%">ID</th>
                                <th width="25%">Nome do EPG</th>
                                <th width="35%">URL do Arquivo XML</th>
                                <th width="10%">Dias p/ Manter</th>
                                <th width="15%">Atualizado em</th>
                                <th width="10%" class="text-end pe-3">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($epg_arquivos as $e): ?>
                            <tr>
                                <td class="ps-3 text-muted small">#<?= $e['id'] ?></td>
                                <td><span class="fw-bold"><?= $e['epg_name'] ?></span></td>
                                <td><small class="text-muted"><?= $e['epg_file'] ?></small></td>
                                <td><?= $e['days_keep'] ?></td>
                                <td><?= $e['last_updated'] ?></td>
                                <td class="text-end pe-3 btn-action-group">
                                    <button class="btn btn-sm btn-outline-info me-1" 
                                        onclick='abrirModalEdicao(
                                            <?= $e['id'] ?>, 
                                            "<?= addslashes($e['epg_name']) ?>", 
                                            "<?= addslashes($e['epg_file']) ?>", 
                                            <?= $e['days_keep'] ?>
                                        )'>
                                        <i class="fas fa-pen"></i>
                                    </button>
                                    <a href="?del_epg=<?= $e['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Deseja realmente deletar este arquivo EPG e todos os mapeamentos associados?')">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-seletiva" role="tabpanel">
            <div class="k-card p-4">
                <h5 class="fw-bold mb-3">Atribuição de EPG para Canais Selecionados</h5>
                
                <form method="POST">
                    <div class="input-group mb-3">
                        <input type="text" name="search_term" class="form-control" placeholder="Pesquisar canais Live (Ex: Globo, Record, Sportv)" value="<?= $_POST['search_term'] ?? '' ?>">
                        <button class="btn btn-primary" type="submit"><i class="fas fa-search me-1"></i> Buscar Canais</button>
                    </div>
                </form>

                <?php if (isset($_POST['search_term']) && !empty($canais_para_selecao)): ?>
                    <form method="POST">
                        <input type="hidden" name="action" value="atribuir_epg_seletivo">
                        
                        <div class="row mb-3">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">1. Selecionar Arquivo EPG</label>
                                <select name="epg_id_seletivo" class="form-select" required>
                                    <option value="">Selecione o arquivo EPG...</option>
                                    <?php foreach($epg_arquivos as $e): ?>
                                        <option value="<?= $e['id'] ?>"><?= $e['epg_name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">2. EPG ID do Canal (XMLTV ID)</label>
                                <input type="text" name="epg_channel_id" class="form-control" placeholder="Ex: Globo.br" required>
                                <div class="form-text">O ID de EPG específico a ser aplicado nos canais abaixo.</div>
                            </div>
                        </div>

                        <label class="form-label fw-bold">3. Canais Encontrados (Selecione um ou mais)</label>
                        <div class="channel-list-box mb-3">
                            <?php foreach($canais_para_selecao as $c): ?>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="canais_selecionados[]" value="<?= $c['id'] ?>" id="channel_<?= $c['id'] ?>">
                                    <label class="form-check-label" for="channel_<?= $c['id'] ?>">
                                        <?= htmlspecialchars($c['stream_display_name']) ?> (ID: <?= $c['id'] ?>)
                                    </label>
                                </div>
                            <?php endforeach; ?>
                        </div>

                        <button type="submit" class="btn btn-success fw-bold">
                            <i class="fas fa-link me-1"></i> Mapear EPG nos Canais Selecionados
                        </button>
                    </form>
                <?php elseif (isset($_POST['search_term'])): ?>
                    <div class="alert alert-info">Nenhum canal encontrado com o termo "<?= htmlspecialchars(trim($_POST['search_term'])) ?>".</div>
                <?php endif; ?>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-massa" role="tabpanel">
            <div class="k-card p-4">
                <h5 class="fw-bold mb-3">Atribuição de EPG para Todos os Canais Live</h5>
                <form method="POST">
                    <input type="hidden" name="action" value="atribuir_epg_massa">
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">1. Selecionar Arquivo EPG</label>
                            <select name="epg_id" class="form-select" required>
                                <option value="">Selecione o arquivo EPG principal...</option>
                                <?php foreach($epg_arquivos as $e): ?>
                                    <option value="<?= $e['id'] ?>"><?= $e['epg_name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                            <div class="form-text">Qual arquivo XML (lista de IDs) será usado.</div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">2. Canal EPG ID Padrão (XMLTV ID)</label>
                            <input type="text" name="epg_channel_id_padrao" class="form-control" placeholder="Ex: Globo.br (Deixe Vazio para usar o Stream ID)">
                            <div class="form-text">Insira o ID de EPG que você quer atribuir a TODOS os canais. Deixe vazio para usar o ID interno da stream.</div>
                        </div>
                    </div>

                    <div class="alert alert-warning mt-3">
                        **Atenção:** Este processo irá aplicar o mesmo "Canal EPG ID Padrão" a **TODOS** os canais Live (type=1) do seu sistema. Use com cautela!
                    </div>

                    <button type="submit" class="btn btn-primary fw-bold" onclick="return confirm('Confirmar atribuição em massa de EPG para TODOS os canais Live?')">
                        <i class="fas fa-save me-1"></i> Atribuir EPG em Massa
                    </button>
                </form>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-canais" role="tabpanel">
            <div class="k-card">
                 <div class="p-3 bg-light">
                    <span class="text-muted small">Mapeamento EPG nos Canais (Limite: 500 registros)</span>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3" width="10%">ID Mapeamento</th>
                                <th width="35%">Nome do Canal (Stream)</th>
                                <th width="35%">EPG ID (XMLTV ID)</th>
                                <th width="20%">Arquivo EPG</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($epg_canais as $c): ?>
                            <tr>
                                <td class="ps-3 text-muted small">#<?= $c['id'] ?></td>
                                <td><span class="fw-bold"><?= $c['stream_display_name'] ?? 'Canal Deletado' ?></span></td>
                                <td><code><?= $c['channel_id'] ?></code></td>
                                <td><?= $c['epg_name'] ?? 'N/A' ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>

<div class="modal fade" id="modalAddEPG" tabindex="-1">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"><i class="fas fa-plus me-2"></i> Adicionar Novo Arquivo EPG</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="add_epg_file">

                    <div class="mb-3">
                        <label class="form-label fw-bold">Nome do EPG (Interno)</label>
                        <input type="text" name="epg_name" class="form-control" placeholder="Ex: EPG Brasil Geral" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">URL do Arquivo XMLTV</label>
                        <input type="url" name="epg_file" class="form-control" placeholder="Ex: http://servidor.com/epg.xml.gz" required>
                        <div class="form-text">O URL para o arquivo XMLTV/GZ.</div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Dias para Manter Dados</label>
                        <input type="number" name="days_keep" class="form-control" value="7" min="1" required>
                        <div class="form-text">Por quantos dias o painel deve guardar o guia.</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary fw-bold"><i class="fas fa-plus me-1"></i> Adicionar EPG</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditEPG" tabindex="-1">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title"><i class="fas fa-pen me-2"></i> Editar Arquivo EPG</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="edit_epg_file">
                    <input type="hidden" name="edit_id" id="edit_id">

                    <div class="mb-3">
                        <label class="form-label fw-bold">Nome do EPG (Interno)</label>
                        <input type="text" name="edit_epg_name" id="edit_epg_name" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">URL do Arquivo XMLTV</label>
                        <input type="url" name="edit_epg_file" id="edit_epg_file" class="form-control" required>
                        <div class="form-text">O URL para o arquivo XMLTV/GZ.</div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Dias para Manter Dados</label>
                        <input type="number" name="edit_days_keep" id="edit_days_keep" class="form-control" min="1" required>
                        <div class="form-text">Por quantos dias o painel deve guardar o guia.</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-info fw-bold"><i class="fas fa-save me-1"></i> Salvar Edição</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    // Função para abrir o modal de edição e preencher os campos
    function abrirModalEdicao(id, name, file, days) {
        // Preenche os campos do formulário
        $('#edit_id').val(id);
        $('#edit_epg_name').val(name);
        $('#edit_epg_file').val(file);
        $('#edit_days_keep').val(days);

        // Exibe o modal
        var modal = new bootstrap.Modal(document.getElementById('modalEditEPG'));
        modal.show();
    }
</script>

</body>
</html>
