<?php
require 'config.php'; 
require 'header.php'; 

// --- SEGURANÇA: APENAS ADMIN ---
$grupo = $_SESSION['group_id'] ?? 0;
if ($grupo != 1) { 
    echo "<script>window.location='index.php';</script>"; 
    exit; 
}

// ====================================================================
// --- LÓGICA DE AÇÕES ---
// ====================================================================

// Ação 1: Limpar LOGS (Limpa detect_restream_logs)
if (isset($_GET['clear_logs'])) {
    $pdo->query("TRUNCATE TABLE detect_restream_logs");
    $mensagem = "Logs de detecção limpos com sucesso!";
    $tipo_msg = "success";
}

// Ação 2: Desbloquear IP e Remover da Lista Ativa (Limpa detect_restream)
// No contexto da tabela detect_restream, 'desbloquear' significa remover o registro ativo.
if (isset($_GET['del_restream'])) {
    $id = (int)$_GET['del_restream'];
    $pdo->query("DELETE FROM detect_restream WHERE id = $id");
    $mensagem = "Registro de restream removido com sucesso!";
    $tipo_msg = "success";
}

// Ação 3: Marcar/Desmarcar como Bloqueado na Lista Ativa
// A tabela detect_restream tem a coluna 'blocked' (Imagem 1000650719.jpg)
if (isset($_GET['toggle_block'])) {
    $id = (int)$_GET['toggle_block'];
    // Inverte o valor atual (1 para 0, 0 para 1)
    $pdo->query("UPDATE detect_restream SET blocked = 1 - blocked WHERE id = $id");
    $mensagem = "Status de bloqueio alterado com sucesso!";
    $tipo_msg = "success";
}

// ====================================================================
// --- BUSCAR DADOS ---
// ====================================================================

// Tabela 1: Monitoramento Ativo (detect_restream)
$restream_ativo = $pdo->query("SELECT id, ip, blocked, ports_open, FROM_UNIXTIME(time) as last_check FROM detect_restream ORDER BY time DESC")->fetchAll(PDO::FETCH_ASSOC);

// Tabela 2: Logs de Detecção (detect_restream_logs)
$logs = $pdo->query("SELECT id, user_id, stream_id, ip, FROM_UNIXTIME(time) as detection_time FROM detect_restream_logs ORDER BY time DESC LIMIT 500")->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
    .k-card { background: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 25px; }
    .table thead th { font-size: 0.75rem; text-transform: uppercase; color: #6c757d; background-color: #f8f9fa; }
    .nav-pills .nav-link { font-weight: bold; }
    code { font-size: 0.8rem; background-color: #f0f0f0; padding: 2px 4px; border-radius: 3px; }
</style>

<div class="container-fluid py-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0 text-dark"><i class="fas fa-satellite-dish me-2 text-primary"></i>Gerenciar Restream</h4>
    </div>

    <?php if (isset($mensagem)): ?>
    <div class="alert alert-<?= $tipo_msg ?> alert-dismissible fade show" role="alert">
        <?= $mensagem ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="pill" data-bs-target="#pills-ativo" type="button">
                Monitoramento Ativo (<?= count($restream_ativo) ?>)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-logs" type="button">
                Logs de Detecção (<?= count($logs) ?>)
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pills-tabContent">
        
        <div class="tab-pane fade show active" id="pills-ativo" role="tabpanel">
            <div class="k-card">
                <div class="p-3 bg-light d-flex justify-content-between align-items-center">
                    <span class="text-muted small">Registros ativos de IPs com indícios de restream (portas abertas).</span>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3" width="10%">ID</th>
                                <th width="20%">Endereço IP</th>
                                <th width="35%">Portas Abertas</th>
                                <th width="15%">Última Checagem</th>
                                <th width="10%">Bloqueado?</th>
                                <th width="10%" class="text-end pe-3">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($restream_ativo as $r): ?>
                            <tr>
                                <td class="ps-3 text-muted small">#<?= $r['id'] ?></td>
                                <td><span class="badge bg-dark fw-bold"><?= $r['ip'] ?></span></td>
                                <td><?= empty($r['ports_open']) ? 'N/A' : $r['ports_open'] ?></td>
                                <td><?= $r['last_check'] ?></td>
                                <td>
                                    <span class="badge bg-<?= $r['blocked'] ? 'danger' : 'success' ?>">
                                        <?= $r['blocked'] ? 'SIM' : 'NÃO' ?>
                                    </span>
                                </td>
                                <td class="text-end pe-3">
                                    <a href="?toggle_block=<?= $r['id'] ?>" class="btn btn-sm btn-outline-<?= $r['blocked'] ? 'success' : 'danger' ?>" title="<?= $r['blocked'] ? 'Desbloquear' : 'Bloquear' ?>">
                                        <i class="fas fa-<?= $r['blocked'] ? 'unlock' : 'lock' ?>"></i>
                                    </a>
                                    <a href="?del_restream=<?= $r['id'] ?>" class="btn btn-sm btn-outline-secondary" onclick="return confirm('Remover este registro?')" title="Remover Registro">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-logs" role="tabpanel">
            <div class="k-card">
                 <div class="p-3 bg-light d-flex justify-content-between align-items-center">
                    <span class="text-muted small">Registros históricos de acessos que dispararam o monitoramento (limitado aos últimos 500).</span>
                    <a href="?clear_logs=1" class="btn btn-sm btn-outline-danger" onclick="return confirm('TEM CERTEZA? Isso irá apagar todos os logs de restream.')">
                        <i class="fas fa-eraser me-1"></i> Limpar Logs
                    </a>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3" width="10%">ID</th>
                                <th width="20%">IP do Cliente</th>
                                <th width="20%">ID do Usuário</th>
                                <th width="20%">ID do Stream</th>
                                <th width="30%">Data/Hora da Detecção</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($logs as $l): ?>
                            <tr>
                                <td class="ps-3 text-muted small">#<?= $l['id'] ?></td>
                                <td><span class="badge bg-dark"><?= $l['ip'] ?></span></td>
                                <td><?= $l['user_id'] ?></td>
                                <td><?= $l['stream_id'] ?></td>
                                <td><?= $l['detection_time'] ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
