<?php
require 'config.php'; 
require 'header.php'; 

// --- SEGURANÇA: APENAS ADMIN ---
$grupo = $_SESSION['group_id'] ?? 0;
if ($grupo != 1) { 
    echo "<script>window.location='index.php';</script>"; 
    exit; 
}

// ====================================================================
// --- LÓGICA DE AÇÕES ---
// ====================================================================

$mensagem = '';
$tipo_msg = '';

// Ação 1: Deletar Servidor
if (isset($_GET['del_server'])) {
    $id = (int)$_GET['del_server'];
    
    $pdo->query("DELETE FROM servers WHERE id = $id");

    $mensagem = "Servidor #$id deletado com sucesso!";
    $tipo_msg = "success";
}

// Ação 2: Adicionar Novo Servidor (Básico)
if (isset($_POST['action']) && $_POST['action'] == 'add_server') {
    $server_name = trim($_POST['server_name']);
    $domain_name = trim($_POST['domain_name']);
    $server_ip = trim($_POST['server_ip']);
    $is_main = (int)$_POST['is_main'];
    $enabled = (int)$_POST['enabled'];
    $http_broadcast_port = (int)$_POST['http_broadcast_port'];

    if (!empty($server_name) && !empty($server_ip)) {
        try {
            $sql = "INSERT INTO servers (server_name, domain_name, server_ip, is_main, enabled, http_broadcast_port, server_type) 
                    VALUES (?, ?, ?, ?, ?, ?, 1)"; // server_type=1 (Padrão)
            $pdo->prepare($sql)->execute([$server_name, $domain_name, $server_ip, $is_main, $enabled, $http_broadcast_port]);

            $mensagem = "Servidor '$server_name' adicionado com sucesso!";
            $tipo_msg = "success";
        } catch (PDOException $e) {
            $mensagem = "Erro: Falha no banco de dados ao adicionar servidor.";
            $tipo_msg = "danger";
        }
    } else {
        $mensagem = "Erro: Nome e IP do Servidor são obrigatórios.";
        $tipo_msg = "danger";
    }
}

// Ação 3: Editar Servidor (Básico)
if (isset($_POST['action']) && $_POST['action'] == 'edit_server') {
    $id = (int)$_POST['edit_id'];
    $server_name = trim($_POST['edit_server_name']);
    $domain_name = trim($_POST['edit_domain_name']);
    $server_ip = trim($_POST['edit_server_ip']);
    $is_main = (int)$_POST['edit_is_main'];
    $enabled = (int)$_POST['edit_enabled'];
    $http_broadcast_port = (int)$_POST['edit_http_broadcast_port'];

    if ($id > 0 && !empty($server_name) && !empty($server_ip)) {
        $sql = "UPDATE servers SET server_name=?, domain_name=?, server_ip=?, is_main=?, enabled=?, http_broadcast_port=? WHERE id=?";
        $pdo->prepare($sql)->execute([$server_name, $domain_name, $server_ip, $is_main, $enabled, $http_broadcast_port, $id]);
        
        $mensagem = "Servidor '$server_name' editado com sucesso!";
        $tipo_msg = "success";
    } else {
        $mensagem = "Erro: Dados inválidos na edição.";
        $tipo_msg = "danger";
    }
}


// ====================================================================
// --- BUSCAR DADOS ---
// ====================================================================

// Tabela 1: Gestão de Servidores (servers)
$servers = $pdo->query("SELECT id, server_name, domain_name, server_ip, is_main, enabled, http_broadcast_port, total_clients, status, total_services, xui_revision FROM servers ORDER BY is_main DESC, server_name ASC")->fetchAll(PDO::FETCH_ASSOC);

// Tabela 2: Monitoramento/Estatísticas (servers_stats)
$stats = $pdo->query("
    SELECT 
        s.server_name, ss.connections, ss.streams, ss.users, ss.cpu, ss.total_mem_used_percent, ss.uptime 
    FROM servers_stats ss
    JOIN servers s ON ss.server_id = s.id
    ORDER BY ss.id DESC 
    LIMIT 20
")->fetchAll(PDO::FETCH_ASSOC);

// Tabela 3: Logs de Atividade do Servidor (server_activity)
$server_logs = $pdo->query("
    SELECT 
        sa.id, sa.date_start, sa.date_end, sa.bandwidth,
        ss.server_name AS source_server_name, 
        sd.server_name AS dest_server_name
    FROM server_activity sa
    LEFT JOIN servers ss ON sa.source_server_id = ss.id
    LEFT JOIN servers sd ON sa.dest_server_id = sd.id
    ORDER BY sa.date_start DESC
    LIMIT 100
")->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
    .k-card { background: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 25px; }
    .table thead th { font-size: 0.75rem; text-transform: uppercase; color: #6c757d; background-color: #f8f9fa; }
    .nav-pills .nav-link { font-weight: bold; }
    .status-badge { padding: 4px 8px; border-radius: 12px; font-weight: bold; font-size: 0.8rem; }
</style>

<div class="container-fluid py-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0 text-dark"><i class="fas fa-server me-2 text-warning"></i>Gerenciar Servidores</h4>
        <button class="btn btn-warning text-dark fw-bold shadow-sm" data-bs-toggle="modal" data-bs-target="#modalAddServer">
            <i class="fas fa-plus me-2"></i> Adicionar Servidor
        </button>
    </div>

    <?php if (isset($mensagem) && !empty($mensagem)): ?>
    <div class="alert alert-<?= $tipo_msg ?> alert-dismissible fade show" role="alert">
        <?= $mensagem ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="pill" data-bs-target="#pills-gestao" type="button">
                Gestão (<?= count($servers) ?>)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-monitoramento" type="button">
                Monitoramento (CPU/RAM)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-logs" type="button">
                Logs de Atividade (<?= count($server_logs) ?>)
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pills-tabContent">
        
        <div class="tab-pane fade show active" id="pills-gestao" role="tabpanel">
            <div class="k-card">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3" width="5%">ID</th>
                                <th width="15%">Nome / Main</th>
                                <th width="15%">IP / Domínio</th>
                                <th width="10%">Broadcast Port</th>
                                <th width="10%">Clientes / Serviços</th>
                                <th width="10%">Status</th>
                                <th width="15%">Revisão XUI</th>
                                <th width="10%" class="text-end pe-3">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($servers as $s): ?>
                            <tr>
                                <td class="ps-3 text-muted small">#<?= $s['id'] ?></td>
                                <td>
                                    <span class="fw-bold"><?= $s['server_name'] ?></span>
                                    <?php if ($s['is_main']): ?>
                                        <span class="badge bg-warning text-dark ms-1">MAIN</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?= $s['server_ip'] ?><br>
                                    <small class="text-muted"><?= $s['domain_name'] ?></small>
                                </td>
                                <td><?= $s['http_broadcast_port'] ?></td>
                                <td><?= $s['total_clients'] ?> Clientes / <?= $s['total_services'] ?> Serv.</td>
                                <td>
                                    <?php 
                                    $status_map = [0 => 'Inativo', 1 => 'Ativo', 2 => 'Aguardando'];
                                    $status_class = [0 => 'danger', 1 => 'success', 2 => 'secondary'];
                                    ?>
                                    <span class="badge bg-<?= $status_class[$s['status']] ?? 'secondary' ?> status-badge">
                                        <?= $status_map[$s['status']] ?? 'Desconhecido' ?>
                                    </span>
                                    <span class="badge bg-<?= $s['enabled'] ? 'success' : 'danger' ?>">
                                        <?= $s['enabled'] ? 'Ligado' : 'Desligado' ?>
                                    </span>
                                </td>
                                <td><?= $s['xui_revision'] ?></td>
                                <td class="text-end pe-3 btn-action-group">
                                    <button class="btn btn-sm btn-outline-info me-1" 
                                        onclick='abrirModalEdicaoServer(<?= json_encode($s) ?>)'>
                                        <i class="fas fa-pen"></i>
                                    </button>
                                    <a href="?del_server=<?= $s['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Deseja realmente deletar o servidor <?= $s['server_name'] ?>?')">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-monitoramento" role="tabpanel">
            <div class="k-card">
                 <div class="p-3 bg-light">
                    <span class="text-muted small">Estatísticas de performance dos servidores (Dados mais recentes).</span>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3" width="20%">Servidor</th>
                                <th width="15%">Conexões</th>
                                <th width="15%">Streams Ativas</th>
                                <th width="15%">Usuários Ativos</th>
                                <th width="10%">Uso CPU</th>
                                <th width="15%">Uso RAM (%)</th>
                                <th width="10%">Uptime</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($stats as $st): ?>
                            <tr>
                                <td class="ps-3 fw-bold"><?= $st['server_name'] ?></td>
                                <td><?= $st['connections'] ?></td>
                                <td><?= $st['streams'] ?></td>
                                <td><?= $st['users'] ?></td>
                                <td>
                                    <span class="badge bg-<?= ($st['cpu'] > 80) ? 'danger' : (($st['cpu'] > 50) ? 'warning' : 'success') ?>">
                                        <?= number_format($st['cpu'], 1) ?>%
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-<?= ($st['total_mem_used_percent'] > 80) ? 'danger' : (($st['total_mem_used_percent'] > 60) ? 'warning' : 'success') ?>">
                                        <?= number_format($st['total_mem_used_percent'], 1) ?>%
                                    </span>
                                </td>
                                <td><?= $st['uptime'] ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-logs" role="tabpanel">
            <div class="k-card">
                 <div class="p-3 bg-light">
                    <span class="text-muted small">Registros de atividades entre servidores (transcodificação/proxy/load balancing). Limite: 100 logs.</span>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3" width="10%">ID Log</th>
                                <th width="20%">Servidor Origem</th>
                                <th width="20%">Servidor Destino</th>
                                <th width="20%">Banda (Kbps)</th>
                                <th width="15%">Início</th>
                                <th width="15%">Fim</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($server_logs as $l): 
                                $date_start = date('Y-m-d H:i:s', $l['date_start']);
                                $date_end = ($l['date_end'] > 0) ? date('Y-m-d H:i:s', $l['date_end']) : '<span class="text-success fw-bold">ATIVA</span>';
                                $bandwidth_mbps = number_format($l['bandwidth'] / 1024, 2); // De KBPS para Mbps
                            ?>
                            <tr>
                                <td class="ps-3 text-muted small">#<?= $l['id'] ?></td>
                                <td><?= $l['source_server_name'] ?? 'N/A' ?></td>
                                <td><?= $l['dest_server_name'] ?? 'N/A' ?></td>
                                <td><?= $bandwidth_mbps ?> Mbps</td>
                                <td><?= $date_start ?></td>
                                <td><?= $date_end ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>

<div class="modal fade" id="modalAddServer" tabindex="-1">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title"><i class="fas fa-plus me-2"></i> Adicionar Novo Servidor</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="add_server">

                    <div class="mb-3">
                        <label class="form-label fw-bold">Nome do Servidor</label>
                        <input type="text" name="server_name" class="form-control" placeholder="Ex: Master BR ou Load Balancer 01" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">IP (Principal)</label>
                        <input type="text" name="server_ip" class="form-control" placeholder="Ex: 192.168.1.1 ou 203.0.113.45" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Domínio (Opcional)</label>
                        <input type="text" name="domain_name" class="form-control" placeholder="Ex: stream.meuservidor.com">
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Porta Broadcast (HTTP)</label>
                            <input type="number" name="http_broadcast_port" class="form-control" value="80">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Status Inicial</label>
                            <select name="enabled" class="form-select">
                                <option value="1">1 - Ligado</option>
                                <option value="0">0 - Desligado</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" value="1" id="is_main_check" name="is_main">
                        <label class="form-check-label fw-bold" for="is_main_check">
                            Definir como Servidor Principal (is_main)
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-warning text-dark fw-bold"><i class="fas fa-save me-1"></i> Adicionar Servidor</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditServer" tabindex="-1">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title"><i class="fas fa-pen me-2"></i> Editar Servidor</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="edit_server">
                    <input type="hidden" name="edit_id" id="edit_id">

                    <div class="mb-3">
                        <label class="form-label fw-bold">Nome do Servidor</label>
                        <input type="text" name="edit_server_name" id="edit_server_name" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">IP (Principal)</label>
                        <input type="text" name="edit_server_ip" id="edit_server_ip" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Domínio (Opcional)</label>
                        <input type="text" name="edit_domain_name" id="edit_domain_name" class="form-control">
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Porta Broadcast (HTTP)</label>
                            <input type="number" name="edit_http_broadcast_port" id="edit_http_broadcast_port" class="form-control">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Status (Enabled)</label>
                            <select name="edit_enabled" id="edit_enabled" class="form-select">
                                <option value="1">1 - Ligado</option>
                                <option value="0">0 - Desligado</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" value="1" id="edit_is_main_check" name="edit_is_main">
                        <label class="form-check-label fw-bold" for="edit_is_main_check">
                            Definir como Servidor Principal (is_main)
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-info text-white fw-bold"><i class="fas fa-save me-1"></i> Salvar Edição</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    // Função para abrir o modal de edição e preencher os campos
    function abrirModalEdicaoServer(s) {
        // Preenche os campos do formulário
        $('#edit_id').val(s.id);
        $('#edit_server_name').val(s.server_name);
        $('#edit_domain_name').val(s.domain_name);
        $('#edit_server_ip').val(s.server_ip);
        $('#edit_http_broadcast_port').val(s.http_broadcast_port);
        $('#edit_enabled').val(s.enabled);
        
        // Checkbox para Servidor Principal
        $('#edit_is_main_check').prop('checked', s.is_main == 1);

        // Exibe o modal
        var modal = new bootstrap.Modal(document.getElementById('modalEditServer'));
        modal.show();
    }
</script>
</body>
</html>
