<?php
// get.php - Versão PADRÃO XTREAM GLOBAL (Copia exata da estrutura oficial)
ini_set('display_errors', 0);
error_reporting(0);
set_time_limit(0);

require_once 'config.php';
if (!isset($pdo)) { die("Erro conexao"); }

// =======================================================================
// MODO DOWNLOAD DE LISTA M3U
// =======================================================================
if (isset($_GET['username']) && isset($_GET['password'])) {
    $username = $_GET['username'];
    $password = $_GET['password'];

    // 1. Validação
    try {
        $stmt = $pdo->prepare("SELECT id, username, exp_date FROM `lines` WHERE username = :u AND password = :p AND enabled = 1 LIMIT 1");
        $stmt->execute(['u' => $username, 'p' => $password]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (Exception $e) { die(); }

    if (!$user) { http_response_code(401); die("Auth Failed"); }
    if (!empty($user['exp_date']) && $user['exp_date'] < time()) { die("Expired"); }

    // 2. Cabeçalhos
    if (ob_get_level()) ob_end_clean();
    header("Content-Type: application/x-mpegurl");
    header('Content-Disposition: attachment; filename="lista.m3u"');

    // URL Base
    $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http");
    $host = $_SERVER['HTTP_HOST'];
    $baseUrl = "$protocol://$host";

    echo "#EXTM3U\n";

    // 3. Carrega Categorias
    $categorias = [];
    $sqlCat = "SELECT id, category_name FROM streams_categories";
    foreach ($pdo->query($sqlCat) as $cat) {
        $categorias[$cat['id']] = $cat['category_name'];
    }

    // 4. Busca Streams
    // Pegamos Live (1), Filmes (2) e Episódios de Séries (5)
    $sql = "SELECT id, stream_display_name, stream_icon, type, category_id, target_container FROM streams ORDER BY id ASC";
    $q = $pdo->query($sql);

    while ($stream = $q->fetch(PDO::FETCH_ASSOC)) {
        // Limpa ID da categoria
        $catIDLimpo = str_replace(['[', ']', '"'], '', $stream['category_id']);
        $groupTitle = isset($categorias[$catIDLimpo]) ? $categorias[$catIDLimpo] : "Sem Categoria";

        $id   = $stream['id'];
        $name = str_replace([',', '"', "\r", "\n"], '', $stream['stream_display_name']);
        $logo = $stream['stream_icon'];
        $type = (int)$stream['type']; 
        
        // Pega extensão do banco, mas se for vazia, define padrão
        $extDb = $stream['target_container'];
        
        // --- LÓGICA RÍGIDA DO XTREAM CODES ---
        $finalUrl = "";

        if ($type === 2) { 
            // === FILMES (VOD) ===
            // Força extensão de vídeo se não tiver
            $ext = $extDb ? $extDb : 'mp4';
            $finalUrl = "{$baseUrl}/movie/{$username}/{$password}/{$id}.{$ext}";

        } elseif ($type === 3 || $type === 5) { 
            // === SÉRIES ===
            // O SEGREDO: Séries PRECISAM estar na pasta /series/ e ter extensão de vídeo (.mp4/.mkv)
            // Se o banco tiver .ts na série, FORÇAMOS .mp4 para o importador entender que não é canal
            $ext = ($extDb && $extDb != 'ts') ? $extDb : 'mp4';
            
            $finalUrl = "{$baseUrl}/series/{$username}/{$password}/{$id}.{$ext}";

        } else {
            // === CANAIS (LIVE) ===
            // Canais sempre são .ts
            $finalUrl = "{$baseUrl}/live/{$username}/{$password}/{$id}.ts";
        }

        echo "#EXTINF:-1 tvg-id=\"$id\" tvg-logo=\"$logo\" group-title=\"$groupTitle\", $name\n";
        echo "$finalUrl\n";
    }
    exit;
}

// =======================================================================
// MODO PLAYER
// =======================================================================

$stream_id = (int)($_GET['stream_id'] ?? 0);
if ($stream_id == 0 && preg_match('/\/([0-9]+)\./', $_SERVER['REQUEST_URI'], $matches)) {
    $stream_id = (int)$matches[1];
}
if ($stream_id == 0) { http_response_code(404); die(); }

// Busca Link
$stmt = $pdo->prepare("SELECT stream_source FROM streams WHERE id = ? LIMIT 1");
$stmt->execute([$stream_id]);
$source = $stmt->fetchColumn();

if (!$source) { http_response_code(404); die(); }

$link = "";
$decoded = json_decode($source, true);
if (is_array($decoded) && isset($decoded[0])) {
    $link = $decoded[0];
} else {
    $clean = str_replace(['[', ']', '"', '\\', "\r", "\n"], '', $source);
    $parts = explode(',', $clean);
    $link = trim($parts[0]);
}
$link = trim($link);

// Força HTTP e Limpa Espaços
if (stripos($link, 'https://') === 0) {
    $link = 'http://' . substr($link, 8);
} elseif (stripos($link, 'http://') !== 0 && !empty($link)) {
    $link = 'http://' . $link;
}
$link = str_replace(' ', '%20', $link);

if (!empty($link)) {
    header("Location: " . $link);
    exit;
} else {
    http_response_code(404);
}
?>